/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.spring;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class TapestyBeanFactory
extends DefaultListableBeanFactory {
    private final Registry registry;

    public TapestyBeanFactory(BeanFactory parentBeanFactory, Registry registry) {
        super(parentBeanFactory);
        this.registry = registry;
    }

    public Object resolveDependency(DependencyDescriptor descriptor, String beanName, Set autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        AnnotationProvider provider;
        Class objectType = descriptor.getDependencyType();
        final Object[] annotations = descriptor.getAnnotations();
        if (annotations != null && ((provider = new AnnotationProvider(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                for (Object a : annotations) {
                    if (!annotationClass.isInstance(a)) continue;
                    return (T)((Annotation)annotationClass.cast(a));
                }
                return null;
            }
        }).getAnnotation(Inject.class) != null || provider.getAnnotation(InjectService.class) != null)) {
            return this.registry.getObject(objectType, provider);
        }
        return super.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
    }
}

