/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaGridDataSource<E>
implements GridDataSource {
    private final EntityManager entityManager;
    private final Class<E> entityType;
    private int startIndex;
    private List<E> preparedResults;

    public JpaGridDataSource(EntityManager entityManager, Class<E> entityType) {
        this.entityManager = entityManager;
        this.entityType = entityType;
    }

    public int getAvailableRows() {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(this.entityType);
        criteria = criteria.select((Selection)builder.count((Expression)root));
        this.applyAdditionalConstraints(criteria, root, builder);
        return ((Long)this.entityManager.createQuery(criteria).getSingleResult()).intValue();
    }

    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.entityType);
        Root root = criteria.from(this.entityType);
        this.applyAdditionalConstraints(criteria.select((Selection)root), root, builder);
        for (SortConstraint constraint : sortConstraints) {
            String propertyName = constraint.getPropertyModel().getPropertyName();
            Path propertyPath = root.get(propertyName);
            switch (constraint.getColumnSort()) {
                case ASCENDING: {
                    criteria.orderBy(new Order[]{builder.asc((Expression)propertyPath)});
                    break;
                }
                case DESCENDING: {
                    criteria.orderBy(new Order[]{builder.desc((Expression)propertyPath)});
                    break;
                }
            }
        }
        TypedQuery query = this.entityManager.createQuery(criteria);
        query.setFirstResult(startIndex);
        query.setMaxResults(endIndex - startIndex + 1);
        this.startIndex = startIndex;
        this.preparedResults = query.getResultList();
    }

    protected void applyAdditionalConstraints(CriteriaQuery<?> criteria, Root<E> root, CriteriaBuilder builder) {
    }

    public Object getRowValue(int index) {
        return this.preparedResults.get(index - this.startIndex);
    }

    public Class<E> getRowType() {
        return this.entityType;
    }
}

