/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.vlib.ejb.impl;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.tapestry.contrib.ejb.XEJBException;
import org.apache.tapestry.vlib.ejb.IKeyAllocator;
import org.apache.tapestry.vlib.ejb.IKeyAllocatorHome;

public abstract class AbstractEntityBean
implements EntityBean {
    private EntityContext _context;
    private transient String[] _attributePropertyNames;
    private transient IKeyAllocatorHome _keyAllocatorHome;
    private transient Context _environment;

    public void setEntityContext(EntityContext context) {
        this._context = context;
    }

    public void unsetEntityContext() {
        this._context = null;
    }

    protected Object getEnvironmentObject(String name, Class objectClass) throws RemoteException, NamingException {
        Object result = null;
        if (this._environment == null) {
            InitialContext initial = new InitialContext();
            this._environment = (Context)initial.lookup("java:comp/env");
        }
        Object raw = this._environment.lookup(name);
        try {
            result = PortableRemoteObject.narrow((Object)raw, (Class)objectClass);
        }
        catch (ClassCastException ex) {
            throw new RemoteException("Could not narrow " + raw + " (" + name + ") to class " + objectClass + ".");
        }
        return result;
    }

    public void ejbActivate() throws RemoteException {
    }

    public void ejbPassivate() throws RemoteException {
    }

    public void ejbRemove() throws RemoteException {
    }

    public void ejbLoad() throws RemoteException {
    }

    public void ejbStore() throws RemoteException {
    }

    protected Integer allocateKey() throws RemoteException {
        IKeyAllocator allocator;
        if (this._keyAllocatorHome == null) {
            try {
                InitialContext initial = new InitialContext();
                Context environment = (Context)initial.lookup("java:comp/env");
                Object raw = environment.lookup("ejb/KeyAllocator");
                this._keyAllocatorHome = (IKeyAllocatorHome)PortableRemoteObject.narrow((Object)raw, IKeyAllocatorHome.class);
            }
            catch (NamingException ex) {
                throw new XEJBException("Unable to locate IKeyAllocatorHome.", (Throwable)ex);
            }
        }
        try {
            allocator = this._keyAllocatorHome.create();
        }
        catch (CreateException ex) {
            throw new RemoteException("Unable to create a KeyAllocator from " + this._keyAllocatorHome + ".", ex);
        }
        return allocator.allocateKey();
    }

    protected abstract String[] getAttributePropertyNames();

    public Map getEntityAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this._attributePropertyNames == null) {
            this._attributePropertyNames = this.getAttributePropertyNames();
        }
        for (int i = 0; i < this._attributePropertyNames.length; ++i) {
            String key = this._attributePropertyNames[i];
            try {
                Object value = Ognl.getValue((String)key, (Object)this);
                result.put(key, value);
                continue;
            }
            catch (OgnlException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public void updateEntityAttributes(Map update) {
        if (this._attributePropertyNames == null) {
            this._attributePropertyNames = this.getAttributePropertyNames();
        }
        for (int i = 0; i < this._attributePropertyNames.length; ++i) {
            String key = this._attributePropertyNames[i];
            if (!update.containsKey(key)) continue;
            Object value = update.get(key);
            try {
                Ognl.setValue((String)key, (Object)this, value);
                continue;
            }
            catch (OgnlException ex) {
                // empty catch block
            }
        }
    }

    protected void setContext(EntityContext context) {
        this._context = context;
    }

    protected EntityContext geEntityContext() {
        return this._context;
    }
}

