/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.vlib.ejb.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.tapestry.contrib.ejb.XEJBException;
import org.apache.tapestry.contrib.jdbc.IStatement;
import org.apache.tapestry.contrib.jdbc.StatementAssembly;
import org.apache.tapestry.vlib.ejb.Book;
import org.apache.tapestry.vlib.ejb.MasterQueryParameters;
import org.apache.tapestry.vlib.ejb.SortOrdering;
import org.apache.tapestry.vlib.ejb.impl.OperationsBean;

public class BookQueryBean
extends OperationsBean {
    private static final long serialVersionUID = 8782046868254488388L;
    private Book[] _results;

    public void ejbRemove() {
        this._results = null;
    }

    public int getResultCount() {
        if (this._results == null) {
            return 0;
        }
        return this._results.length;
    }

    public Book[] get(int offset, int length) {
        if (offset < 0) {
            return null;
        }
        int finalLength = Math.min(length, this._results.length - offset);
        if (finalLength < 0) {
            return null;
        }
        Book[] result = new Book[finalLength];
        System.arraycopy(this._results, offset, result, 0, finalLength);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int masterQuery(MasterQueryParameters parameters, SortOrdering sortOrdering) {
        IStatement statement = null;
        Connection connection = null;
        this._results = null;
        try {
            connection = this.getConnection();
            try {
                statement = this.buildMasterQuery(connection, parameters, sortOrdering);
            }
            catch (SQLException ex) {
                throw new XEJBException("Unable to create query statement.", (Throwable)ex);
            }
            this.processQuery(statement);
        }
        catch (Throwable throwable) {
            this.close(connection, statement, null);
            throw throwable;
        }
        this.close(connection, statement, null);
        return this.getResultCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ownerQuery(Integer ownerId, SortOrdering sortOrdering) {
        IStatement statement = null;
        Connection connection = null;
        this._results = null;
        try {
            connection = this.getConnection();
            try {
                statement = this.buildPersonQuery(connection, "owner.PERSON_ID", ownerId, sortOrdering);
            }
            catch (SQLException ex) {
                throw new XEJBException("Unable to create query statement.", (Throwable)ex);
            }
            this.processQuery(statement);
        }
        catch (Throwable throwable) {
            this.close(connection, statement, null);
            throw throwable;
        }
        this.close(connection, statement, null);
        return this.getResultCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int holderQuery(Integer holderId, SortOrdering sortOrdering) {
        IStatement statement = null;
        Connection connection = null;
        this._results = null;
        try {
            connection = this.getConnection();
            try {
                statement = this.buildPersonQuery(connection, "holder.PERSON_ID", holderId, sortOrdering);
            }
            catch (SQLException ex) {
                throw new XEJBException("Unable to create query statement.", (Throwable)ex);
            }
            this.processQuery(statement);
        }
        catch (Throwable throwable) {
            this.close(connection, statement, null);
            throw throwable;
        }
        this.close(connection, statement, null);
        return this.getResultCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int borrowerQuery(Integer borrowerId, SortOrdering sortOrdering) {
        IStatement statement = null;
        Connection connection = null;
        this._results = null;
        try {
            connection = this.getConnection();
            try {
                statement = this.buildBorrowerQuery(connection, borrowerId, sortOrdering);
            }
            catch (SQLException ex) {
                throw new XEJBException("Unable to create query statement.", (Throwable)ex);
            }
            this.processQuery(statement);
        }
        catch (Throwable throwable) {
            this.close(connection, statement, null);
            throw throwable;
        }
        this.close(connection, statement, null);
        return this.getResultCount();
    }

    private void processQuery(IStatement statement) {
        ResultSet set = null;
        try {
            set = statement.executeQuery();
        }
        catch (SQLException ex) {
            throw new XEJBException("Unable to execute query.", (Throwable)ex);
        }
        try {
            this.processQueryResults(set);
        }
        catch (SQLException ex) {
            throw new XEJBException("Unable to process query results.", (Throwable)ex);
        }
        finally {
            this.close(null, null, set);
        }
    }

    private void processQueryResults(ResultSet set) throws SQLException {
        ArrayList<Book> list = new ArrayList<Book>();
        Object[] columns = new Object[14];
        while (set.next()) {
            Book book = this.convertRowToBook(set, columns);
            list.add(book);
        }
        this._results = new Book[list.size()];
        this._results = list.toArray(this._results);
    }

    private IStatement buildMasterQuery(Connection connection, MasterQueryParameters parameters, SortOrdering ordering) throws SQLException {
        String title = parameters.getTitle();
        String author = parameters.getAuthor();
        Integer publisherId = parameters.getPublisherId();
        Integer ownerId = parameters.getOwnerId();
        StatementAssembly assembly = this.buildBaseBookQuery();
        this.addSubstringSearch(assembly, "book.TITLE", title);
        this.addSubstringSearch(assembly, "book.AUTHOR", author);
        assembly.addSep(" AND ");
        assembly.add("book.HIDDEN = 0");
        if (publisherId != null) {
            assembly.addSep(" AND ");
            assembly.add("book.PUBLISHER_ID = ");
            assembly.addParameter(publisherId);
        }
        if (ownerId != null) {
            assembly.addSep(" AND ");
            assembly.add("book.OWNER_ID = ");
            assembly.addParameter(ownerId);
        }
        this.addSortOrdering(assembly, ordering);
        return assembly.createStatement(connection);
    }

    private IStatement buildPersonQuery(Connection connection, String personColumn, Integer personId, SortOrdering sortOrdering) throws SQLException {
        StatementAssembly assembly = this.buildBaseBookQuery();
        assembly.addSep(" AND ");
        assembly.add(personColumn);
        assembly.add(" = ");
        assembly.addParameter(personId);
        this.addSortOrdering(assembly, sortOrdering);
        return assembly.createStatement(connection);
    }

    private IStatement buildBorrowerQuery(Connection connection, Integer borrowerId, SortOrdering sortOrdering) throws SQLException {
        StatementAssembly assembly = this.buildBaseBookQuery();
        assembly.addSep(" AND ");
        assembly.add("book.HOLDER_ID = ");
        assembly.addParameter(borrowerId);
        assembly.addSep(" AND ");
        assembly.add("book.HOLDER_ID <> book.OWNER_ID");
        this.addSortOrdering(assembly, sortOrdering);
        return assembly.createStatement(connection);
    }
}

