/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.visitor;

import java.util.Stack;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.logical.BinaryNode;
import org.apache.tajo.plan.logical.CreateDatabaseNode;
import org.apache.tajo.plan.logical.DistinctGroupbyNode;
import org.apache.tajo.plan.logical.DropDatabaseNode;
import org.apache.tajo.plan.logical.ExceptNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.IntersectNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.PartitionedTableScanNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.StoreTableNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.visitor.BasicLogicalPlanVisitor;

public class ExplainLogicalPlanVisitor
extends BasicLogicalPlanVisitor<Context, LogicalNode> {
    public Context getBlockPlanStrings(@Nullable LogicalPlan plan, LogicalNode node) throws PlanningException {
        Stack<LogicalNode> stack = new Stack<LogicalNode>();
        Context explainContext = new Context();
        this.visit(explainContext, plan, null, node, stack);
        return explainContext;
    }

    @Override
    public LogicalNode visitRoot(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, LogicalRootNode node, Stack<LogicalNode> stack) throws PlanningException {
        return (LogicalNode)this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
    }

    @Override
    public LogicalNode visitProjection(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, ProjectionNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitLimit(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, LimitNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitSort(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, SortNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitHaving(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, HavingNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitGroupBy(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, GroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitWindowAgg(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, WindowAggNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitDistinctGroupby(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, DistinctGroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    private LogicalNode visitUnaryNode(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnaryNode node, Stack<LogicalNode> stack) throws PlanningException {
        ++context.depth;
        stack.push(node);
        this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        --context.depth;
        context.add(context.depth, node.getPlanString());
        return node;
    }

    private LogicalNode visitBinaryNode(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, BinaryNode node, Stack<LogicalNode> stack) throws PlanningException {
        ++context.depth;
        stack.push(node);
        this.visit(context, plan, block, (LogicalNode)node.getLeftChild(), stack);
        this.visit(context, plan, block, (LogicalNode)node.getRightChild(), stack);
        stack.pop();
        --context.depth;
        context.add(context.depth, node.getPlanString());
        return node;
    }

    @Override
    public LogicalNode visitFilter(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, SelectionNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitJoin(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitBinaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitUnion(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnionNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitBinaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitExcept(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, ExceptNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitBinaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitIntersect(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, IntersectNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitBinaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitTableSubQuery(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, TableSubQueryNode node, Stack<LogicalNode> stack) throws PlanningException {
        ++context.depth;
        stack.push(node);
        this.visit(context, plan, block, node.getSubQuery(), new Stack<LogicalNode>());
        stack.pop();
        --context.depth;
        context.add(context.depth, node.getPlanString());
        return node;
    }

    @Override
    public LogicalNode visitScan(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        context.add(context.depth, node.getPlanString());
        return node;
    }

    @Override
    public LogicalNode visitPartitionedTableScan(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, PartitionedTableScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        context.add(context.depth, node.getPlanString());
        return node;
    }

    @Override
    public LogicalNode visitStoreTable(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, StoreTableNode node, Stack<LogicalNode> stack) throws PlanningException {
        return this.visitUnaryNode(context, plan, block, node, stack);
    }

    @Override
    public LogicalNode visitCreateDatabase(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, CreateDatabaseNode node, Stack<LogicalNode> stack) throws PlanningException {
        context.add(context.depth, node.getPlanString());
        return node;
    }

    @Override
    public LogicalNode visitDropDatabase(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, DropDatabaseNode node, Stack<LogicalNode> stack) throws PlanningException {
        context.add(context.depth, node.getPlanString());
        return node;
    }

    @Override
    public LogicalNode visitInsert(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, InsertNode node, Stack<LogicalNode> stack) throws PlanningException {
        ++context.depth;
        stack.push(node);
        super.visitInsert(context, plan, block, node, stack);
        stack.pop();
        --context.depth;
        context.add(context.depth, node.getPlanString());
        return node;
    }

    public static String printDepthString(int maxDepth, DepthString planStr) {
        StringBuilder output = new StringBuilder();
        String pad = new String(new char[planStr.getDepth() * 3]).replace('\u0000', ' ');
        output.append(pad + planStr.getPlanString().getTitle()).append("\n");
        for (String str : planStr.getPlanString().getExplanations()) {
            output.append(pad).append("  => ").append(str).append("\n");
        }
        for (String str : planStr.getPlanString().getDetails()) {
            output.append(pad).append("  => ").append(str).append("\n");
        }
        return output.toString();
    }

    public static class DepthString {
        private int depth;
        private PlanString planStr;

        DepthString(int depth, PlanString planStr) {
            this.depth = depth;
            this.planStr = planStr;
        }

        public int getDepth() {
            return this.depth;
        }

        public PlanString getPlanString() {
            return this.planStr;
        }
    }

    public static class Context {
        public int maxDepth = -1;
        public int depth = 0;
        public Stack<DepthString> explains = new Stack();

        public void add(int depth, PlanString planString) {
            this.maxDepth = Math.max(this.maxDepth, depth);
            this.explains.push(new DepthString(depth, planString));
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public Stack<DepthString> getExplains() {
            return this.explains;
        }
    }
}

