/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.verifier;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.algebra.Aggregation;
import org.apache.tajo.algebra.CreateDatabase;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.DropDatabase;
import org.apache.tajo.algebra.DropTable;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.Insert;
import org.apache.tajo.algebra.Limit;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.Projection;
import org.apache.tajo.algebra.Relation;
import org.apache.tajo.algebra.SetSession;
import org.apache.tajo.catalog.CatalogService;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.algebra.BaseAlgebraVisitor;
import org.apache.tajo.plan.util.ExprFinder;
import org.apache.tajo.plan.verifier.VerificationState;
import org.apache.tajo.util.TUtil;
import org.apache.tajo.validation.ConstraintViolation;

public class PreLogicalPlanVerifier
extends BaseAlgebraVisitor<Context, Expr> {
    private CatalogService catalog;

    public PreLogicalPlanVerifier(CatalogService catalog) {
        this.catalog = catalog;
    }

    public VerificationState verify(OverridableConf queryContext, VerificationState state, Expr expr) throws PlanningException {
        Context context = new Context(queryContext, state);
        this.visit(context, new Stack<Expr>(), expr);
        return context.state;
    }

    @Override
    public Expr visitSetSession(Context ctx, Stack<Expr> stack, SetSession expr) throws PlanningException {
        SessionVars var;
        if (SessionVars.exists((String)expr.getName()) && (var = SessionVars.get((String)expr.getName())).validator() != null) {
            Collection violations = var.validator().validate((Object)expr.getValue());
            for (ConstraintViolation violation : violations) {
                ctx.state.addVerification(violation.getMessage());
            }
        }
        return expr;
    }

    @Override
    public Expr visitProjection(Context context, Stack<Expr> stack, Projection expr) throws PlanningException {
        super.visitProjection(context, stack, expr);
        Set names = TUtil.newHashSet();
        Object distinctValues = null;
        for (NamedExpr namedExpr : expr.getNamedExprs()) {
            if (namedExpr.hasAlias()) {
                if (names.contains(namedExpr.getAlias())) {
                    context.state.addVerification(String.format("column name \"%s\" specified more than once", namedExpr.getAlias()));
                } else {
                    names.add(namedExpr.getAlias());
                }
            }
            Set<GeneralSetFunctionExpr> exprs = ExprFinder.finds(namedExpr.getExpr(), OpType.GeneralSetFunction);
            if (distinctValues == null) continue;
            for (GeneralSetFunctionExpr setFunction : exprs) {
                if (!setFunction.getSignature().equalsIgnoreCase("avg")) continue;
                if (setFunction.isDistinct()) {
                    throw new PlanningException("avg(distinct) function is not supported yet.");
                }
                throw new PlanningException("avg() function with distinct aggregation functions is not supported yet.");
            }
        }
        return expr;
    }

    @Override
    public Expr visitLimit(Context context, Stack<Expr> stack, Limit expr) throws PlanningException {
        stack.push((Expr)expr);
        if (ExprFinder.finds(expr.getFetchFirstNum(), OpType.Column).size() > 0) {
            context.state.addVerification("argument of LIMIT must not contain variables");
        }
        this.visit(context, stack, expr.getFetchFirstNum());
        Expr result = (Expr)this.visit(context, stack, expr.getChild());
        stack.pop();
        return result;
    }

    @Override
    public Expr visitGroupBy(Context context, Stack<Expr> stack, Aggregation expr) throws PlanningException {
        super.visitGroupBy(context, stack, expr);
        for (Aggregation.GroupElement groupingElement : expr.getGroupSet()) {
            if (groupingElement.getType() == Aggregation.GroupType.OrdinaryGroup) continue;
            context.state.addVerification(groupingElement.getType() + " is not supported yet");
        }
        Projection projection = null;
        for (Expr parent : stack) {
            if (parent.getType() != OpType.Projection) continue;
            projection = (Projection)parent;
            break;
        }
        if (projection == null) {
            throw new PlanningException("No Projection");
        }
        return expr;
    }

    @Override
    public Expr visitRelation(Context context, Stack<Expr> stack, Relation expr) throws PlanningException {
        this.assertRelationExistence(context, expr.getName());
        return expr;
    }

    private boolean assertRelationExistence(Context context, String tableName) {
        String qualifiedName = CatalogUtil.isFQTableName((String)tableName) ? tableName : CatalogUtil.buildFQName((String[])new String[]{context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), tableName});
        if (!this.catalog.existsTable(qualifiedName)) {
            context.state.addVerification(String.format("relation \"%s\" does not exist", qualifiedName));
            return false;
        }
        return true;
    }

    private boolean assertRelationNoExistence(Context context, String tableName) {
        String qualifiedName = CatalogUtil.isFQTableName((String)tableName) ? tableName : CatalogUtil.buildFQName((String[])new String[]{context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), tableName});
        if (qualifiedName == null) {
            System.out.println("A");
        }
        if (this.catalog.existsTable(qualifiedName)) {
            context.state.addVerification(String.format("relation \"%s\" already exists", qualifiedName));
            return false;
        }
        return true;
    }

    private boolean assertSupportedStoreType(VerificationState state, String name) {
        Preconditions.checkNotNull((Object)name);
        CatalogProtos.StoreType storeType = CatalogUtil.getStoreType((String)name);
        if (storeType == null || storeType == CatalogProtos.StoreType.RAW) {
            state.addVerification(String.format("Store format %s is not supported.", name));
            return false;
        }
        return true;
    }

    private boolean assertDatabaseExistence(VerificationState state, String name) {
        if (!this.catalog.existDatabase(name).booleanValue()) {
            state.addVerification(String.format("database \"%s\" does not exist", name));
            return false;
        }
        return true;
    }

    private boolean assertDatabaseNoExistence(VerificationState state, String name) {
        if (this.catalog.existDatabase(name).booleanValue()) {
            state.addVerification(String.format("database \"%s\" already exists", name));
            return false;
        }
        return true;
    }

    @Override
    public Expr visitCreateDatabase(Context context, Stack<Expr> stack, CreateDatabase expr) throws PlanningException {
        super.visitCreateDatabase(context, stack, expr);
        if (!expr.isIfNotExists()) {
            this.assertDatabaseNoExistence(context.state, expr.getDatabaseName());
        }
        return expr;
    }

    @Override
    public Expr visitDropDatabase(Context context, Stack<Expr> stack, DropDatabase expr) throws PlanningException {
        super.visitDropDatabase(context, stack, expr);
        if (!expr.isIfExists()) {
            this.assertDatabaseExistence(context.state, expr.getDatabaseName());
        }
        return expr;
    }

    @Override
    public Expr visitCreateTable(Context context, Stack<Expr> stack, CreateTable expr) throws PlanningException {
        super.visitCreateTable(context, stack, expr);
        if (!expr.isIfNotExists()) {
            this.assertRelationNoExistence(context, expr.getTableName());
        }
        if (expr.hasStorageType()) {
            this.assertSupportedStoreType(context.state, expr.getStorageType());
        }
        return expr;
    }

    @Override
    public Expr visitDropTable(Context context, Stack<Expr> stack, DropTable expr) throws PlanningException {
        super.visitDropTable(context, stack, expr);
        if (!expr.isIfExists()) {
            this.assertRelationExistence(context, expr.getTableName());
        }
        return expr;
    }

    @Override
    public Expr visitInsert(Context context, Stack<Expr> stack, Insert expr) throws PlanningException {
        Expr child = (Expr)super.visitInsert(context, stack, expr);
        if (expr.hasTableName()) {
            this.assertRelationExistence(context, expr.getTableName());
        }
        if (expr.hasStorageType()) {
            this.assertSupportedStoreType(context.state, expr.getStorageType());
        }
        if (child != null && child.getType() == OpType.Projection) {
            Projection projection = (Projection)child;
            boolean includeAsterisk = false;
            for (NamedExpr namedExpr : projection.getNamedExprs()) {
                includeAsterisk |= namedExpr.getExpr().getType() == OpType.Asterisk;
            }
            if (!includeAsterisk) {
                int projectColumnNum = projection.getNamedExprs().length;
                if (expr.hasTargetColumns()) {
                    int targetColumnNum = expr.getTargetColumns().length;
                    if (targetColumnNum > projectColumnNum) {
                        context.state.addVerification("INSERT has more target columns than expressions");
                    } else if (targetColumnNum < projectColumnNum) {
                        context.state.addVerification("INSERT has more expressions than target columns");
                    }
                } else if (expr.hasTableName()) {
                    TableDesc table;
                    String qualifiedName = expr.getTableName();
                    if ("".equals(CatalogUtil.extractQualifier((String)expr.getTableName()))) {
                        qualifiedName = CatalogUtil.buildFQName((String[])new String[]{context.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), expr.getTableName()});
                    }
                    if ((table = this.catalog.getTableDesc(qualifiedName)) == null) {
                        context.state.addVerification(String.format("relation \"%s\" does not exist", qualifiedName));
                        return null;
                    }
                    if (table.hasPartition()) {
                        int columnSize = table.getSchema().getColumns().size();
                        if (projectColumnNum < (columnSize += table.getPartitionMethod().getExpressionSchema().getColumns().size())) {
                            context.state.addVerification("INSERT has smaller expressions than target columns");
                        } else if (projectColumnNum > columnSize) {
                            context.state.addVerification("INSERT has more expressions than target columns");
                        }
                    }
                }
            }
        }
        return expr;
    }

    public static class Context {
        OverridableConf queryContext;
        VerificationState state;

        public Context(OverridableConf queryContext, VerificationState state) {
            this.queryContext = queryContext;
            this.state = state;
        }
    }
}

