/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.util;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.visitor.SimpleAlgebraVisitor;

public class ExprFinder
extends SimpleAlgebraVisitor<Context, Object> {
    public static <T extends Expr> Set<T> finds(Expr expr, OpType type) {
        Context context = new Context(type);
        ExprFinder finder = new ExprFinder();
        Stack<Expr> stack = new Stack<Expr>();
        stack.push(expr);
        try {
            finder.visit(context, new Stack<Expr>(), expr);
        }
        catch (PlanningException e) {
            throw new RuntimeException(e);
        }
        stack.pop();
        return context.set;
    }

    @Override
    public Object visit(Context ctx, Stack<Expr> stack, Expr expr) throws PlanningException {
        if (expr instanceof UnaryOperator) {
            this.preHook(ctx, stack, expr);
            this.visitUnaryOperator(ctx, stack, (UnaryOperator)expr);
            this.postHook(ctx, stack, expr, null);
        } else if (expr instanceof BinaryOperator) {
            this.preHook(ctx, stack, expr);
            this.visitBinaryOperator(ctx, stack, (BinaryOperator)expr);
            this.postHook(ctx, stack, expr, null);
        } else {
            super.visit(ctx, stack, expr);
        }
        if (ctx.targetType == expr.getType()) {
            ctx.set.add(expr);
        }
        return null;
    }

    static class Context {
        Set<Expr> set = new HashSet<Expr>();
        OpType targetType;

        Context(OpType type) {
            this.targetType = type;
        }
    }
}

