/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.serder;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.common.ProtoObject;
import org.apache.tajo.exception.UnimplementedException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.logical.AlterTableNode;
import org.apache.tajo.plan.logical.AlterTablespaceNode;
import org.apache.tajo.plan.logical.CreateDatabaseNode;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.DistinctGroupbyNode;
import org.apache.tajo.plan.logical.DropDatabaseNode;
import org.apache.tajo.plan.logical.DropTableNode;
import org.apache.tajo.plan.logical.EvalExprNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.PartitionedTableScanNode;
import org.apache.tajo.plan.logical.PersistentStoreNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SetSessionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.StoreTableNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.TruncateTableNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.serder.EvalNodeSerializer;
import org.apache.tajo.plan.serder.PlanProto;
import org.apache.tajo.plan.visitor.BasicLogicalPlanVisitor;
import org.apache.tajo.util.ProtoUtil;
import org.apache.tajo.util.TUtil;

public class LogicalNodeSerializer
extends BasicLogicalPlanVisitor<SerializeContext, LogicalNode> {
    private static final LogicalNodeSerializer instance = new LogicalNodeSerializer();

    public static PlanProto.LogicalNodeTree serialize(LogicalNode node) {
        SerializeContext context = new SerializeContext();
        try {
            instance.visit(context, null, null, node, new Stack<LogicalNode>());
        }
        catch (PlanningException e) {
            throw new RuntimeException(e);
        }
        return context.treeBuilder.build();
    }

    private static PlanProto.LogicalNode.Builder createNodeBuilder(SerializeContext context, LogicalNode node) {
        int selfId;
        if (context.idMap.containsKey(node)) {
            selfId = (Integer)context.idMap.get(node);
        } else {
            selfId = context.seqId++;
            context.idMap.put(node, selfId);
        }
        PlanProto.LogicalNode.Builder nodeBuilder = PlanProto.LogicalNode.newBuilder();
        nodeBuilder.setVisitSeq(selfId);
        nodeBuilder.setNodeId(node.getPID());
        nodeBuilder.setType(LogicalNodeSerializer.convertType(node.getType()));
        if (node.getInSchema() != null) {
            nodeBuilder.setInSchema(node.getInSchema().getProto());
        }
        if (node.getOutSchema() != null) {
            nodeBuilder.setOutSchema(node.getOutSchema().getProto());
        }
        return nodeBuilder;
    }

    @Override
    public LogicalNode visitRoot(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, LogicalRootNode root, Stack<LogicalNode> stack) throws PlanningException {
        super.visitRoot(context, plan, block, root, stack);
        int[] childIds = this.registerGetChildIds(context, root);
        PlanProto.RootNode.Builder rootBuilder = PlanProto.RootNode.newBuilder();
        rootBuilder.setChildSeq(childIds[0]);
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, root);
        nodeBuilder.setRoot(rootBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return root;
    }

    @Override
    public LogicalNode visitSetSession(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, SetSessionNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitSetSession(context, plan, block, node, stack);
        PlanProto.SetSessionNode.Builder builder = PlanProto.SetSessionNode.newBuilder();
        builder.setName(node.getName());
        if (node.hasValue()) {
            builder.setValue(node.getValue());
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setSetSession(builder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitEvalExpr(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, EvalExprNode exprEval, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.EvalExprNode.Builder exprEvalBuilder = PlanProto.EvalExprNode.newBuilder();
        exprEvalBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])exprEval.getTargets()));
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, exprEval);
        nodeBuilder.setExprEval(exprEvalBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return exprEval;
    }

    @Override
    public LogicalNode visitProjection(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, ProjectionNode projection, Stack<LogicalNode> stack) throws PlanningException {
        super.visitProjection(context, plan, block, projection, stack);
        int[] childIds = this.registerGetChildIds(context, projection);
        PlanProto.ProjectionNode.Builder projectionBuilder = PlanProto.ProjectionNode.newBuilder();
        projectionBuilder.setChildSeq(childIds[0]);
        projectionBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])projection.getTargets()));
        projectionBuilder.setDistinct(projection.isDistinct());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, projection);
        nodeBuilder.setProjection(projectionBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return projection;
    }

    @Override
    public LogicalNode visitLimit(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, LimitNode limit, Stack<LogicalNode> stack) throws PlanningException {
        super.visitLimit(context, plan, block, limit, stack);
        int[] childIds = this.registerGetChildIds(context, limit);
        PlanProto.LimitNode.Builder limitBuilder = PlanProto.LimitNode.newBuilder();
        limitBuilder.setChildSeq(childIds[0]);
        limitBuilder.setFetchFirstNum(limit.getFetchFirstNum());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, limit);
        nodeBuilder.setLimit(limitBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return limit;
    }

    @Override
    public LogicalNode visitWindowAgg(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, WindowAggNode windowAgg, Stack<LogicalNode> stack) throws PlanningException {
        super.visitWindowAgg(context, plan, block, windowAgg, stack);
        int[] childIds = this.registerGetChildIds(context, windowAgg);
        PlanProto.WindowAggNode.Builder windowAggBuilder = PlanProto.WindowAggNode.newBuilder();
        windowAggBuilder.setChildSeq(childIds[0]);
        if (windowAgg.hasPartitionKeys()) {
            windowAggBuilder.addAllPartitionKeys(ProtoUtil.toProtoObjects((ProtoObject[])windowAgg.getPartitionKeys()));
        }
        if (windowAgg.hasAggFunctions()) {
            windowAggBuilder.addAllWindowFunctions(ProtoUtil.toProtoObjects((ProtoObject[])windowAgg.getWindowFunctions()));
        }
        windowAggBuilder.setDistinct(windowAgg.isDistinct());
        if (windowAgg.hasSortSpecs()) {
            windowAggBuilder.addAllSortSpecs(ProtoUtil.toProtoObjects((ProtoObject[])windowAgg.getSortSpecs()));
        }
        if (windowAgg.hasTargets()) {
            windowAggBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])windowAgg.getTargets()));
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, windowAgg);
        nodeBuilder.setWindowAgg(windowAggBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return windowAgg;
    }

    @Override
    public LogicalNode visitSort(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, SortNode sort, Stack<LogicalNode> stack) throws PlanningException {
        super.visitSort(context, plan, block, sort, stack);
        int[] childIds = this.registerGetChildIds(context, sort);
        PlanProto.SortNode.Builder sortBuilder = PlanProto.SortNode.newBuilder();
        sortBuilder.setChildSeq(childIds[0]);
        for (int i = 0; i < sort.getSortKeys().length; ++i) {
            sortBuilder.addSortSpecs(sort.getSortKeys()[i].getProto());
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, sort);
        nodeBuilder.setSort(sortBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return sort;
    }

    @Override
    public LogicalNode visitHaving(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, HavingNode having, Stack<LogicalNode> stack) throws PlanningException {
        super.visitHaving(context, plan, block, having, stack);
        int[] childIds = this.registerGetChildIds(context, having);
        PlanProto.FilterNode.Builder filterBuilder = PlanProto.FilterNode.newBuilder();
        filterBuilder.setChildSeq(childIds[0]);
        filterBuilder.setQual(EvalNodeSerializer.serialize(having.getQual()));
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, having);
        nodeBuilder.setFilter(filterBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return having;
    }

    @Override
    public LogicalNode visitGroupBy(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, GroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitGroupBy(context, plan, block, node, new Stack<LogicalNode>());
        PlanProto.LogicalNode.Builder nodeBuilder = this.buildGroupby(context, node);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    private PlanProto.LogicalNode.Builder buildGroupby(SerializeContext context, GroupbyNode node) throws PlanningException {
        int[] childIds = this.registerGetChildIds(context, node);
        PlanProto.GroupbyNode.Builder groupbyBuilder = PlanProto.GroupbyNode.newBuilder();
        groupbyBuilder.setChildSeq(childIds[0]);
        groupbyBuilder.setDistinct(node.isDistinct());
        if (node.groupingKeyNum() > 0) {
            groupbyBuilder.addAllGroupingKeys(ProtoUtil.toProtoObjects((ProtoObject[])node.getGroupingColumns()));
        }
        if (node.hasAggFunctions()) {
            groupbyBuilder.addAllAggFunctions(ProtoUtil.toProtoObjects((ProtoObject[])node.getAggFunctions()));
        }
        if (node.hasTargets()) {
            groupbyBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])node.getTargets()));
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setGroupby(groupbyBuilder);
        return nodeBuilder;
    }

    @Override
    public LogicalNode visitDistinctGroupby(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, DistinctGroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitDistinctGroupby(context, plan, block, node, new Stack<LogicalNode>());
        int[] childIds = this.registerGetChildIds(context, node);
        PlanProto.DistinctGroupbyNode.Builder distGroupbyBuilder = PlanProto.DistinctGroupbyNode.newBuilder();
        distGroupbyBuilder.setChildSeq(childIds[0]);
        if (node.getGroupbyPlan() != null) {
            distGroupbyBuilder.setGroupbyNode(this.buildGroupby(context, node.getGroupbyPlan()));
        }
        for (GroupbyNode subPlan : node.getSubPlans()) {
            distGroupbyBuilder.addSubPlans(this.buildGroupby(context, subPlan));
        }
        if (node.getGroupingColumns().length > 0) {
            distGroupbyBuilder.addAllGroupingKeys(ProtoUtil.toProtoObjects((ProtoObject[])node.getGroupingColumns()));
        }
        if (node.getAggFunctions().length > 0) {
            distGroupbyBuilder.addAllAggFunctions(ProtoUtil.toProtoObjects((ProtoObject[])node.getAggFunctions()));
        }
        if (node.hasTargets()) {
            distGroupbyBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])node.getTargets()));
        }
        for (int cid : node.getResultColumnIds()) {
            distGroupbyBuilder.addResultId(cid);
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setDistinctGroupby(distGroupbyBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitFilter(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, SelectionNode filter, Stack<LogicalNode> stack) throws PlanningException {
        super.visitFilter(context, plan, block, filter, stack);
        int[] childIds = this.registerGetChildIds(context, filter);
        PlanProto.FilterNode.Builder filterBuilder = PlanProto.FilterNode.newBuilder();
        filterBuilder.setChildSeq(childIds[0]);
        filterBuilder.setQual(EvalNodeSerializer.serialize(filter.getQual()));
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, filter);
        nodeBuilder.setFilter(filterBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return filter;
    }

    @Override
    public LogicalNode visitJoin(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode join, Stack<LogicalNode> stack) throws PlanningException {
        super.visitJoin(context, plan, block, join, stack);
        int[] childIds = this.registerGetChildIds(context, join);
        PlanProto.JoinNode.Builder joinBuilder = PlanProto.JoinNode.newBuilder();
        joinBuilder.setJoinType(LogicalNodeSerializer.convertJoinType(join.getJoinType()));
        joinBuilder.setLeftChildSeq(childIds[0]);
        joinBuilder.setRightChilSeq(childIds[1]);
        if (join.hasJoinQual()) {
            joinBuilder.setJoinQual(EvalNodeSerializer.serialize(join.getJoinQual()));
        }
        if (join.hasTargets()) {
            joinBuilder.setExistsTargets(true);
            joinBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])join.getTargets()));
        } else {
            joinBuilder.setExistsTargets(false);
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, join);
        nodeBuilder.setJoin(joinBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return join;
    }

    @Override
    public LogicalNode visitUnion(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnionNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitUnion(context, plan, block, node, stack);
        int[] childIds = this.registerGetChildIds(context, node);
        PlanProto.UnionNode.Builder unionBuilder = PlanProto.UnionNode.newBuilder();
        unionBuilder.setAll(true);
        unionBuilder.setLeftChildSeq(childIds[0]);
        unionBuilder.setRightChildSeq(childIds[1]);
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setUnion(unionBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitScan(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode scan, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.ScanNode.Builder scanBuilder = this.buildScanNode(scan);
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, scan);
        nodeBuilder.setScan(scanBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return scan;
    }

    public PlanProto.ScanNode.Builder buildScanNode(ScanNode scan) {
        PlanProto.ScanNode.Builder scanBuilder = PlanProto.ScanNode.newBuilder();
        scanBuilder.setTable(scan.getTableDesc().getProto());
        if (scan.hasAlias()) {
            scanBuilder.setAlias(scan.getAlias());
        }
        if (scan.hasTargets()) {
            scanBuilder.setExistTargets(true);
            scanBuilder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])scan.getTargets()));
        } else {
            scanBuilder.setExistTargets(false);
        }
        if (scan.hasQual()) {
            scanBuilder.setQual(EvalNodeSerializer.serialize(scan.getQual()));
        }
        return scanBuilder;
    }

    @Override
    public LogicalNode visitPartitionedTableScan(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, PartitionedTableScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.ScanNode.Builder scanBuilder = this.buildScanNode(node);
        PlanProto.PartitionScanSpec.Builder partitionScan = PlanProto.PartitionScanSpec.newBuilder();
        List pathStrs = TUtil.newList();
        if (node.getInputPaths() != null) {
            for (Path p : node.getInputPaths()) {
                pathStrs.add(p.toString());
            }
            partitionScan.addAllPaths(pathStrs);
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setScan(scanBuilder);
        nodeBuilder.setPartitionScan(partitionScan);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitTableSubQuery(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, TableSubQueryNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitTableSubQuery(context, plan, block, node, stack);
        int[] childIds = this.registerGetChildIds(context, node);
        PlanProto.TableSubQueryNode.Builder builder = PlanProto.TableSubQueryNode.newBuilder();
        builder.setChildSeq(childIds[0]);
        builder.setTableName(node.getTableName());
        if (node.hasTargets()) {
            builder.addAllTargets(ProtoUtil.toProtoObjects((ProtoObject[])node.getTargets()));
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setTableSubQuery(builder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitCreateTable(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, CreateTableNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitCreateTable(context, plan, block, node, stack);
        int[] childIds = this.registerGetChildIds(context, node);
        PlanProto.PersistentStoreNode.Builder persistentStoreBuilder = LogicalNodeSerializer.buildPersistentStoreBuilder(node, childIds);
        PlanProto.StoreTableNodeSpec.Builder storeTableBuilder = LogicalNodeSerializer.buildStoreTableNodeSpec(node);
        PlanProto.CreateTableNodeSpec.Builder createTableBuilder = PlanProto.CreateTableNodeSpec.newBuilder();
        createTableBuilder.setSchema(node.getTableSchema().getProto());
        createTableBuilder.setExternal(node.isExternal());
        if (node.isExternal() && node.hasPath()) {
            createTableBuilder.setPath(node.getPath().toString());
        }
        createTableBuilder.setIfNotExists(node.isIfNotExists());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setPersistentStore(persistentStoreBuilder);
        nodeBuilder.setStoreTable(storeTableBuilder);
        nodeBuilder.setCreateTable(createTableBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitDropTable(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, DropTableNode node, Stack<LogicalNode> stack) {
        PlanProto.DropTableNode.Builder dropTableBuilder = PlanProto.DropTableNode.newBuilder();
        dropTableBuilder.setTableName(node.getTableName());
        dropTableBuilder.setIfExists(node.isIfExists());
        dropTableBuilder.setPurge(node.isPurge());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setDropTable(dropTableBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitAlterTablespace(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, AlterTablespaceNode node, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.AlterTablespaceNode.Builder alterTablespaceBuilder = PlanProto.AlterTablespaceNode.newBuilder();
        alterTablespaceBuilder.setTableSpaceName(node.getTablespaceName());
        switch (node.getSetType()) {
            case LOCATION: {
                alterTablespaceBuilder.setSetType(PlanProto.AlterTablespaceNode.Type.LOCATION);
                alterTablespaceBuilder.setSetLocation(PlanProto.AlterTablespaceNode.SetLocation.newBuilder().setLocation(node.getLocation()));
                break;
            }
            default: {
                throw new UnimplementedException("Unknown SET type in ALTER TABLESPACE: " + node.getSetType().name());
            }
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setAlterTablespace(alterTablespaceBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitAlterTable(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, AlterTableNode node, Stack<LogicalNode> stack) {
        PlanProto.AlterTableNode.Builder alterTableBuilder = PlanProto.AlterTableNode.newBuilder();
        alterTableBuilder.setTableName(node.getTableName());
        switch (node.getAlterTableOpType()) {
            case RENAME_TABLE: {
                alterTableBuilder.setSetType(PlanProto.AlterTableNode.Type.RENAME_TABLE);
                alterTableBuilder.setRenameTable(PlanProto.AlterTableNode.RenameTable.newBuilder().setNewName(node.getNewTableName()));
                break;
            }
            case ADD_COLUMN: {
                alterTableBuilder.setSetType(PlanProto.AlterTableNode.Type.ADD_COLUMN);
                alterTableBuilder.setAddColumn(PlanProto.AlterTableNode.AddColumn.newBuilder().setAddColumn(node.getAddNewColumn().getProto()));
                break;
            }
            case RENAME_COLUMN: {
                alterTableBuilder.setSetType(PlanProto.AlterTableNode.Type.RENAME_COLUMN);
                alterTableBuilder.setRenameColumn(PlanProto.AlterTableNode.RenameColumn.newBuilder().setOldName(node.getColumnName()).setNewName(node.getNewColumnName()));
                break;
            }
            default: {
                throw new UnimplementedException("Unknown SET type in ALTER TABLE: " + node.getAlterTableOpType().name());
            }
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setAlterTable(alterTableBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitTruncateTable(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, TruncateTableNode node, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.TruncateTableNode.Builder truncateTableBuilder = PlanProto.TruncateTableNode.newBuilder();
        truncateTableBuilder.addAllTableNames(node.getTableNames());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setTruncateTableNode(truncateTableBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitInsert(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, InsertNode node, Stack<LogicalNode> stack) throws PlanningException {
        super.visitInsert(context, plan, block, node, stack);
        int[] childIds = this.registerGetChildIds(context, node);
        PlanProto.PersistentStoreNode.Builder persistentStoreBuilder = LogicalNodeSerializer.buildPersistentStoreBuilder(node, childIds);
        PlanProto.StoreTableNodeSpec.Builder storeTableBuilder = LogicalNodeSerializer.buildStoreTableNodeSpec(node);
        PlanProto.InsertNodeSpec.Builder insertNodeSpec = PlanProto.InsertNodeSpec.newBuilder();
        insertNodeSpec.setOverwrite(node.isOverwrite());
        insertNodeSpec.setTableSchema(node.getTableSchema().getProto());
        if (node.hasProjectedSchema()) {
            insertNodeSpec.setProjectedSchema(node.getProjectedSchema().getProto());
        }
        if (node.hasTargetSchema()) {
            insertNodeSpec.setTargetSchema(node.getTargetSchema().getProto());
        }
        if (node.hasPath()) {
            insertNodeSpec.setPath(node.getPath().toString());
        }
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setPersistentStore(persistentStoreBuilder);
        nodeBuilder.setStoreTable(storeTableBuilder);
        nodeBuilder.setInsert(insertNodeSpec);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    private static PlanProto.PersistentStoreNode.Builder buildPersistentStoreBuilder(PersistentStoreNode node, int[] childIds) {
        PlanProto.PersistentStoreNode.Builder persistentStoreBuilder = PlanProto.PersistentStoreNode.newBuilder();
        persistentStoreBuilder.setChildSeq(childIds[0]);
        persistentStoreBuilder.setStorageType(node.getStorageType());
        if (node.hasOptions()) {
            persistentStoreBuilder.setTableProperties(node.getOptions().getProto());
        }
        return persistentStoreBuilder;
    }

    private static PlanProto.StoreTableNodeSpec.Builder buildStoreTableNodeSpec(StoreTableNode node) {
        PlanProto.StoreTableNodeSpec.Builder storeTableBuilder = PlanProto.StoreTableNodeSpec.newBuilder();
        if (node.hasPartition()) {
            storeTableBuilder.setPartitionMethod(node.getPartitionMethod().getProto());
        }
        if (node.hasTableName()) {
            storeTableBuilder.setTableName(node.getTableName());
        }
        return storeTableBuilder;
    }

    @Override
    public LogicalNode visitCreateDatabase(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, CreateDatabaseNode node, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.CreateDatabaseNode.Builder createDatabaseBuilder = PlanProto.CreateDatabaseNode.newBuilder();
        createDatabaseBuilder.setDbName(node.getDatabaseName());
        createDatabaseBuilder.setIfNotExists(node.isIfNotExists());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setCreateDatabase(createDatabaseBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    @Override
    public LogicalNode visitDropDatabase(SerializeContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, DropDatabaseNode node, Stack<LogicalNode> stack) throws PlanningException {
        PlanProto.DropDatabaseNode.Builder dropDatabaseBuilder = PlanProto.DropDatabaseNode.newBuilder();
        dropDatabaseBuilder.setDbName(node.getDatabaseName());
        dropDatabaseBuilder.setIfExists(node.isIfExists());
        PlanProto.LogicalNode.Builder nodeBuilder = LogicalNodeSerializer.createNodeBuilder(context, node);
        nodeBuilder.setDropDatabase(dropDatabaseBuilder);
        context.treeBuilder.addNodes(nodeBuilder);
        return node;
    }

    public static PlanProto.NodeType convertType(NodeType type) {
        return PlanProto.NodeType.valueOf(type.name());
    }

    public static PlanProto.JoinType convertJoinType(JoinType type) {
        switch (type) {
            case CROSS: {
                return PlanProto.JoinType.CROSS_JOIN;
            }
            case INNER: {
                return PlanProto.JoinType.INNER_JOIN;
            }
            case LEFT_OUTER: {
                return PlanProto.JoinType.LEFT_OUTER_JOIN;
            }
            case RIGHT_OUTER: {
                return PlanProto.JoinType.RIGHT_OUTER_JOIN;
            }
            case FULL_OUTER: {
                return PlanProto.JoinType.FULL_OUTER_JOIN;
            }
            case LEFT_SEMI: {
                return PlanProto.JoinType.LEFT_SEMI_JOIN;
            }
            case RIGHT_SEMI: {
                return PlanProto.JoinType.RIGHT_SEMI_JOIN;
            }
            case LEFT_ANTI: {
                return PlanProto.JoinType.LEFT_ANTI_JOIN;
            }
            case RIGHT_ANTI: {
                return PlanProto.JoinType.RIGHT_ANTI_JOIN;
            }
            case UNION: {
                return PlanProto.JoinType.UNION_JOIN;
            }
        }
        throw new RuntimeException("Unknown JoinType: " + type.name());
    }

    public static PlanProto.Target convertTarget(Target target) {
        PlanProto.Target.Builder targetBuilder = PlanProto.Target.newBuilder();
        targetBuilder.setExpr(EvalNodeSerializer.serialize(target.getEvalTree()));
        if (target.hasAlias()) {
            targetBuilder.setAlias(target.getAlias());
        }
        return targetBuilder.build();
    }

    private int[] registerGetChildIds(SerializeContext context, LogicalNode node) {
        int[] childIds = new int[node.childNum()];
        for (int i = 0; i < node.childNum(); ++i) {
            childIds[i] = context.idMap.containsKey(node.getChild(i)) ? (Integer)context.idMap.get(node.getChild(i)) : context.seqId++;
        }
        return childIds;
    }

    public static class SerializeContext {
        private int seqId = 0;
        private Map<LogicalNode, Integer> idMap = Maps.newHashMap();
        private PlanProto.LogicalNodeTree.Builder treeBuilder = PlanProto.LogicalNodeTree.newBuilder();
    }
}

