/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.serder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.partition.PartitionMethodDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.exception.UnimplementedException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.logical.AlterTableNode;
import org.apache.tajo.plan.logical.AlterTablespaceNode;
import org.apache.tajo.plan.logical.CreateDatabaseNode;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.DistinctGroupbyNode;
import org.apache.tajo.plan.logical.DropDatabaseNode;
import org.apache.tajo.plan.logical.DropTableNode;
import org.apache.tajo.plan.logical.EvalExprNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.PartitionedTableScanNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SetSessionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.TruncateTableNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.serder.EvalNodeDeserializer;
import org.apache.tajo.plan.serder.PlanProto;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.TUtil;

public class LogicalNodeDeserializer {
    private static final LogicalNodeDeserializer instance = new LogicalNodeDeserializer();

    public static LogicalNode deserialize(OverridableConf context, PlanProto.LogicalNodeTree tree) {
        HashMap nodeMap = Maps.newHashMap();
        ArrayList nodeList = Lists.newArrayList(tree.getNodesList());
        Collections.sort(nodeList, new Comparator<PlanProto.LogicalNode>(){

            @Override
            public int compare(PlanProto.LogicalNode o1, PlanProto.LogicalNode o2) {
                return o1.getVisitSeq() - o2.getVisitSeq();
            }
        });
        LogicalNode current = null;
        for (PlanProto.LogicalNode protoNode : nodeList) {
            switch (protoNode.getType()) {
                case ROOT: {
                    current = LogicalNodeDeserializer.convertRoot(nodeMap, protoNode);
                    break;
                }
                case SET_SESSION: {
                    current = LogicalNodeDeserializer.convertSetSession(protoNode);
                    break;
                }
                case EXPRS: {
                    current = LogicalNodeDeserializer.convertEvalExpr(context, protoNode);
                    break;
                }
                case PROJECTION: {
                    current = LogicalNodeDeserializer.convertProjection(context, nodeMap, protoNode);
                    break;
                }
                case LIMIT: {
                    current = LogicalNodeDeserializer.convertLimit(nodeMap, protoNode);
                    break;
                }
                case SORT: {
                    current = LogicalNodeDeserializer.convertSort(nodeMap, protoNode);
                    break;
                }
                case WINDOW_AGG: {
                    current = LogicalNodeDeserializer.convertWindowAgg(context, nodeMap, protoNode);
                    break;
                }
                case HAVING: {
                    current = LogicalNodeDeserializer.convertHaving(context, nodeMap, protoNode);
                    break;
                }
                case GROUP_BY: {
                    current = LogicalNodeDeserializer.convertGroupby(context, nodeMap, protoNode);
                    break;
                }
                case DISTINCT_GROUP_BY: {
                    current = LogicalNodeDeserializer.convertDistinctGroupby(context, nodeMap, protoNode);
                    break;
                }
                case SELECTION: {
                    current = LogicalNodeDeserializer.convertFilter(context, nodeMap, protoNode);
                    break;
                }
                case JOIN: {
                    current = LogicalNodeDeserializer.convertJoin(context, nodeMap, protoNode);
                    break;
                }
                case TABLE_SUBQUERY: {
                    current = LogicalNodeDeserializer.convertTableSubQuery(context, nodeMap, protoNode);
                    break;
                }
                case UNION: {
                    current = LogicalNodeDeserializer.convertUnion(nodeMap, protoNode);
                    break;
                }
                case PARTITIONS_SCAN: {
                    current = LogicalNodeDeserializer.convertPartitionScan(context, protoNode);
                    break;
                }
                case SCAN: {
                    current = LogicalNodeDeserializer.convertScan(context, protoNode);
                    break;
                }
                case CREATE_TABLE: {
                    current = LogicalNodeDeserializer.convertCreateTable(nodeMap, protoNode);
                    break;
                }
                case INSERT: {
                    current = LogicalNodeDeserializer.convertInsert(nodeMap, protoNode);
                    break;
                }
                case DROP_TABLE: {
                    current = LogicalNodeDeserializer.convertDropTable(protoNode);
                    break;
                }
                case CREATE_DATABASE: {
                    current = LogicalNodeDeserializer.convertCreateDatabase(protoNode);
                    break;
                }
                case DROP_DATABASE: {
                    current = LogicalNodeDeserializer.convertDropDatabase(protoNode);
                    break;
                }
                case ALTER_TABLESPACE: {
                    current = LogicalNodeDeserializer.convertAlterTablespace(protoNode);
                    break;
                }
                case ALTER_TABLE: {
                    current = LogicalNodeDeserializer.convertAlterTable(protoNode);
                    break;
                }
                case TRUNCATE_TABLE: {
                    current = LogicalNodeDeserializer.convertTruncateTable(protoNode);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown NodeType: " + protoNode.getType().name());
                }
            }
            nodeMap.put(protoNode.getVisitSeq(), current);
        }
        return current;
    }

    private static LogicalRootNode convertRoot(Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.RootNode rootProto = protoNode.getRoot();
        LogicalRootNode root = new LogicalRootNode(protoNode.getNodeId());
        root.setChild(nodeMap.get(rootProto.getChildSeq()));
        if (protoNode.hasInSchema()) {
            root.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        }
        if (protoNode.hasOutSchema()) {
            root.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        }
        return root;
    }

    private static SetSessionNode convertSetSession(PlanProto.LogicalNode protoNode) {
        PlanProto.SetSessionNode setSessionProto = protoNode.getSetSession();
        SetSessionNode setSession = new SetSessionNode(protoNode.getNodeId());
        setSession.init(setSessionProto.getName(), setSessionProto.hasValue() ? setSessionProto.getValue() : null);
        return setSession;
    }

    private static EvalExprNode convertEvalExpr(OverridableConf context, PlanProto.LogicalNode protoNode) {
        PlanProto.EvalExprNode evalExprProto = protoNode.getExprEval();
        EvalExprNode evalExpr = new EvalExprNode(protoNode.getNodeId());
        evalExpr.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        evalExpr.setTargets(LogicalNodeDeserializer.convertTargets(context, evalExprProto.getTargetsList()));
        return evalExpr;
    }

    private static ProjectionNode convertProjection(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.ProjectionNode projectionProto = protoNode.getProjection();
        ProjectionNode projectionNode = new ProjectionNode(protoNode.getNodeId());
        projectionNode.init(projectionProto.getDistinct(), LogicalNodeDeserializer.convertTargets(context, projectionProto.getTargetsList()));
        projectionNode.setChild(nodeMap.get(projectionProto.getChildSeq()));
        projectionNode.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        projectionNode.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        return projectionNode;
    }

    private static LimitNode convertLimit(Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.LimitNode limitProto = protoNode.getLimit();
        LimitNode limitNode = new LimitNode(protoNode.getNodeId());
        limitNode.setChild(nodeMap.get(limitProto.getChildSeq()));
        limitNode.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        limitNode.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        limitNode.setFetchFirst(limitProto.getFetchFirstNum());
        return limitNode;
    }

    private static SortNode convertSort(Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.SortNode sortProto = protoNode.getSort();
        SortNode sortNode = new SortNode(protoNode.getNodeId());
        sortNode.setChild(nodeMap.get(sortProto.getChildSeq()));
        sortNode.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        sortNode.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        sortNode.setSortSpecs(LogicalNodeDeserializer.convertSortSpecs(sortProto.getSortSpecsList()));
        return sortNode;
    }

    private static HavingNode convertHaving(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.FilterNode havingProto = protoNode.getFilter();
        HavingNode having = new HavingNode(protoNode.getNodeId());
        having.setChild(nodeMap.get(havingProto.getChildSeq()));
        having.setQual(EvalNodeDeserializer.deserialize(context, havingProto.getQual()));
        having.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        having.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        return having;
    }

    private static WindowAggNode convertWindowAgg(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.WindowAggNode windowAggProto = protoNode.getWindowAgg();
        WindowAggNode windowAgg = new WindowAggNode(protoNode.getNodeId());
        windowAgg.setChild(nodeMap.get(windowAggProto.getChildSeq()));
        if (windowAggProto.getPartitionKeysCount() > 0) {
            windowAgg.setPartitionKeys(LogicalNodeDeserializer.convertColumns(windowAggProto.getPartitionKeysList()));
        }
        if (windowAggProto.getWindowFunctionsCount() > 0) {
            windowAgg.setWindowFunctions(LogicalNodeDeserializer.convertWindowFunccEvals(context, windowAggProto.getWindowFunctionsList()));
        }
        windowAgg.setDistinct(windowAggProto.getDistinct());
        if (windowAggProto.getSortSpecsCount() > 0) {
            windowAgg.setSortSpecs(LogicalNodeDeserializer.convertSortSpecs(windowAggProto.getSortSpecsList()));
        }
        if (windowAggProto.getTargetsCount() > 0) {
            windowAgg.setTargets(LogicalNodeDeserializer.convertTargets(context, windowAggProto.getTargetsList()));
        }
        windowAgg.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        windowAgg.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        return windowAgg;
    }

    private static GroupbyNode convertGroupby(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.GroupbyNode groupbyProto = protoNode.getGroupby();
        GroupbyNode groupby = new GroupbyNode(protoNode.getNodeId());
        groupby.setChild(nodeMap.get(groupbyProto.getChildSeq()));
        groupby.setDistinct(groupbyProto.getDistinct());
        if (groupbyProto.getGroupingKeysCount() > 0) {
            groupby.setGroupingColumns(LogicalNodeDeserializer.convertColumns(groupbyProto.getGroupingKeysList()));
        }
        if (groupbyProto.getAggFunctionsCount() > 0) {
            groupby.setAggFunctions(LogicalNodeDeserializer.convertAggFuncCallEvals(context, groupbyProto.getAggFunctionsList()));
        }
        if (groupbyProto.getTargetsCount() > 0) {
            groupby.setTargets(LogicalNodeDeserializer.convertTargets(context, groupbyProto.getTargetsList()));
        }
        groupby.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        groupby.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        return groupby;
    }

    private static DistinctGroupbyNode convertDistinctGroupby(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        int i;
        PlanProto.DistinctGroupbyNode distinctGroupbyProto = protoNode.getDistinctGroupby();
        DistinctGroupbyNode distinctGroupby = new DistinctGroupbyNode(protoNode.getNodeId());
        distinctGroupby.setChild(nodeMap.get(distinctGroupbyProto.getChildSeq()));
        if (distinctGroupbyProto.hasGroupbyNode()) {
            distinctGroupby.setGroupbyPlan(LogicalNodeDeserializer.convertGroupby(context, nodeMap, distinctGroupbyProto.getGroupbyNode()));
        }
        if (distinctGroupbyProto.getSubPlansCount() > 0) {
            List subPlans = TUtil.newList();
            for (i = 0; i < distinctGroupbyProto.getSubPlansCount(); ++i) {
                subPlans.add(LogicalNodeDeserializer.convertGroupby(context, nodeMap, distinctGroupbyProto.getSubPlans(i)));
            }
            distinctGroupby.setSubPlans(subPlans);
        }
        if (distinctGroupbyProto.getGroupingKeysCount() > 0) {
            distinctGroupby.setGroupingColumns(LogicalNodeDeserializer.convertColumns(distinctGroupbyProto.getGroupingKeysList()));
        }
        if (distinctGroupbyProto.getAggFunctionsCount() > 0) {
            distinctGroupby.setAggFunctions(LogicalNodeDeserializer.convertAggFuncCallEvals(context, distinctGroupbyProto.getAggFunctionsList()));
        }
        if (distinctGroupbyProto.getTargetsCount() > 0) {
            distinctGroupby.setTargets(LogicalNodeDeserializer.convertTargets(context, distinctGroupbyProto.getTargetsList()));
        }
        int[] resultColumnIds = new int[distinctGroupbyProto.getResultIdCount()];
        for (i = 0; i < distinctGroupbyProto.getResultIdCount(); ++i) {
            resultColumnIds[i] = distinctGroupbyProto.getResultId(i);
        }
        distinctGroupby.setResultColumnIds(resultColumnIds);
        distinctGroupby.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        distinctGroupby.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        return distinctGroupby;
    }

    private static JoinNode convertJoin(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.JoinNode joinProto = protoNode.getJoin();
        JoinNode join = new JoinNode(protoNode.getNodeId());
        join.setLeftChild(nodeMap.get(joinProto.getLeftChildSeq()));
        join.setRightChild(nodeMap.get(joinProto.getRightChilSeq()));
        join.setJoinType(LogicalNodeDeserializer.convertJoinType(joinProto.getJoinType()));
        join.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        join.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        if (joinProto.hasJoinQual()) {
            join.setJoinQual(EvalNodeDeserializer.deserialize(context, joinProto.getJoinQual()));
        }
        if (joinProto.getExistsTargets()) {
            join.setTargets(LogicalNodeDeserializer.convertTargets(context, joinProto.getTargetsList()));
        }
        return join;
    }

    private static SelectionNode convertFilter(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.FilterNode filterProto = protoNode.getFilter();
        SelectionNode selection = new SelectionNode(protoNode.getNodeId());
        selection.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        selection.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        selection.setChild(nodeMap.get(filterProto.getChildSeq()));
        selection.setQual(EvalNodeDeserializer.deserialize(context, filterProto.getQual()));
        return selection;
    }

    private static UnionNode convertUnion(Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.UnionNode unionProto = protoNode.getUnion();
        UnionNode union = new UnionNode(protoNode.getNodeId());
        union.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        union.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        union.setLeftChild(nodeMap.get(unionProto.getLeftChildSeq()));
        union.setRightChild(nodeMap.get(unionProto.getRightChildSeq()));
        return union;
    }

    private static ScanNode convertScan(OverridableConf context, PlanProto.LogicalNode protoNode) {
        ScanNode scan = new ScanNode(protoNode.getNodeId());
        LogicalNodeDeserializer.fillScanNode(context, protoNode, scan);
        return scan;
    }

    private static void fillScanNode(OverridableConf context, PlanProto.LogicalNode protoNode, ScanNode scan) {
        PlanProto.ScanNode scanProto = protoNode.getScan();
        if (scanProto.hasAlias()) {
            scan.init(new TableDesc(scanProto.getTable()), scanProto.getAlias());
        } else {
            scan.init(new TableDesc(scanProto.getTable()));
        }
        if (scanProto.getExistTargets()) {
            scan.setTargets(LogicalNodeDeserializer.convertTargets(context, scanProto.getTargetsList()));
        }
        if (scanProto.hasQual()) {
            scan.setQual(EvalNodeDeserializer.deserialize(context, scanProto.getQual()));
        }
        scan.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        scan.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
    }

    private static PartitionedTableScanNode convertPartitionScan(OverridableConf context, PlanProto.LogicalNode protoNode) {
        PartitionedTableScanNode partitionedScan = new PartitionedTableScanNode(protoNode.getNodeId());
        LogicalNodeDeserializer.fillScanNode(context, protoNode, partitionedScan);
        PlanProto.PartitionScanSpec partitionScanProto = protoNode.getPartitionScan();
        Path[] paths = new Path[partitionScanProto.getPathsCount()];
        for (int i = 0; i < partitionScanProto.getPathsCount(); ++i) {
            paths[i] = new Path(partitionScanProto.getPaths(i));
        }
        partitionedScan.setInputPaths(paths);
        return partitionedScan;
    }

    private static TableSubQueryNode convertTableSubQuery(OverridableConf context, Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.TableSubQueryNode proto = protoNode.getTableSubQuery();
        TableSubQueryNode tableSubQuery = new TableSubQueryNode(protoNode.getNodeId());
        tableSubQuery.init(proto.getTableName(), nodeMap.get(proto.getChildSeq()));
        tableSubQuery.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        if (proto.getTargetsCount() > 0) {
            tableSubQuery.setTargets(LogicalNodeDeserializer.convertTargets(context, proto.getTargetsList()));
        }
        return tableSubQuery;
    }

    private static CreateTableNode convertCreateTable(Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.PersistentStoreNode persistentStoreProto = protoNode.getPersistentStore();
        PlanProto.StoreTableNodeSpec storeTableNodeSpec = protoNode.getStoreTable();
        PlanProto.CreateTableNodeSpec createTableNodeSpec = protoNode.getCreateTable();
        CreateTableNode createTable = new CreateTableNode(protoNode.getNodeId());
        if (protoNode.hasInSchema()) {
            createTable.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        }
        if (protoNode.hasOutSchema()) {
            createTable.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        }
        createTable.setChild(nodeMap.get(persistentStoreProto.getChildSeq()));
        createTable.setStorageType(persistentStoreProto.getStorageType());
        createTable.setOptions(new KeyValueSet(persistentStoreProto.getTableProperties()));
        createTable.setTableName(storeTableNodeSpec.getTableName());
        if (storeTableNodeSpec.hasPartitionMethod()) {
            createTable.setPartitionMethod(new PartitionMethodDesc(storeTableNodeSpec.getPartitionMethod()));
        }
        createTable.setTableSchema(LogicalNodeDeserializer.convertSchema(createTableNodeSpec.getSchema()));
        createTable.setExternal(createTableNodeSpec.getExternal());
        if (createTableNodeSpec.getExternal() && createTableNodeSpec.hasPath()) {
            createTable.setPath(new Path(createTableNodeSpec.getPath()));
        }
        createTable.setIfNotExists(createTableNodeSpec.getIfNotExists());
        return createTable;
    }

    private static InsertNode convertInsert(Map<Integer, LogicalNode> nodeMap, PlanProto.LogicalNode protoNode) {
        PlanProto.PersistentStoreNode persistentStoreProto = protoNode.getPersistentStore();
        PlanProto.StoreTableNodeSpec storeTableNodeSpec = protoNode.getStoreTable();
        PlanProto.InsertNodeSpec insertNodeSpec = protoNode.getInsert();
        InsertNode insertNode = new InsertNode(protoNode.getNodeId());
        if (protoNode.hasInSchema()) {
            insertNode.setInSchema(LogicalNodeDeserializer.convertSchema(protoNode.getInSchema()));
        }
        if (protoNode.hasOutSchema()) {
            insertNode.setOutSchema(LogicalNodeDeserializer.convertSchema(protoNode.getOutSchema()));
        }
        insertNode.setChild(nodeMap.get(persistentStoreProto.getChildSeq()));
        insertNode.setStorageType(persistentStoreProto.getStorageType());
        insertNode.setOptions(new KeyValueSet(persistentStoreProto.getTableProperties()));
        if (storeTableNodeSpec.hasTableName()) {
            insertNode.setTableName(storeTableNodeSpec.getTableName());
        }
        if (storeTableNodeSpec.hasPartitionMethod()) {
            insertNode.setPartitionMethod(new PartitionMethodDesc(storeTableNodeSpec.getPartitionMethod()));
        }
        insertNode.setOverwrite(insertNodeSpec.getOverwrite());
        insertNode.setTableSchema(LogicalNodeDeserializer.convertSchema(insertNodeSpec.getTableSchema()));
        if (insertNodeSpec.hasTargetSchema()) {
            insertNode.setTargetSchema(LogicalNodeDeserializer.convertSchema(insertNodeSpec.getTargetSchema()));
        }
        if (insertNodeSpec.hasProjectedSchema()) {
            insertNode.setProjectedSchema(LogicalNodeDeserializer.convertSchema(insertNodeSpec.getProjectedSchema()));
        }
        if (insertNodeSpec.hasPath()) {
            insertNode.setPath(new Path(insertNodeSpec.getPath()));
        }
        return insertNode;
    }

    private static DropTableNode convertDropTable(PlanProto.LogicalNode protoNode) {
        DropTableNode dropTable = new DropTableNode(protoNode.getNodeId());
        PlanProto.DropTableNode dropTableProto = protoNode.getDropTable();
        dropTable.init(dropTableProto.getTableName(), dropTableProto.getIfExists(), dropTableProto.getPurge());
        return dropTable;
    }

    private static CreateDatabaseNode convertCreateDatabase(PlanProto.LogicalNode protoNode) {
        CreateDatabaseNode createDatabase = new CreateDatabaseNode(protoNode.getNodeId());
        PlanProto.CreateDatabaseNode createDatabaseProto = protoNode.getCreateDatabase();
        createDatabase.init(createDatabaseProto.getDbName(), createDatabaseProto.getIfNotExists());
        return createDatabase;
    }

    private static DropDatabaseNode convertDropDatabase(PlanProto.LogicalNode protoNode) {
        DropDatabaseNode dropDatabase = new DropDatabaseNode(protoNode.getNodeId());
        PlanProto.DropDatabaseNode dropDatabaseProto = protoNode.getDropDatabase();
        dropDatabase.init(dropDatabaseProto.getDbName(), dropDatabaseProto.getIfExists());
        return dropDatabase;
    }

    private static AlterTablespaceNode convertAlterTablespace(PlanProto.LogicalNode protoNode) {
        AlterTablespaceNode alterTablespace = new AlterTablespaceNode(protoNode.getNodeId());
        PlanProto.AlterTablespaceNode alterTablespaceProto = protoNode.getAlterTablespace();
        alterTablespace.setTablespaceName(alterTablespaceProto.getTableSpaceName());
        switch (alterTablespaceProto.getSetType()) {
            case LOCATION: {
                alterTablespace.setLocation(alterTablespaceProto.getSetLocation().getLocation());
                break;
            }
            default: {
                throw new UnimplementedException("Unknown SET type in ALTER TABLE: " + alterTablespaceProto.getSetType().name());
            }
        }
        return alterTablespace;
    }

    private static AlterTableNode convertAlterTable(PlanProto.LogicalNode protoNode) {
        AlterTableNode alterTable = new AlterTableNode(protoNode.getNodeId());
        PlanProto.AlterTableNode alterTableProto = protoNode.getAlterTable();
        alterTable.setTableName(alterTableProto.getTableName());
        switch (alterTableProto.getSetType()) {
            case RENAME_TABLE: {
                alterTable.setNewTableName(alterTableProto.getRenameTable().getNewName());
                break;
            }
            case ADD_COLUMN: {
                alterTable.setAddNewColumn(new Column(alterTableProto.getAddColumn().getAddColumn()));
                break;
            }
            case RENAME_COLUMN: {
                alterTable.setColumnName(alterTableProto.getRenameColumn().getOldName());
                alterTable.setNewColumnName(alterTableProto.getRenameColumn().getNewName());
                break;
            }
            default: {
                throw new UnimplementedException("Unknown SET type in ALTER TABLE: " + alterTableProto.getSetType().name());
            }
        }
        return alterTable;
    }

    private static TruncateTableNode convertTruncateTable(PlanProto.LogicalNode protoNode) {
        TruncateTableNode truncateTable = new TruncateTableNode(protoNode.getNodeId());
        PlanProto.TruncateTableNode truncateTableProto = protoNode.getTruncateTableNode();
        truncateTable.setTableNames(truncateTableProto.getTableNamesList());
        return truncateTable;
    }

    private static AggregationFunctionCallEval[] convertAggFuncCallEvals(OverridableConf context, List<PlanProto.EvalNodeTree> evalTrees) {
        AggregationFunctionCallEval[] aggFuncs = new AggregationFunctionCallEval[evalTrees.size()];
        for (int i = 0; i < aggFuncs.length; ++i) {
            aggFuncs[i] = (AggregationFunctionCallEval)EvalNodeDeserializer.deserialize(context, evalTrees.get(i));
        }
        return aggFuncs;
    }

    private static WindowFunctionEval[] convertWindowFunccEvals(OverridableConf context, List<PlanProto.EvalNodeTree> evalTrees) {
        WindowFunctionEval[] winFuncEvals = new WindowFunctionEval[evalTrees.size()];
        for (int i = 0; i < winFuncEvals.length; ++i) {
            winFuncEvals[i] = (WindowFunctionEval)EvalNodeDeserializer.deserialize(context, evalTrees.get(i));
        }
        return winFuncEvals;
    }

    public static Schema convertSchema(CatalogProtos.SchemaProto proto) {
        return new Schema(proto);
    }

    public static Column[] convertColumns(List<CatalogProtos.ColumnProto> columnProtos) {
        Column[] columns = new Column[columnProtos.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new Column(columnProtos.get(i));
        }
        return columns;
    }

    public static Target[] convertTargets(OverridableConf context, List<PlanProto.Target> targetsProto) {
        Target[] targets = new Target[targetsProto.size()];
        for (int i = 0; i < targets.length; ++i) {
            PlanProto.Target targetProto = targetsProto.get(i);
            EvalNode evalNode = EvalNodeDeserializer.deserialize(context, targetProto.getExpr());
            targets[i] = targetProto.hasAlias() ? new Target(evalNode, targetProto.getAlias()) : new Target((FieldEval)evalNode);
        }
        return targets;
    }

    public static SortSpec[] convertSortSpecs(List<CatalogProtos.SortSpecProto> sortSpecProtos) {
        SortSpec[] sortSpecs = new SortSpec[sortSpecProtos.size()];
        int i = 0;
        for (CatalogProtos.SortSpecProto proto : sortSpecProtos) {
            sortSpecs[i++] = new SortSpec(proto);
        }
        return sortSpecs;
    }

    public static JoinType convertJoinType(PlanProto.JoinType type) {
        switch (type) {
            case CROSS_JOIN: {
                return JoinType.CROSS;
            }
            case INNER_JOIN: {
                return JoinType.INNER;
            }
            case LEFT_OUTER_JOIN: {
                return JoinType.LEFT_OUTER;
            }
            case RIGHT_OUTER_JOIN: {
                return JoinType.RIGHT_OUTER;
            }
            case FULL_OUTER_JOIN: {
                return JoinType.FULL_OUTER;
            }
            case LEFT_SEMI_JOIN: {
                return JoinType.LEFT_SEMI;
            }
            case RIGHT_SEMI_JOIN: {
                return JoinType.RIGHT_SEMI;
            }
            case LEFT_ANTI_JOIN: {
                return JoinType.LEFT_ANTI;
            }
            case RIGHT_ANTI_JOIN: {
                return JoinType.RIGHT_ANTI;
            }
            case UNION_JOIN: {
                return JoinType.UNION;
            }
        }
        throw new RuntimeException("Unknown JoinType: " + type.name());
    }
}

