/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.serder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.Stack;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.common.ProtoObject;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.CastEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.InEval;
import org.apache.tajo.plan.expr.IsNullEval;
import org.apache.tajo.plan.expr.PatternMatchPredicateEval;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.plan.expr.SignedEval;
import org.apache.tajo.plan.expr.SimpleEvalNodeVisitor;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.logical.WindowSpec;
import org.apache.tajo.plan.serder.PlanProto;
import org.apache.tajo.util.ProtoUtil;

public class EvalNodeSerializer
extends SimpleEvalNodeVisitor<EvalTreeProtoBuilderContext> {
    private static final EvalNodeSerializer instance = new EvalNodeSerializer();

    public static PlanProto.EvalNodeTree serialize(EvalNode evalNode) {
        EvalTreeProtoBuilderContext context = new EvalTreeProtoBuilderContext();
        instance.visit(context, evalNode, new Stack<EvalNode>());
        return context.treeBuilder.build();
    }

    private int[] registerGetChildIds(EvalTreeProtoBuilderContext context, EvalNode evalNode) {
        int[] childIds = new int[evalNode.childNum()];
        for (int i = 0; i < evalNode.childNum(); ++i) {
            childIds[i] = context.idMap.containsKey(evalNode.getChild(i)) ? (Integer)context.idMap.get(evalNode.getChild(i)) : context.seqId++;
        }
        return childIds;
    }

    private PlanProto.EvalNode.Builder createEvalBuilder(EvalTreeProtoBuilderContext context, EvalNode node) {
        int sid;
        if (context.idMap.containsKey(node)) {
            sid = (Integer)context.idMap.get(node);
        } else {
            sid = context.seqId++;
            context.idMap.put(node, sid);
        }
        PlanProto.EvalNode.Builder nodeBuilder = PlanProto.EvalNode.newBuilder();
        nodeBuilder.setId(sid);
        nodeBuilder.setDataType(node.getValueType());
        nodeBuilder.setType(PlanProto.EvalType.valueOf(node.getType().name()));
        return nodeBuilder;
    }

    @Override
    public EvalNode visitUnaryEval(EvalTreeProtoBuilderContext context, Stack<EvalNode> stack, UnaryEval unary) {
        super.visitUnaryEval(context, stack, unary);
        int[] childIds = this.registerGetChildIds(context, unary);
        PlanProto.UnaryEval.Builder unaryBuilder = PlanProto.UnaryEval.newBuilder();
        unaryBuilder.setChildId(childIds[0]);
        if (unary.getType() == EvalType.IS_NULL) {
            IsNullEval isNullEval = (IsNullEval)unary;
            unaryBuilder.setNegative(isNullEval.isNot());
        } else if (unary.getType() == EvalType.SIGNED) {
            SignedEval signedEval = (SignedEval)unary;
            unaryBuilder.setNegative(signedEval.isNegative());
        } else if (unary.getType() == EvalType.CAST) {
            CastEval castEval = (CastEval)unary;
            unaryBuilder.setCastingType(castEval.getValueType());
            if (castEval.hasTimeZone()) {
                unaryBuilder.setTimezone(castEval.getTimezone().getID());
            }
        }
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, unary);
        builder.setUnary(unaryBuilder);
        context.treeBuilder.addNodes(builder);
        return unary;
    }

    @Override
    public EvalNode visitBinaryEval(EvalTreeProtoBuilderContext context, Stack<EvalNode> stack, BinaryEval binary) {
        super.visitBinaryEval(context, stack, binary);
        int[] childIds = this.registerGetChildIds(context, binary);
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, binary);
        PlanProto.BinaryEval.Builder binaryBuilder = PlanProto.BinaryEval.newBuilder();
        binaryBuilder.setLhsId(childIds[0]);
        binaryBuilder.setRhsId(childIds[1]);
        if (binary instanceof InEval) {
            binaryBuilder.setNegative(((InEval)binary).isNot());
        } else if (binary instanceof PatternMatchPredicateEval) {
            PatternMatchPredicateEval patternMatch = (PatternMatchPredicateEval)binary;
            binaryBuilder.setNegative(patternMatch.isNot());
            builder.setPatternMatch(PlanProto.PatternMatchEvalSpec.newBuilder().setCaseSensitive(patternMatch.isCaseInsensitive()));
        }
        builder.setBinary(binaryBuilder);
        context.treeBuilder.addNodes(builder);
        return binary;
    }

    @Override
    public EvalNode visitConst(EvalTreeProtoBuilderContext context, ConstEval constant, Stack<EvalNode> stack) {
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, constant);
        builder.setConst(PlanProto.ConstEval.newBuilder().setValue(EvalNodeSerializer.serialize(constant.getValue())));
        context.treeBuilder.addNodes(builder);
        return constant;
    }

    @Override
    public EvalNode visitRowConstant(EvalTreeProtoBuilderContext context, RowConstantEval rowConst, Stack<EvalNode> stack) {
        PlanProto.RowConstEval.Builder rowConstBuilder = PlanProto.RowConstEval.newBuilder();
        for (Datum d : rowConst.getValues()) {
            rowConstBuilder.addValues(EvalNodeSerializer.serialize(d));
        }
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, rowConst);
        builder.setRowConst(rowConstBuilder);
        context.treeBuilder.addNodes(builder);
        return rowConst;
    }

    @Override
    public EvalNode visitField(EvalTreeProtoBuilderContext context, Stack<EvalNode> stack, FieldEval field) {
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, field);
        builder.setField(field.getColumnRef().getProto());
        context.treeBuilder.addNodes(builder);
        return field;
    }

    @Override
    public EvalNode visitBetween(EvalTreeProtoBuilderContext context, BetweenPredicateEval between, Stack<EvalNode> stack) {
        super.visitBetween(context, between, stack);
        int[] childIds = this.registerGetChildIds(context, between);
        Preconditions.checkState((childIds.length == 3 ? 1 : 0) != 0, (Object)("Between must have three childs, but there are " + childIds.length + " child nodes"));
        PlanProto.BetweenEval.Builder betweenBuilder = PlanProto.BetweenEval.newBuilder();
        betweenBuilder.setNegative(between.isNot());
        betweenBuilder.setSymmetric(between.isSymmetric());
        betweenBuilder.setPredicand(childIds[0]);
        betweenBuilder.setBegin(childIds[1]);
        betweenBuilder.setEnd(childIds[2]);
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, between);
        builder.setBetween(betweenBuilder);
        context.treeBuilder.addNodes(builder);
        return between;
    }

    @Override
    public EvalNode visitCaseWhen(EvalTreeProtoBuilderContext context, CaseWhenEval caseWhen, Stack<EvalNode> stack) {
        super.visitCaseWhen(context, caseWhen, stack);
        int[] childIds = this.registerGetChildIds(context, caseWhen);
        Preconditions.checkState((childIds.length > 0 ? 1 : 0) != 0, (Object)"Case When must have at least one child, but there is no child");
        PlanProto.CaseWhenEval.Builder caseWhenBuilder = PlanProto.CaseWhenEval.newBuilder();
        int ifCondsNum = childIds.length - (caseWhen.hasElse() ? 1 : 0);
        for (int i = 0; i < ifCondsNum; ++i) {
            caseWhenBuilder.addIfConds(childIds[i]);
        }
        if (caseWhen.hasElse()) {
            caseWhenBuilder.setElse(childIds[childIds.length - 1]);
        }
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, caseWhen);
        builder.setCasewhen(caseWhenBuilder);
        context.treeBuilder.addNodes(builder);
        return caseWhen;
    }

    @Override
    public EvalNode visitIfThen(EvalTreeProtoBuilderContext context, CaseWhenEval.IfThenEval ifCond, Stack<EvalNode> stack) {
        super.visitIfThen(context, ifCond, stack);
        int[] childIds = this.registerGetChildIds(context, ifCond);
        PlanProto.IfCondEval.Builder ifCondBuilder = PlanProto.IfCondEval.newBuilder();
        ifCondBuilder.setCondition(childIds[0]);
        ifCondBuilder.setThen(childIds[1]);
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, ifCond);
        builder.setIfCond(ifCondBuilder);
        context.treeBuilder.addNodes(builder);
        return ifCond;
    }

    @Override
    public EvalNode visitFuncCall(EvalTreeProtoBuilderContext context, FunctionEval function, Stack<EvalNode> stack) {
        super.visitFuncCall(context, function, stack);
        int[] childIds = this.registerGetChildIds(context, function);
        PlanProto.FunctionEval.Builder funcBuilder = PlanProto.FunctionEval.newBuilder();
        funcBuilder.setFuncion(function.getFuncDesc().getProto());
        for (int i = 0; i < childIds.length; ++i) {
            funcBuilder.addParamIds(childIds[i]);
        }
        PlanProto.EvalNode.Builder builder = this.createEvalBuilder(context, function);
        builder.setFunction(funcBuilder);
        if (function instanceof AggregationFunctionCallEval) {
            AggregationFunctionCallEval aggFunc = (AggregationFunctionCallEval)function;
            PlanProto.AggFunctionEvalSpec.Builder aggFunctionEvalBuilder = PlanProto.AggFunctionEvalSpec.newBuilder();
            aggFunctionEvalBuilder.setIntermediatePhase(aggFunc.isIntermediatePhase());
            aggFunctionEvalBuilder.setFinalPhase(aggFunc.isFinalPhase());
            if (aggFunc.hasAlias()) {
                aggFunctionEvalBuilder.setAlias(aggFunc.getAlias());
            }
            builder.setAggFunction(aggFunctionEvalBuilder);
        }
        if (function instanceof WindowFunctionEval) {
            WindowFunctionEval winFunc = (WindowFunctionEval)function;
            PlanProto.WinFunctionEvalSpec.Builder windowFuncBuilder = PlanProto.WinFunctionEvalSpec.newBuilder();
            if (winFunc.hasSortSpecs()) {
                windowFuncBuilder.addAllSortSpec(ProtoUtil.toProtoObjects((ProtoObject[])winFunc.getSortSpecs()));
            }
            windowFuncBuilder.setWindowFrame(this.buildWindowFrame(winFunc.getWindowFrame()));
            builder.setWinFunction(windowFuncBuilder);
        }
        context.treeBuilder.addNodes(builder);
        return function;
    }

    private PlanProto.WinFunctionEvalSpec.WindowFrame buildWindowFrame(WindowSpec.WindowFrame frame) {
        PlanProto.WinFunctionEvalSpec.WindowFrame.Builder windowFrameBuilder = PlanProto.WinFunctionEvalSpec.WindowFrame.newBuilder();
        WindowSpec.WindowStartBound startBound = frame.getStartBound();
        WindowSpec.WindowEndBound endBound = frame.getEndBound();
        PlanProto.WinFunctionEvalSpec.WindowStartBound.Builder startBoundBuilder = PlanProto.WinFunctionEvalSpec.WindowStartBound.newBuilder();
        startBoundBuilder.setBoundType(this.convertStartBoundType(startBound.getBoundType()));
        PlanProto.WinFunctionEvalSpec.WindowEndBound.Builder endBoundBuilder = PlanProto.WinFunctionEvalSpec.WindowEndBound.newBuilder();
        endBoundBuilder.setBoundType(this.convertEndBoundType(endBound.getBoundType()));
        windowFrameBuilder.setStartBound(startBoundBuilder);
        windowFrameBuilder.setEndBound(endBoundBuilder);
        return windowFrameBuilder.build();
    }

    private PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType convertStartBoundType(WindowSpec.WindowFrameStartBoundType type) {
        if (type == WindowSpec.WindowFrameStartBoundType.UNBOUNDED_PRECEDING) {
            return PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType.S_UNBOUNDED_PRECEDING;
        }
        if (type == WindowSpec.WindowFrameStartBoundType.CURRENT_ROW) {
            return PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType.S_CURRENT_ROW;
        }
        if (type == WindowSpec.WindowFrameStartBoundType.PRECEDING) {
            return PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType.S_PRECEDING;
        }
        throw new IllegalStateException("Unknown Window Start Bound type: " + type.name());
    }

    private PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType convertEndBoundType(WindowSpec.WindowFrameEndBoundType type) {
        if (type == WindowSpec.WindowFrameEndBoundType.UNBOUNDED_FOLLOWING) {
            return PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType.E_UNBOUNDED_FOLLOWING;
        }
        if (type == WindowSpec.WindowFrameEndBoundType.CURRENT_ROW) {
            return PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType.E_CURRENT_ROW;
        }
        if (type == WindowSpec.WindowFrameEndBoundType.FOLLOWING) {
            return PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType.E_FOLLOWING;
        }
        throw new IllegalStateException("Unknown Window End Bound type: " + type.name());
    }

    public static PlanProto.Datum serialize(Datum datum) {
        PlanProto.Datum.Builder builder = PlanProto.Datum.newBuilder();
        builder.setType(datum.type());
        switch (datum.type()) {
            case NULL_TYPE: {
                break;
            }
            case BOOLEAN: {
                builder.setBoolean(datum.asBool());
                break;
            }
            case INT1: 
            case INT2: 
            case INT4: 
            case DATE: {
                builder.setInt4(datum.asInt4());
                break;
            }
            case INT8: 
            case TIMESTAMP: 
            case TIME: {
                builder.setInt8(datum.asInt8());
                break;
            }
            case FLOAT4: {
                builder.setFloat4(datum.asFloat4());
                break;
            }
            case FLOAT8: {
                builder.setFloat8(datum.asFloat8());
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case TEXT: {
                builder.setText(datum.asChars());
                break;
            }
            case BINARY: 
            case BLOB: {
                builder.setBlob(ByteString.copyFrom((byte[])datum.asByteArray()));
                break;
            }
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                PlanProto.Interval.Builder intervalBuilder = PlanProto.Interval.newBuilder();
                intervalBuilder.setMonth(interval.getMonths());
                intervalBuilder.setMsec(interval.getMilliSeconds());
                builder.setInterval(intervalBuilder);
                break;
            }
            default: {
                throw new RuntimeException("Unknown data type: " + datum.type().name());
            }
        }
        return builder.build();
    }

    public static class EvalTreeProtoBuilderContext {
        private int seqId = 0;
        private Map<EvalNode, Integer> idMap = Maps.newHashMap();
        private PlanProto.EvalNodeTree.Builder treeBuilder = PlanProto.EvalNodeTree.newBuilder();
    }
}

