/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.rewrite.rules;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.AlgebraicUtil;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.PartitionedTableScanNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.StoreTableNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteRule;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.plan.visitor.BasicLogicalPlanVisitor;
import org.apache.tajo.util.TUtil;

public class ProjectionPushDownRule
extends BasicLogicalPlanVisitor<Context, LogicalNode>
implements LogicalPlanRewriteRule {
    private final Log LOG = LogFactory.getLog(ProjectionPushDownRule.class);
    private static final String name = "ProjectionPushDown";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isEligible(OverridableConf queryContext, LogicalPlan plan) {
        Object toBeOptimized = plan.getRootBlock().getRoot();
        if (PlannerUtil.checkIfDDLPlan(toBeOptimized)) {
            return false;
        }
        for (LogicalPlan.QueryBlock eachBlock : plan.getQueryBlocks()) {
            if (!eachBlock.hasTableExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LogicalPlan rewrite(OverridableConf queryContext, LogicalPlan plan) throws PlanningException {
        LogicalPlan.QueryBlock rootBlock;
        LogicalPlan.QueryBlock topmostBlock = rootBlock = plan.getRootBlock();
        Stack<LogicalNode> stack = new Stack<LogicalNode>();
        Context context = new Context(plan);
        this.visit(context, plan, topmostBlock, (LogicalNode)topmostBlock.getRoot(), stack);
        return plan;
    }

    @Override
    public LogicalNode visitRoot(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, LogicalRootNode node, Stack<LogicalNode> stack) throws PlanningException {
        LogicalNode child = (LogicalNode)super.visitRoot(context, plan, block, node, stack);
        node.setInSchema(child.getOutSchema());
        node.setOutSchema(child.getOutSchema());
        return node;
    }

    @Override
    public LogicalNode visitProjection(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, ProjectionNode node, Stack<LogicalNode> stack) throws PlanningException {
        Context newContext = new Context(context);
        Target[] targets = node.getTargets();
        int targetNum = targets.length;
        String[] referenceNames = new String[targetNum];
        for (int i = 0; i < targetNum; ++i) {
            referenceNames[i] = newContext.addExpr(targets[i]);
        }
        LogicalNode child = (LogicalNode)super.visitProjection(newContext, plan, block, node, stack);
        node.setInSchema(child.getOutSchema());
        int evaluationCount = 0;
        List finalTargets = TUtil.newList();
        for (String referenceName : referenceNames) {
            Target target = context.targetListMgr.getTarget(referenceName);
            if (((EvalNode)target.getEvalTree()).getType() == EvalType.CONST) {
                finalTargets.add(target);
                continue;
            }
            if (context.targetListMgr.isEvaluated(referenceName)) {
                if (context.targetListMgr.isNativeAlias(referenceName)) {
                    String realRefName = context.targetListMgr.getRealReferenceName(referenceName);
                    finalTargets.add(new Target(new FieldEval(realRefName, target.getDataType()), referenceName));
                    continue;
                }
                finalTargets.add(new Target(new FieldEval(target.getNamedColumn())));
                continue;
            }
            if (!LogicalPlanner.checkIfBeEvaluatedAtThis(target.getEvalTree(), node)) continue;
            finalTargets.add(target);
            context.targetListMgr.markAsEvaluated(target);
            ++evaluationCount;
        }
        node.setTargets(finalTargets.toArray(new Target[finalTargets.size()]));
        LogicalPlanner.verifyProjectedFields(block, node);
        if (evaluationCount == 0 && PlannerUtil.targetToSchema(finalTargets).equals((Object)child.getOutSchema())) {
            if (stack.empty()) {
                block.setRoot(child);
            } else {
                LogicalNode parentNode = stack.peek();
                switch (parentNode.getType()) {
                    case ROOT: {
                        LogicalRootNode rootNode = (LogicalRootNode)parentNode;
                        rootNode.setChild(child);
                        rootNode.setInSchema(child.getOutSchema());
                        rootNode.setOutSchema(child.getOutSchema());
                        break;
                    }
                    case TABLE_SUBQUERY: {
                        TableSubQueryNode tableSubQueryNode = (TableSubQueryNode)parentNode;
                        tableSubQueryNode.setSubQuery(child);
                        break;
                    }
                    case STORE: {
                        StoreTableNode storeTableNode = (StoreTableNode)parentNode;
                        storeTableNode.setChild(child);
                        storeTableNode.setInSchema(child.getOutSchema());
                        break;
                    }
                    case INSERT: {
                        InsertNode insertNode = (InsertNode)parentNode;
                        insertNode.setSubQuery(child);
                        break;
                    }
                    case CREATE_TABLE: {
                        CreateTableNode createTableNode = (CreateTableNode)parentNode;
                        createTableNode.setChild(child);
                        createTableNode.setInSchema(child.getOutSchema());
                        break;
                    }
                    default: {
                        throw new PlanningException("Unexpected Parent Node: " + (Object)((Object)parentNode.getType()));
                    }
                }
                plan.addHistory("ProjectionNode is eliminated.");
            }
            return child;
        }
        return node;
    }

    @Override
    public LogicalNode visitLimit(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, LimitNode node, Stack<LogicalNode> stack) throws PlanningException {
        LogicalNode child = (LogicalNode)super.visitLimit(context, plan, block, node, stack);
        node.setInSchema(child.getOutSchema());
        node.setOutSchema(child.getOutSchema());
        return node;
    }

    @Override
    public LogicalNode visitSort(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, SortNode node, Stack<LogicalNode> stack) throws PlanningException {
        Context newContext = new Context(context);
        int sortKeyNum = node.getSortKeys().length;
        String[] keyNames = new String[sortKeyNum];
        for (int i = 0; i < sortKeyNum; ++i) {
            SortSpec sortSpec = node.getSortKeys()[i];
            keyNames[i] = newContext.addExpr(new FieldEval(sortSpec.getSortKey()));
        }
        LogicalNode child = (LogicalNode)super.visitSort(newContext, plan, block, node, stack);
        ArrayList<SortSpec> sortSpecs = new ArrayList<SortSpec>();
        for (int i = 0; i < keyNames.length; ++i) {
            SortSpec sortSpec;
            Column c;
            String sortKey = keyNames[i];
            Target target = context.targetListMgr.getTarget(sortKey);
            if (context.targetListMgr.isEvaluated(sortKey)) {
                c = target.getNamedColumn();
                sortSpec = new SortSpec(c, node.getSortKeys()[i].isAscending(), node.getSortKeys()[i].isNullFirst());
                if (sortSpecs.contains(sortSpec)) continue;
                sortSpecs.add(sortSpec);
                continue;
            }
            if (((EvalNode)target.getEvalTree()).getType() != EvalType.FIELD || sortSpecs.contains(sortSpec = new SortSpec(c = ((FieldEval)target.getEvalTree()).getColumnRef(), node.getSortKeys()[i].isAscending(), node.getSortKeys()[i].isNullFirst()))) continue;
            sortSpecs.add(sortSpec);
        }
        node.setSortSpecs(sortSpecs.toArray(new SortSpec[sortSpecs.size()]));
        node.setInSchema(child.getOutSchema());
        node.setOutSchema(child.getOutSchema());
        return node;
    }

    @Override
    public LogicalNode visitHaving(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, HavingNode node, Stack<LogicalNode> stack) throws PlanningException {
        Context newContext = new Context(context);
        String referenceName = newContext.targetListMgr.add(node.getQual());
        newContext.addNecessaryReferences(node.getQual());
        LogicalNode child = (LogicalNode)super.visitHaving(newContext, plan, block, node, stack);
        node.setInSchema(child.getOutSchema());
        node.setOutSchema(child.getOutSchema());
        Target target = context.targetListMgr.getTarget(referenceName);
        if (newContext.targetListMgr.isEvaluated(referenceName)) {
            node.setQual(new FieldEval(target.getNamedColumn()));
        } else {
            node.setQual((EvalNode)target.getEvalTree());
            newContext.targetListMgr.markAsEvaluated(target);
        }
        return node;
    }

    @Override
    public LogicalNode visitWindowAgg(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, WindowAggNode node, Stack<LogicalNode> stack) throws PlanningException {
        Object[] aggEvalNames;
        Context newContext = new Context(context);
        if (node.hasPartitionKeys()) {
            for (Column column : node.getPartitionKeys()) {
                newContext.addNecessaryReferences(new FieldEval(column));
            }
        }
        if (node.hasSortSpecs()) {
            for (SortSpec sortSpec : node.getSortSpecs()) {
                newContext.addNecessaryReferences(new FieldEval(sortSpec.getSortKey()));
            }
        }
        for (WindowFunctionEval windowFunctionEval : node.getWindowFunctions()) {
            if (!windowFunctionEval.hasSortSpecs()) continue;
            for (SortSpec sortSpec : windowFunctionEval.getSortSpecs()) {
                newContext.addNecessaryReferences(new FieldEval(sortSpec.getSortKey()));
            }
        }
        int n = node.getTargets().length - node.getWindowFunctions().length;
        LinkedHashSet nonFunctionColumns = Sets.newLinkedHashSet();
        for (int i = 0; i < n; ++i) {
            FieldEval fieldEval = new FieldEval(node.getTargets()[i].getNamedColumn());
            nonFunctionColumns.add(newContext.addExpr(fieldEval));
        }
        if (node.hasAggFunctions()) {
            int n2 = node.getWindowFunctions().length;
            aggEvalNames = new String[n2];
            int evalIdx = 0;
            for (int targetIdx = n; targetIdx < node.getTargets().length; ++targetIdx) {
                Target target = node.getTargets()[targetIdx];
                WindowFunctionEval winFunc = node.getWindowFunctions()[evalIdx];
                aggEvalNames[evalIdx] = newContext.addExpr(new Target(winFunc, target.getCanonicalName()));
                ++evalIdx;
            }
        } else {
            aggEvalNames = null;
        }
        LogicalNode logicalNode = (LogicalNode)super.visitWindowAgg(newContext, plan, block, node, stack);
        node.setInSchema(logicalNode.getOutSchema());
        ArrayList targets = Lists.newArrayList();
        if (n > 0) {
            for (String column : nonFunctionColumns) {
                Target target = context.targetListMgr.getTarget(column);
                if (context.targetListMgr.isEvaluated(column)) {
                    targets.add(new Target(new FieldEval(target.getNamedColumn())));
                    continue;
                }
                if (((EvalNode)target.getEvalTree()).getType() != EvalType.FIELD) continue;
                targets.add(target);
            }
        }
        if (node.hasAggFunctions() && aggEvalNames != null) {
            WindowFunctionEval[] aggEvals = new WindowFunctionEval[aggEvalNames.length];
            int i = 0;
            Iterator<String> it = ProjectionPushDownRule.getFilteredReferences((String[])aggEvalNames, TUtil.newList((Object[])aggEvalNames));
            while (it.hasNext()) {
                String referenceName = it.next();
                Target target = context.targetListMgr.getTarget(referenceName);
                if (!LogicalPlanner.checkIfBeEvaluatedAtWindowAgg(target.getEvalTree(), node)) continue;
                aggEvals[i++] = (WindowFunctionEval)target.getEvalTree();
                context.targetListMgr.markAsEvaluated(target);
                targets.add(new Target(new FieldEval(target.getNamedColumn())));
            }
            if (aggEvals.length > 0) {
                node.setWindowFunctions(aggEvals);
            }
        }
        node.setTargets(targets.toArray(new Target[targets.size()]));
        return node;
    }

    @Override
    public LogicalNode visitGroupBy(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, GroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        Object[] aggEvalNames;
        Context newContext = new Context(context);
        int groupingKeyNum = node.getGroupingColumns().length;
        LinkedHashSet groupingKeyNames = null;
        if (groupingKeyNum > 0) {
            groupingKeyNames = Sets.newLinkedHashSet();
            for (int i = 0; i < groupingKeyNum; ++i) {
                FieldEval fieldEval = new FieldEval(node.getGroupingColumns()[i]);
                groupingKeyNames.add(newContext.addExpr(fieldEval));
            }
        }
        if (node.hasAggFunctions()) {
            int evalNum = node.getAggFunctions().length;
            aggEvalNames = new String[evalNum];
            int evalIdx = 0;
            for (int targetIdx = groupingKeyNum; targetIdx < node.getTargets().length; ++targetIdx) {
                Target target = node.getTargets()[targetIdx];
                AggregationFunctionCallEval evalNode = node.getAggFunctions()[evalIdx];
                aggEvalNames[evalIdx] = newContext.addExpr(new Target(evalNode, target.getCanonicalName()));
                ++evalIdx;
            }
        } else {
            aggEvalNames = null;
        }
        LogicalNode child = (LogicalNode)super.visitGroupBy(newContext, plan, block, node, stack);
        node.setInSchema(child.getOutSchema());
        ArrayList targets = Lists.newArrayList();
        if (groupingKeyNum > 0 && groupingKeyNames != null) {
            ArrayList<Column> groupingColumns = new ArrayList<Column>();
            for (String groupingKey : groupingKeyNames) {
                Column c;
                Target target = context.targetListMgr.getTarget(groupingKey);
                if (context.targetListMgr.isEvaluated(groupingKey)) {
                    c = target.getNamedColumn();
                    if (groupingColumns.contains(c)) continue;
                    groupingColumns.add(c);
                    targets.add(new Target(new FieldEval(target.getNamedColumn())));
                    continue;
                }
                if (((EvalNode)target.getEvalTree()).getType() == EvalType.FIELD) {
                    c = ((FieldEval)target.getEvalTree()).getColumnRef();
                    if (groupingColumns.contains(c)) continue;
                    groupingColumns.add(c);
                    targets.add(target);
                    context.targetListMgr.markAsEvaluated(target);
                    continue;
                }
                throw new PlanningException("Cannot evaluate this expression in grouping keys: " + target.getEvalTree());
            }
            node.setGroupingColumns(groupingColumns.toArray(new Column[groupingColumns.size()]));
        }
        if (node.hasAggFunctions() && aggEvalNames != null) {
            AggregationFunctionCallEval[] aggEvals = new AggregationFunctionCallEval[aggEvalNames.length];
            int i = 0;
            Iterator<String> it = ProjectionPushDownRule.getFilteredReferences((String[])aggEvalNames, TUtil.newList((Object[])aggEvalNames));
            while (it.hasNext()) {
                String referenceName = it.next();
                Target target = context.targetListMgr.getTarget(referenceName);
                if (!LogicalPlanner.checkIfBeEvaluatedAtGroupBy(target.getEvalTree(), node)) continue;
                aggEvals[i++] = (AggregationFunctionCallEval)target.getEvalTree();
                context.targetListMgr.markAsEvaluated(target);
            }
            if (aggEvals.length > 0) {
                node.setAggFunctions(aggEvals);
            }
        }
        Target[] finalTargets = ProjectionPushDownRule.buildGroupByTarget(node, targets, (String[])aggEvalNames);
        node.setTargets(finalTargets);
        LogicalPlanner.verifyProjectedFields(block, node);
        return node;
    }

    public static Target[] buildGroupByTarget(GroupbyNode groupbyNode, @Nullable List<Target> groupingKeyTargets, String[] aggEvalNames) {
        int groupingKeyIdx;
        int groupingKeyNum = groupingKeyTargets == null ? groupbyNode.getGroupingColumns().length : groupingKeyTargets.size();
        int aggrFuncNum = aggEvalNames != null ? aggEvalNames.length : 0;
        AggregationFunctionCallEval[] aggEvalNodes = groupbyNode.getAggFunctions();
        Target[] targets = new Target[groupingKeyNum + aggrFuncNum];
        if (groupingKeyTargets != null) {
            for (groupingKeyIdx = 0; groupingKeyIdx < groupingKeyNum; ++groupingKeyIdx) {
                targets[groupingKeyIdx] = groupingKeyTargets.get(groupingKeyIdx);
            }
        } else {
            for (groupingKeyIdx = 0; groupingKeyIdx < groupingKeyNum; ++groupingKeyIdx) {
                targets[groupingKeyIdx] = new Target(new FieldEval(groupbyNode.getGroupingColumns()[groupingKeyIdx]));
            }
        }
        if (aggEvalNames != null) {
            int aggrFuncIdx = 0;
            int targetIdx = groupingKeyNum;
            while (aggrFuncIdx < aggrFuncNum) {
                targets[targetIdx] = new Target(new FieldEval(aggEvalNames[aggrFuncIdx], ((EvalNode)aggEvalNodes[aggrFuncIdx]).getValueType()));
                ++aggrFuncIdx;
                ++targetIdx;
            }
        }
        return targets;
    }

    @Override
    public LogicalNode visitFilter(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, SelectionNode node, Stack<LogicalNode> stack) throws PlanningException {
        Context newContext = new Context(context);
        String referenceName = newContext.targetListMgr.add(node.getQual());
        newContext.addNecessaryReferences(node.getQual());
        LogicalNode child = (LogicalNode)super.visitFilter(newContext, plan, block, node, stack);
        node.setInSchema(child.getOutSchema());
        node.setOutSchema(child.getOutSchema());
        Target target = context.targetListMgr.getTarget(referenceName);
        if (newContext.targetListMgr.isEvaluated(referenceName)) {
            node.setQual(new FieldEval(target.getNamedColumn()));
        } else {
            node.setQual((EvalNode)target.getEvalTree());
            newContext.targetListMgr.markAsEvaluated(target);
        }
        return node;
    }

    private static void pushDownIfComplexTermInJoinCondition(Context ctx, EvalNode cnf, EvalNode term) throws PlanningException {
        if (term.getType() != EvalType.FIELD && !(term instanceof BinaryEval) && term.getType() != EvalType.ROW_CONSTANT) {
            String refName = ctx.addExpr(term);
            EvalTreeUtil.replace(cnf, term, new FieldEval(refName, term.getValueType()));
        }
    }

    @Override
    public LogicalNode visitJoin(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode node, Stack<LogicalNode> stack) throws PlanningException {
        Context newContext = new Context(context);
        String joinQualReference = null;
        if (node.hasJoinQual()) {
            for (EvalNode eachQual : AlgebraicUtil.toConjunctiveNormalFormArray(node.getJoinQual())) {
                if (!(eachQual instanceof BinaryEval)) continue;
                BinaryEval binaryQual = (BinaryEval)eachQual;
                for (int i = 0; i < 2; ++i) {
                    EvalNode term = binaryQual.getChild(i);
                    ProjectionPushDownRule.pushDownIfComplexTermInJoinCondition(newContext, eachQual, term);
                }
            }
            joinQualReference = newContext.addExpr(node.getJoinQual());
            newContext.addNecessaryReferences(node.getJoinQual());
        }
        String[] referenceNames = null;
        if (node.hasTargets()) {
            referenceNames = new String[node.getTargets().length];
            int i = 0;
            Iterator<Target> it = ProjectionPushDownRule.getFilteredTarget(node.getTargets(), context.requiredSet);
            while (it.hasNext()) {
                Target target = it.next();
                referenceNames[i++] = newContext.addExpr(target);
            }
        }
        stack.push(node);
        LogicalNode left = (LogicalNode)this.visit(newContext, plan, block, (LogicalNode)node.getLeftChild(), stack);
        LogicalNode right = (LogicalNode)this.visit(newContext, plan, block, (LogicalNode)node.getRightChild(), stack);
        stack.pop();
        Schema merged = SchemaUtil.merge((Schema)left.getOutSchema(), (Schema)right.getOutSchema());
        node.setInSchema(merged);
        if (node.hasJoinQual()) {
            Target target = context.targetListMgr.getTarget(joinQualReference);
            if (newContext.targetListMgr.isEvaluated(joinQualReference)) {
                throw new PlanningException("Join condition must be evaluated in the proper Join Node: " + joinQualReference);
            }
            node.setJoinQual((EvalNode)target.getEvalTree());
            newContext.targetListMgr.markAsEvaluated(target);
        }
        LinkedHashSet projectedTargets = Sets.newLinkedHashSet();
        Iterator<String> it = ProjectionPushDownRule.getFilteredReferences(context.targetListMgr.getNames(), context.requiredSet);
        while (it.hasNext()) {
            String referenceName = it.next();
            Target target = context.targetListMgr.getTarget(referenceName);
            if (context.targetListMgr.isEvaluated(referenceName)) {
                Target fieldReference = new Target(new FieldEval(target.getNamedColumn()));
                if (!LogicalPlanner.checkIfBeEvaluatedAtJoin(block, fieldReference.getEvalTree(), node, stack.peek().getType() != NodeType.JOIN)) continue;
                projectedTargets.add(fieldReference);
                continue;
            }
            if (!LogicalPlanner.checkIfBeEvaluatedAtJoin(block, target.getEvalTree(), node, stack.peek().getType() != NodeType.JOIN)) continue;
            projectedTargets.add(target);
            context.targetListMgr.markAsEvaluated(target);
        }
        node.setTargets(projectedTargets.toArray(new Target[projectedTargets.size()]));
        LogicalPlanner.verifyProjectedFields(block, node);
        return node;
    }

    static Iterator<String> getFilteredReferences(Collection<String> targetNames, Set<String> required) {
        return new FilteredStringsIterator(targetNames, required);
    }

    static Iterator<String> getFilteredReferences(String[] targetNames, Collection<String> required) {
        return new FilteredStringsIterator(targetNames, required);
    }

    static Iterator<Target> getFilteredTarget(Target[] targets, Set<String> required) {
        return new FilteredIterator(targets, required);
    }

    @Override
    public LogicalNode visitUnion(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnionNode node, Stack<LogicalNode> stack) throws PlanningException {
        LogicalPlan.QueryBlock leftBlock = plan.getBlock((LogicalNode)node.getLeftChild());
        LogicalPlan.QueryBlock rightBlock = plan.getBlock((LogicalNode)node.getRightChild());
        Context leftContext = new Context(plan, PlannerUtil.toQualifiedFieldNames(context.requiredSet, leftBlock.getName()));
        Context rightContext = new Context(plan, PlannerUtil.toQualifiedFieldNames(context.requiredSet, rightBlock.getName()));
        stack.push(node);
        this.visit(leftContext, plan, leftBlock, (LogicalNode)leftBlock.getRoot(), new Stack<LogicalNode>());
        this.visit(rightContext, plan, rightBlock, (LogicalNode)rightBlock.getRoot(), new Stack<LogicalNode>());
        stack.pop();
        return node;
    }

    @Override
    public LogicalNode visitScan(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        Target target;
        Context newContext = new Context(context);
        Target[] targets = node.hasTargets() ? node.getTargets() : PlannerUtil.schemaToTargets(node.getLogicalSchema());
        LinkedHashSet projectedTargets = Sets.newLinkedHashSet();
        Iterator<Target> it = ProjectionPushDownRule.getFilteredTarget(targets, newContext.requiredSet);
        while (it.hasNext()) {
            target = it.next();
            newContext.addExpr(target);
        }
        it = context.targetListMgr.getFilteredTargets(newContext.requiredSet);
        while (it.hasNext()) {
            target = it.next();
            if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, target.getEvalTree(), node)) continue;
            projectedTargets.add(target);
            newContext.targetListMgr.markAsEvaluated(target);
        }
        node.setTargets(projectedTargets.toArray(new Target[projectedTargets.size()]));
        LogicalPlanner.verifyProjectedFields(block, node);
        return node;
    }

    @Override
    public LogicalNode visitPartitionedTableScan(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, PartitionedTableScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        Target target;
        Context newContext = new Context(context);
        Target[] targets = node.hasTargets() ? node.getTargets() : PlannerUtil.schemaToTargets(node.getOutSchema());
        LinkedHashSet projectedTargets = Sets.newLinkedHashSet();
        Iterator<Target> it = ProjectionPushDownRule.getFilteredTarget(targets, newContext.requiredSet);
        while (it.hasNext()) {
            target = it.next();
            newContext.addExpr(target);
        }
        it = context.targetListMgr.getFilteredTargets(newContext.requiredSet);
        while (it.hasNext()) {
            target = it.next();
            if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, target.getEvalTree(), node)) continue;
            projectedTargets.add(target);
            newContext.targetListMgr.markAsEvaluated(target);
        }
        node.setTargets(projectedTargets.toArray(new Target[projectedTargets.size()]));
        LogicalPlanner.verifyProjectedFields(block, node);
        return node;
    }

    @Override
    public LogicalNode visitTableSubQuery(Context upperContext, LogicalPlan plan, LogicalPlan.QueryBlock block, TableSubQueryNode node, Stack<LogicalNode> stack) throws PlanningException {
        Target target;
        Context childContext = new Context(plan, upperContext.requiredSet);
        stack.push(node);
        LogicalNode child = (LogicalNode)super.visitTableSubQuery(childContext, plan, block, node, stack);
        node.setSubQuery(child);
        stack.pop();
        Target[] targets = node.hasTargets() ? node.getTargets() : PlannerUtil.schemaToTargets(node.getOutSchema());
        LinkedHashSet projectedTargets = Sets.newLinkedHashSet();
        Iterator<Target> it = ProjectionPushDownRule.getFilteredTarget(targets, upperContext.requiredSet);
        while (it.hasNext()) {
            target = it.next();
            upperContext.addExpr(target);
        }
        it = upperContext.targetListMgr.getFilteredTargets(upperContext.requiredSet);
        while (it.hasNext()) {
            target = it.next();
            if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, target.getEvalTree(), node)) continue;
            projectedTargets.add(target);
            upperContext.targetListMgr.markAsEvaluated(target);
        }
        node.setTargets(projectedTargets.toArray(new Target[projectedTargets.size()]));
        LogicalPlanner.verifyProjectedFields(block, node);
        return node;
    }

    @Override
    public LogicalNode visitInsert(Context context, LogicalPlan plan, LogicalPlan.QueryBlock block, InsertNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return node;
    }

    static class FilteredIterator
    implements Iterator<Target> {
        Iterator<Target> iterator;

        FilteredIterator(Target[] targets, Set<String> requiredReferences) {
            List filtered = TUtil.newList();
            HashMap<String, Target> targetSet = new HashMap<String, Target>();
            for (Target t : targets) {
                if (targetSet.containsKey(t.getCanonicalName())) {
                    Target targetInSet = (Target)targetSet.get(t.getCanonicalName());
                    Object evalNode = targetInSet.getEvalTree();
                    if (((EvalNode)evalNode).getType() != EvalType.FIELD || ((EvalNode)t.getEvalTree()).getType() == EvalType.FIELD) continue;
                    targetSet.put(t.getCanonicalName(), t);
                    continue;
                }
                targetSet.put(t.getCanonicalName(), t);
            }
            for (String name : requiredReferences) {
                if (!targetSet.containsKey(name)) continue;
                filtered.add(targetSet.get(name));
            }
            this.iterator = filtered.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Target next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
        }
    }

    static class FilteredStringsIterator
    implements Iterator<String> {
        Iterator<String> iterator;

        FilteredStringsIterator(Collection<String> targetNames, Collection<String> required) {
            List filtered = TUtil.newList();
            for (String name : targetNames) {
                if (!required.contains(name)) continue;
                filtered.add(name);
            }
            this.iterator = filtered.iterator();
        }

        FilteredStringsIterator(String[] targetNames, Collection<String> required) {
            this(TUtil.newList((Object[])targetNames), required);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
        }
    }

    static class Context {
        TargetListManager targetListMgr;
        Set<String> requiredSet;

        public Context(LogicalPlan plan) {
            this.requiredSet = new LinkedHashSet<String>();
            this.targetListMgr = new TargetListManager(plan);
        }

        public Context(LogicalPlan plan, Collection<String> requiredSet) {
            this.requiredSet = new LinkedHashSet<String>(requiredSet);
            this.targetListMgr = new TargetListManager(plan);
        }

        public Context(Context upperContext) {
            this.requiredSet = new LinkedHashSet<String>(upperContext.requiredSet);
            this.targetListMgr = upperContext.targetListMgr;
        }

        public String addExpr(Target target) throws PlanningException {
            String reference = this.targetListMgr.add(target);
            this.addNecessaryReferences((EvalNode)target.getEvalTree());
            return reference;
        }

        public String addExpr(EvalNode evalNode) throws PlanningException {
            String reference = this.targetListMgr.add(evalNode);
            this.addNecessaryReferences(evalNode);
            return reference;
        }

        private void addNecessaryReferences(EvalNode evalNode) {
            for (Column column : EvalTreeUtil.findUniqueColumns(evalNode)) {
                this.requiredSet.add(column.getQualifiedName());
            }
        }

        public String toString() {
            return "required=" + this.requiredSet.size() + "," + this.targetListMgr.toString();
        }
    }

    public static class TargetListManager {
        private Integer seqId = 0;
        private LinkedHashMap<String, Integer> nameToIdBiMap;
        private BiMap<Integer, EvalNode> idToEvalBiMap;
        private LinkedHashMap<Integer, List<String>> idToNamesMap;
        private LinkedHashMap<Integer, Boolean> evaluationStateMap;
        private LinkedHashMap<String, Integer> aliasMap;
        private LogicalPlan plan;

        public TargetListManager(LogicalPlan plan) {
            this.plan = plan;
            this.nameToIdBiMap = Maps.newLinkedHashMap();
            this.idToEvalBiMap = HashBiMap.create();
            this.idToNamesMap = Maps.newLinkedHashMap();
            this.evaluationStateMap = Maps.newLinkedHashMap();
            this.aliasMap = Maps.newLinkedHashMap();
        }

        private int getNextSeqId() {
            Integer n = this.seqId;
            Integer n2 = this.seqId = Integer.valueOf(this.seqId + 1);
            return n;
        }

        public boolean isNativeAlias(String name) {
            return this.aliasMap.containsKey(name);
        }

        public String getRealReferenceName(String name) {
            int refId = this.aliasMap.get(name);
            return this.getPrimaryName(refId);
        }

        private String add(String specifiedName, EvalNode evalNode) throws PlanningException {
            int refId;
            EvalNode found;
            if (this.nameToIdBiMap.containsKey(specifiedName) && (found = (EvalNode)this.idToEvalBiMap.get((Object)(refId = this.nameToIdBiMap.get(specifiedName).intValue()))) != null) {
                if (evalNode.equals(found)) {
                    return specifiedName;
                }
                if (found.getType() != EvalType.FIELD && evalNode.getType() != EvalType.FIELD) {
                    throw new PlanningException("Duplicate alias: " + evalNode);
                }
                if (found.getType() == EvalType.FIELD) {
                    Integer daggling = (Integer)this.idToEvalBiMap.inverse().get((Object)evalNode);
                    this.idToEvalBiMap.forcePut((Object)refId, (Object)evalNode);
                    if (daggling != null) {
                        String name = this.getPrimaryName(daggling);
                        this.idToNamesMap.remove(daggling);
                        this.nameToIdBiMap.put(name, refId);
                        if (!this.idToNamesMap.get(refId).contains(name)) {
                            TUtil.putToNestedList(this.idToNamesMap, (Object)refId, (Object)name);
                        }
                    }
                }
            }
            if (this.idToEvalBiMap.inverse().containsKey((Object)evalNode)) {
                refId = (Integer)this.idToEvalBiMap.inverse().get((Object)evalNode);
                this.aliasMap.put(specifiedName, refId);
            } else {
                refId = this.getNextSeqId();
                this.idToEvalBiMap.put((Object)refId, (Object)evalNode);
                TUtil.putToNestedList(this.idToNamesMap, (Object)refId, (Object)specifiedName);
                for (Column column : EvalTreeUtil.findUniqueColumns(evalNode)) {
                    this.add(new FieldEval(column));
                }
                this.evaluationStateMap.put(refId, false);
            }
            this.nameToIdBiMap.put(specifiedName, refId);
            return specifiedName;
        }

        public String add(EvalNode evalNode) throws PlanningException {
            String name;
            FieldEval fieldEval;
            if (evalNode.getType() == EvalType.FIELD && this.nameToIdBiMap.containsKey((fieldEval = (FieldEval)evalNode).getName())) {
                int refId = this.nameToIdBiMap.get(fieldEval.getName());
                return this.getPrimaryName(refId);
            }
            if (this.idToEvalBiMap.inverse().containsKey((Object)evalNode)) {
                int refId = (Integer)this.idToEvalBiMap.inverse().get((Object)evalNode);
                return this.getPrimaryName(refId);
            }
            if (evalNode.getType() == EvalType.FIELD) {
                fieldEval = (FieldEval)evalNode;
                name = fieldEval.getName();
            } else {
                name = this.plan.generateUniqueColumnName(evalNode);
            }
            return this.add(name, evalNode);
        }

        public Collection<String> getNames() {
            return this.nameToIdBiMap.keySet();
        }

        public String add(Target target) throws PlanningException {
            return this.add(target.getCanonicalName(), (EvalNode)target.getEvalTree());
        }

        private boolean isPrimaryName(int refId, String name) {
            if (this.idToNamesMap.get(refId).size() > 0) {
                return this.getPrimaryName(refId).equals(name);
            }
            return false;
        }

        private String getPrimaryName(int refId) {
            return this.idToNamesMap.get(refId).get(0);
        }

        public Target getTarget(String name) {
            if (!this.nameToIdBiMap.containsKey(name)) {
                throw new RuntimeException("No Such target name: " + name);
            }
            int id = this.nameToIdBiMap.get(name);
            EvalNode evalNode = (EvalNode)this.idToEvalBiMap.get((Object)id);
            if (evalNode.getType() == EvalType.CONST) {
                return new Target(evalNode, name);
            }
            if (!this.isPrimaryName(id, name) && this.isEvaluated(this.getPrimaryName(id))) {
                evalNode = new FieldEval(this.getPrimaryName(id), evalNode.getValueType());
            }
            if (evalNode.getType() == EvalType.FIELD && evalNode.getName().equals(name)) {
                return new Target((FieldEval)evalNode);
            }
            return new Target(evalNode, name);
        }

        public boolean isEvaluated(String name) {
            if (!this.nameToIdBiMap.containsKey(name)) {
                throw new RuntimeException("No Such target name: " + name);
            }
            int refId = this.nameToIdBiMap.get(name);
            return this.evaluationStateMap.get(refId);
        }

        public void markAsEvaluated(Target target) {
            int refId = this.nameToIdBiMap.get(target.getCanonicalName());
            Object evalNode = target.getEvalTree();
            if (!this.idToNamesMap.containsKey(refId)) {
                throw new RuntimeException("No such eval: " + evalNode);
            }
            this.evaluationStateMap.put(refId, true);
        }

        public Iterator<Target> getFilteredTargets(Set<String> required) {
            return new FilteredTargetIterator(required);
        }

        public String toString() {
            int evaluated = 0;
            for (Boolean flag : this.evaluationStateMap.values()) {
                if (!flag.booleanValue()) continue;
                ++evaluated;
            }
            return "eval=" + this.evaluationStateMap.size() + ", evaluated=" + evaluated;
        }

        class FilteredTargetIterator
        implements Iterator<Target> {
            List<Target> filtered = TUtil.newList();
            Iterator<Target> iterator;

            public FilteredTargetIterator(Set<String> required) {
                for (String name : TargetListManager.this.nameToIdBiMap.keySet()) {
                    if (!required.contains(name)) continue;
                    this.filtered.add(TargetListManager.this.getTarget(name));
                }
                this.iterator = this.filtered.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Target next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
            }
        }
    }
}

