/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.rewrite.rules;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.plan.InvalidQueryException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AlgebraicUtil;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteRule;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.plan.visitor.BasicLogicalPlanVisitor;
import org.apache.tajo.util.TUtil;

public class FilterPushDownRule
extends BasicLogicalPlanVisitor<FilterPushDownContext, LogicalNode>
implements LogicalPlanRewriteRule {
    private static final Log LOG = LogFactory.getLog(FilterPushDownRule.class);
    private static final String NAME = "FilterPushDown";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEligible(OverridableConf queryContext, LogicalPlan plan) {
        for (LogicalPlan.QueryBlock block : plan.getQueryBlocks()) {
            if (!block.hasNode(NodeType.SELECTION) && !block.hasNode(NodeType.JOIN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LogicalPlan rewrite(OverridableConf queryContext, LogicalPlan plan) throws PlanningException {
        FilterPushDownContext context = new FilterPushDownContext();
        for (LogicalPlan.QueryBlock block : plan.getQueryBlocks()) {
            context.clear();
            this.visit(context, plan, block, (LogicalNode)block.getRoot(), new Stack<LogicalNode>());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"=============================================");
            LOG.debug((Object)("FilterPushDown Optimized Query: \n" + plan.toString()));
            LOG.debug((Object)"=============================================");
        }
        return plan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LogicalNode visitFilter(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, SelectionNode selNode, Stack<LogicalNode> stack) throws PlanningException {
        context.pushingDownFilters.addAll(Sets.newHashSet((Object[])AlgebraicUtil.toConjunctiveNormalFormArray(selNode.getQual())));
        stack.push(selNode);
        this.visit(context, plan, block, (LogicalNode)selNode.getChild(), stack);
        stack.pop();
        if (context.pushingDownFilters.size() == 0) {
            LogicalNode node = stack.peek();
            if (!(node instanceof UnaryNode)) throw new InvalidQueryException("Unexpected Logical Query Plan");
            UnaryNode unary = (UnaryNode)node;
            unary.setChild((LogicalNode)selNode.getChild());
            return selNode;
        } else {
            Set matched = TUtil.newHashSet();
            for (EvalNode eachEval : context.pushingDownFilters) {
                if (!LogicalPlanner.checkIfBeEvaluatedAtThis(eachEval, selNode)) continue;
                matched.add(eachEval);
            }
            if (matched.size() <= 0) return selNode;
            selNode.setQual(AlgebraicUtil.createSingletonExprFromCNF(matched.toArray(new EvalNode[matched.size()])));
            context.pushingDownFilters.removeAll(matched);
        }
        return selNode;
    }

    @Override
    public LogicalNode visitJoin(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode joinNode, Stack<LogicalNode> stack) throws PlanningException {
        BinaryEval binaryEval;
        JoinType joinType = joinNode.getJoinType();
        EvalNode joinQual = joinNode.getJoinQual();
        if (joinQual != null && LogicalPlanner.isOuterJoin(joinType) && ((EvalNode)(binaryEval = (BinaryEval)joinQual).getLeftExpr()).getType() == EvalType.FIELD && ((EvalNode)binaryEval.getRightExpr()).getType() == EvalType.FIELD) {
            String leftTableName = ((FieldEval)binaryEval.getLeftExpr()).getQualifier();
            String rightTableName = ((FieldEval)binaryEval.getRightExpr()).getQualifier();
            ArrayList nullSuppliers = Lists.newArrayList();
            HashSet leftTableSet = Sets.newHashSet(PlannerUtil.getRelationLineageWithinQueryBlock(plan, joinNode.getLeftChild()));
            HashSet rightTableSet = Sets.newHashSet(PlannerUtil.getRelationLineageWithinQueryBlock(plan, joinNode.getRightChild()));
            if (joinType == JoinType.FULL_OUTER) {
                nullSuppliers.add(leftTableName);
                nullSuppliers.add(rightTableName);
                if (!rightTableSet.contains(nullSuppliers.get(0)) && !leftTableSet.contains(nullSuppliers.get(0))) {
                    throw new InvalidQueryException("Incorrect Logical Query Plan with regard to outer join");
                }
                if (!rightTableSet.contains(nullSuppliers.get(1)) && !leftTableSet.contains(nullSuppliers.get(1))) {
                    throw new InvalidQueryException("Incorrect Logical Query Plan with regard to outer join");
                }
            } else if (joinType == JoinType.LEFT_OUTER) {
                nullSuppliers.add(((RelationNode)joinNode.getRightChild()).getCanonicalName());
                if (!rightTableSet.contains(nullSuppliers.get(0))) {
                    throw new InvalidQueryException("Incorrect Logical Query Plan with regard to outer join");
                }
            } else if (joinType == JoinType.RIGHT_OUTER) {
                if (((RelationNode)joinNode.getRightChild()).getCanonicalName().equals(rightTableName)) {
                    nullSuppliers.add(leftTableName);
                } else {
                    nullSuppliers.add(rightTableName);
                }
                if (!leftTableSet.contains(nullSuppliers.get(0))) {
                    throw new InvalidQueryException("Incorrect Logical Query Plan with regard to outer join");
                }
            }
        }
        ArrayList<EvalNode> thetaJoinFilter = new ArrayList<EvalNode>();
        for (EvalNode eachEval : context.pushingDownFilters) {
            if (eachEval.getType() == EvalType.EQUAL || !EvalTreeUtil.isJoinQual(block, ((LogicalNode)joinNode.getLeftChild()).getOutSchema(), ((LogicalNode)joinNode.getRightChild()).getOutSchema(), eachEval, true)) continue;
            thetaJoinFilter.add(eachEval);
        }
        context.pushingDownFilters.removeAll(thetaJoinFilter);
        ArrayList onConditions = new ArrayList();
        if (joinNode.hasJoinQual()) {
            onConditions.addAll(Sets.newHashSet((Object[])AlgebraicUtil.toConjunctiveNormalFormArray(joinNode.getJoinQual())));
        }
        boolean isTopMostJoin = stack.peek().getType() != NodeType.JOIN;
        ArrayList<EvalNode> outerJoinPredicationEvals = new ArrayList<EvalNode>();
        ArrayList<EvalNode> outerJoinFilterEvalsExcludePredication = new ArrayList<EvalNode>();
        if (LogicalPlanner.isOuterJoin(joinNode.getJoinType())) {
            boolean canPushDown;
            LinkedHashSet<Column> columns;
            Set nullSupplyingTableNameSet = joinNode.getJoinType() == JoinType.RIGHT_OUTER ? TUtil.newHashSet((Object[])PlannerUtil.getRelationLineage(joinNode.getLeftChild())) : TUtil.newHashSet((Object[])PlannerUtil.getRelationLineage(joinNode.getRightChild()));
            Set preservedTableNameSet = joinNode.getJoinType() == JoinType.RIGHT_OUTER ? TUtil.newHashSet((Object[])PlannerUtil.getRelationLineage(joinNode.getRightChild())) : TUtil.newHashSet((Object[])PlannerUtil.getRelationLineage(joinNode.getLeftChild()));
            ArrayList<EvalNode> removedFromFilter = new ArrayList<EvalNode>();
            for (EvalNode eachEval : context.pushingDownFilters) {
                if (EvalTreeUtil.isJoinQual(block, ((LogicalNode)joinNode.getLeftChild()).getOutSchema(), ((LogicalNode)joinNode.getRightChild()).getOutSchema(), eachEval, true)) {
                    outerJoinPredicationEvals.add(eachEval);
                    removedFromFilter.add(eachEval);
                    continue;
                }
                columns = EvalTreeUtil.findUniqueColumns(eachEval);
                canPushDown = true;
                for (Column eachColumn : columns) {
                    if (!nullSupplyingTableNameSet.contains(eachColumn.getQualifier())) continue;
                    canPushDown = false;
                    break;
                }
                if (canPushDown) continue;
                outerJoinFilterEvalsExcludePredication.add(eachEval);
                removedFromFilter.add(eachEval);
            }
            context.pushingDownFilters.removeAll(removedFromFilter);
            for (EvalNode eachOnEval : onConditions) {
                if (EvalTreeUtil.isJoinQual(eachOnEval, true)) {
                    outerJoinPredicationEvals.add(eachOnEval);
                    continue;
                }
                columns = EvalTreeUtil.findUniqueColumns(eachOnEval);
                canPushDown = true;
                for (Column eachColumn : columns) {
                    if (!preservedTableNameSet.contains(eachColumn.getQualifier())) continue;
                    canPushDown = false;
                    break;
                }
                if (canPushDown) {
                    context.pushingDownFilters.add(eachOnEval);
                    continue;
                }
                outerJoinPredicationEvals.add(eachOnEval);
            }
        } else {
            context.pushingDownFilters.addAll(onConditions);
        }
        Object left = joinNode.getLeftChild();
        Object right = joinNode.getRightChild();
        ArrayList<EvalNode> notMatched = new ArrayList<EvalNode>();
        BiMap<EvalNode, EvalNode> transformedMap = this.findCanPushdownAndTransform(context, block, joinNode, (LogicalNode)left, (List<EvalNode>)notMatched, null, true, 0);
        context.setFiltersTobePushed(transformedMap.keySet());
        this.visit(context, plan, block, (LogicalNode)left, stack);
        context.setToOrigin((Map<EvalNode, EvalNode>)transformedMap);
        context.addFiltersTobePushed(notMatched);
        notMatched.clear();
        transformedMap = this.findCanPushdownAndTransform(context, block, joinNode, (LogicalNode)right, (List<EvalNode>)notMatched, null, true, ((LogicalNode)left).getOutSchema().size());
        context.setFiltersTobePushed(new HashSet<EvalNode>(transformedMap.keySet()));
        this.visit(context, plan, block, (LogicalNode)right, stack);
        context.setToOrigin((Map<EvalNode, EvalNode>)transformedMap);
        context.addFiltersTobePushed(notMatched);
        notMatched.clear();
        ArrayList matched = Lists.newArrayList();
        if (LogicalPlanner.isOuterJoin(joinNode.getJoinType())) {
            matched.addAll(outerJoinPredicationEvals);
        } else {
            for (EvalNode eval : context.pushingDownFilters) {
                if (!LogicalPlanner.checkIfBeEvaluatedAtJoin(block, eval, joinNode, isTopMostJoin)) continue;
                matched.add(eval);
            }
        }
        EvalNode qual = null;
        if (matched.size() > 1) {
            qual = AlgebraicUtil.createSingletonExprFromCNF(matched.toArray(new EvalNode[matched.size()]));
        } else if (matched.size() == 1) {
            qual = (EvalNode)matched.get(0);
        }
        if (qual != null) {
            joinNode.setJoinQual(qual);
            if (joinNode.getJoinType() == JoinType.CROSS) {
                joinNode.setJoinType(JoinType.INNER);
            }
            context.pushingDownFilters.removeAll(matched);
        }
        context.pushingDownFilters.addAll(outerJoinFilterEvalsExcludePredication);
        context.pushingDownFilters.addAll(thetaJoinFilter);
        return joinNode;
    }

    private Map<EvalNode, EvalNode> transformEvalsWidthByPassNode(Collection<EvalNode> originEvals, LogicalPlan plan, LogicalPlan.QueryBlock block, LogicalNode node, LogicalNode childNode) throws PlanningException {
        HashMap<EvalNode, EvalNode> transformedMap = new HashMap<EvalNode, EvalNode>();
        if (originEvals.isEmpty()) {
            return transformedMap;
        }
        if (node.getType() == NodeType.UNION) {
            Schema childOutSchema = childNode.getOutSchema();
            for (EvalNode eval : originEvals) {
                EvalNode copy;
                try {
                    copy = (EvalNode)eval.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new PlanningException(e);
                }
                LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(copy);
                for (Column c : columns) {
                    Column column = childOutSchema.getColumn(c.getSimpleName());
                    if (column == null) {
                        throw new PlanningException("Invalid Filter PushDown on SubQuery: No such a corresponding column '" + c.getQualifiedName() + " for FilterPushDown(" + eval + "), " + "(PID=" + node.getPID() + ", Child=" + childNode.getPID() + ")");
                    }
                    EvalTreeUtil.changeColumnRef(copy, c.getSimpleName(), column.getQualifiedName());
                }
                transformedMap.put(copy, eval);
            }
            return transformedMap;
        }
        if (childNode.getType() == NodeType.UNION) {
            for (EvalNode eval : originEvals) {
                EvalNode copy;
                try {
                    copy = (EvalNode)eval.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new PlanningException(e);
                }
                LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(copy);
                for (Column c : columns) {
                    if (!c.hasQualifier()) continue;
                    EvalTreeUtil.changeColumnRef(copy, c.getQualifiedName(), c.getSimpleName());
                }
                transformedMap.put(copy, eval);
            }
            return transformedMap;
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (int i = 0; i < node.getInSchema().size(); ++i) {
            String inColumnName = node.getInSchema().getColumn(i).getQualifiedName();
            Column childOutColumn = childNode.getOutSchema().getColumn(i);
            columnMap.put(inColumnName, childOutColumn.getQualifiedName());
        }
        for (EvalNode matchedEval : originEvals) {
            EvalNode copy;
            try {
                copy = (EvalNode)matchedEval.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new PlanningException(e);
            }
            LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(copy);
            boolean allMatched = true;
            for (Column c : columns) {
                if (columnMap.containsKey(c.getQualifiedName())) {
                    EvalTreeUtil.changeColumnRef(copy, c.getQualifiedName(), (String)columnMap.get(c.getQualifiedName()));
                    continue;
                }
                if (childNode.getType() == NodeType.GROUP_BY) {
                    if (!((GroupbyNode)childNode).isAggregationColumn(c.getSimpleName())) continue;
                    allMatched = false;
                    break;
                }
                throw new PlanningException("Invalid Filter PushDown on SubQuery: No such a corresponding column '" + c.getQualifiedName() + " for FilterPushDown(" + matchedEval + "), " + "(PID=" + node.getPID() + ", Child=" + childNode.getPID() + ")");
            }
            if (!allMatched) continue;
            transformedMap.put(copy, matchedEval);
        }
        return transformedMap;
    }

    @Override
    public LogicalNode visitTableSubQuery(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, TableSubQueryNode node, Stack<LogicalNode> stack) throws PlanningException {
        ArrayList matched = Lists.newArrayList();
        for (EvalNode eval : context.pushingDownFilters) {
            if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, eval, node)) continue;
            matched.add(eval);
        }
        Map<EvalNode, EvalNode> transformedMap = this.transformEvalsWidthByPassNode(matched, plan, block, node, node.getSubQuery());
        context.setFiltersTobePushed(new HashSet<EvalNode>(transformedMap.keySet()));
        this.visit(context, plan, plan.getBlock(node.getSubQuery()));
        context.setToOrigin(transformedMap);
        return node;
    }

    @Override
    public LogicalNode visitUnion(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnionNode unionNode, Stack<LogicalNode> stack) throws PlanningException {
        Object leftNode = unionNode.getLeftChild();
        ArrayList<EvalNode> origins = new ArrayList<EvalNode>(context.pushingDownFilters);
        Map<EvalNode, EvalNode> transformedMap = this.transformEvalsWidthByPassNode((Collection<EvalNode>)origins, plan, block, unionNode, (LogicalNode)leftNode);
        context.setFiltersTobePushed(new HashSet<EvalNode>(transformedMap.keySet()));
        this.visit(context, plan, plan.getBlock((LogicalNode)leftNode));
        if (!context.pushingDownFilters.isEmpty()) {
            this.errorFilterPushDown(plan, (LogicalNode)leftNode, context);
        }
        Object rightNode = unionNode.getRightChild();
        transformedMap = this.transformEvalsWidthByPassNode((Collection<EvalNode>)origins, plan, block, unionNode, (LogicalNode)rightNode);
        context.setFiltersTobePushed(new HashSet<EvalNode>(transformedMap.keySet()));
        this.visit(context, plan, plan.getBlock((LogicalNode)rightNode), (LogicalNode)rightNode, stack);
        if (!context.pushingDownFilters.isEmpty()) {
            this.errorFilterPushDown(plan, (LogicalNode)rightNode, context);
        }
        context.pushingDownFilters.clear();
        return unionNode;
    }

    @Override
    public LogicalNode visitProjection(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, ProjectionNode projectionNode, Stack<LogicalNode> stack) throws PlanningException {
        Object childNode = projectionNode.getChild();
        ArrayList<EvalNode> notMatched = new ArrayList<EvalNode>();
        BiMap<EvalNode, EvalNode> transformedMap = this.findCanPushdownAndTransform(context, block, projectionNode, (LogicalNode)childNode, (List<EvalNode>)notMatched, null, false, 0);
        context.setFiltersTobePushed(transformedMap.keySet());
        stack.push(projectionNode);
        childNode = (LogicalNode)this.visit(context, plan, plan.getBlock((LogicalNode)childNode), (LogicalNode)childNode, stack);
        stack.pop();
        for (EvalNode eval : context.pushingDownFilters) {
            notMatched.add((EvalNode)transformedMap.get((Object)eval));
        }
        EvalNode qual = null;
        if (notMatched.size() > 1) {
            qual = AlgebraicUtil.createSingletonExprFromCNF(notMatched.toArray(new EvalNode[notMatched.size()]));
        } else if (notMatched.size() == 1) {
            qual = (EvalNode)notMatched.get(0);
        }
        if (qual != null && LogicalPlanner.checkIfBeEvaluatedAtThis(qual, projectionNode)) {
            SelectionNode selectionNode = plan.createNode(SelectionNode.class);
            selectionNode.setInSchema(((LogicalNode)childNode).getOutSchema());
            selectionNode.setOutSchema(((LogicalNode)childNode).getOutSchema());
            selectionNode.setQual(qual);
            block.registerNode(selectionNode);
            projectionNode.setChild(selectionNode);
            selectionNode.setChild((LogicalNode)childNode);
            context.pushingDownFilters.clear();
        }
        if (context.pushingDownFilters.size() > 0) {
            ImmutableSet copy = ImmutableSet.copyOf(context.pushingDownFilters);
            context.pushingDownFilters.clear();
            context.pushingDownFilters.addAll(this.reverseTransform(transformedMap, (Set<EvalNode>)copy));
        }
        return projectionNode;
    }

    private Collection<EvalNode> reverseTransform(BiMap<EvalNode, EvalNode> map, Set<EvalNode> remainFilters) {
        HashSet reversed = Sets.newHashSet();
        for (EvalNode evalNode : remainFilters) {
            reversed.add(map.get((Object)evalNode));
        }
        return reversed;
    }

    private BiMap<EvalNode, EvalNode> findCanPushdownAndTransform(FilterPushDownContext context, LogicalPlan.QueryBlock block, Projectable node, LogicalNode childNode, List<EvalNode> notMatched, Set<String> partitionColumns, boolean ignoreJoin, int columnOffset) throws PlanningException {
        HashMap<String, Target> nodeTargetMap = new HashMap<String, Target>();
        for (Target target : node.getTargets()) {
            nodeTargetMap.put(target.getCanonicalName(), target);
        }
        HashBiMap matched = HashBiMap.create();
        for (EvalNode eval : context.pushingDownFilters) {
            if (ignoreJoin && EvalTreeUtil.isJoinQual(block, null, null, eval, true)) {
                notMatched.add(eval);
                continue;
            }
            LinkedHashSet<Column> evalColumns = EvalTreeUtil.findUniqueColumns(eval);
            boolean columnMatched = true;
            for (Column c : evalColumns) {
                Target target = (Target)nodeTargetMap.get(c.getQualifiedName());
                if (target == null) {
                    columnMatched = false;
                    break;
                }
                if (((EvalNode)target.getEvalTree()).getType() == EvalType.FIELD) continue;
                columnMatched = false;
                break;
            }
            if (columnMatched) {
                EvalNode copyEvalNode = this.transformEval(node, childNode, eval, nodeTargetMap, partitionColumns, columnOffset);
                if (copyEvalNode != null) {
                    matched.put((Object)copyEvalNode, (Object)eval);
                    continue;
                }
                notMatched.add(eval);
                continue;
            }
            notMatched.add(eval);
        }
        return matched;
    }

    private EvalNode transformEval(Projectable node, LogicalNode childNode, EvalNode origin, Map<String, Target> targetMap, Set<String> partitionColumns, int columnOffset) throws PlanningException {
        EvalNode copy;
        Schema outputSchema = childNode != null ? childNode.getOutSchema() : node.getInSchema();
        try {
            copy = (EvalNode)origin.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PlanningException(e);
        }
        LinkedHashSet<Column> columns = EvalTreeUtil.findUniqueColumns(copy);
        for (Column c : columns) {
            Target target = targetMap.get(c.getQualifiedName());
            if (target == null) {
                throw new PlanningException("Invalid Filter PushDown: No such a corresponding target '" + c.getQualifiedName() + " for FilterPushDown(" + origin + "), " + "(PID=" + node.getPID() + ")");
            }
            Object targetEvalNode = target.getEvalTree();
            if (((EvalNode)targetEvalNode).getType() != EvalType.FIELD) {
                throw new PlanningException("Invalid Filter PushDown: '" + c.getQualifiedName() + "' target is not FieldEval " + "(PID=" + node.getPID() + ")");
            }
            FieldEval fieldEval = (FieldEval)targetEvalNode;
            Column targetInputColumn = fieldEval.getColumnRef();
            int index = targetInputColumn.hasQualifier() ? node.getInSchema().getColumnId(targetInputColumn.getQualifiedName()) : node.getInSchema().getColumnIdByName(targetInputColumn.getQualifiedName());
            if (columnOffset > 0) {
                index -= columnOffset;
            }
            if (index < 0 || index >= outputSchema.size()) {
                if (partitionColumns != null && !partitionColumns.isEmpty() && node instanceof ScanNode) {
                    ScanNode scanNode = (ScanNode)node;
                    boolean isPartitionColumn = false;
                    isPartitionColumn = CatalogUtil.isFQColumnName((String)partitionColumns.iterator().next()) ? partitionColumns.contains(CatalogUtil.buildFQName((String[])new String[]{scanNode.getTableName(), c.getSimpleName()})) : partitionColumns.contains(c.getSimpleName());
                    if (isPartitionColumn) {
                        EvalTreeUtil.changeColumnRef(copy, c.getQualifiedName(), scanNode.getCanonicalName() + "." + c.getSimpleName());
                        continue;
                    }
                    return null;
                }
                return null;
            }
            Column outputColumn = outputSchema.getColumn(index);
            EvalTreeUtil.changeColumnRef(copy, c.getQualifiedName(), outputColumn.getQualifiedName());
        }
        return copy;
    }

    private List<EvalNode> addHavingNode(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnaryNode parentNode, HavingNode havingNode, GroupbyNode groupByNode) throws PlanningException {
        HavingNode workingHavingNode;
        HashSet<Column> groupingColumns = new HashSet<Column>(Arrays.asList(groupByNode.getGroupingColumns()));
        HashSet<String> aggrFunctionOutColumns = new HashSet<String>();
        for (Column column : groupByNode.getOutSchema().getColumns()) {
            if (groupingColumns.contains(column)) continue;
            aggrFunctionOutColumns.add(column.getQualifiedName());
        }
        ArrayList<EvalNode> aggrEvalOrigins = new ArrayList<EvalNode>();
        ArrayList<EvalNode> aggrEvals = new ArrayList<EvalNode>();
        for (EvalNode eval : context.pushingDownFilters) {
            EvalNode copy = null;
            try {
                copy = (EvalNode)eval.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            boolean isEvalAggrFunction = false;
            for (Column evalColumn : EvalTreeUtil.findUniqueColumns(copy)) {
                if (!aggrFunctionOutColumns.contains(evalColumn.getSimpleName())) continue;
                EvalTreeUtil.changeColumnRef(copy, evalColumn.getQualifiedName(), evalColumn.getSimpleName());
                isEvalAggrFunction = true;
                break;
            }
            if (!isEvalAggrFunction) continue;
            aggrEvals.add(copy);
            aggrEvalOrigins.add(eval);
        }
        if (aggrEvals.isEmpty()) {
            return aggrEvalOrigins;
        }
        if (havingNode != null) {
            workingHavingNode = havingNode;
            aggrEvals.add(havingNode.getQual());
        } else {
            workingHavingNode = plan.createNode(HavingNode.class);
            block.registerNode(workingHavingNode);
            parentNode.setChild(workingHavingNode);
            workingHavingNode.setChild(groupByNode);
        }
        EvalNode qual = null;
        if (aggrEvals.size() > 1) {
            qual = AlgebraicUtil.createSingletonExprFromCNF(aggrEvals.toArray(new EvalNode[aggrEvals.size()]));
        } else if (aggrEvals.size() == 1) {
            qual = (EvalNode)aggrEvals.get(0);
        }
        if (qual != null) {
            workingHavingNode.setQual(qual);
        }
        return aggrEvalOrigins;
    }

    @Override
    public LogicalNode visitWindowAgg(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, WindowAggNode winAggNode, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(winAggNode);
        super.visitWindowAgg(context, plan, block, winAggNode, stack);
        stack.pop();
        return winAggNode;
    }

    @Override
    public LogicalNode visitGroupBy(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, GroupbyNode groupbyNode, Stack<LogicalNode> stack) throws PlanningException {
        LogicalNode parentNode = stack.peek();
        List<EvalNode> aggrEvals = parentNode.getType() == NodeType.HAVING ? this.addHavingNode(context, plan, block, null, (HavingNode)parentNode, groupbyNode) : this.addHavingNode(context, plan, block, (UnaryNode)parentNode, null, groupbyNode);
        if (aggrEvals != null) {
            context.pushingDownFilters.removeAll(aggrEvals);
        }
        ArrayList<EvalNode> notMatched = new ArrayList<EvalNode>();
        BiMap<EvalNode, EvalNode> transformed = this.findCanPushdownAndTransform(context, block, groupbyNode, (LogicalNode)groupbyNode.getChild(), (List<EvalNode>)notMatched, null, false, 0);
        context.setFiltersTobePushed(transformed.keySet());
        LogicalNode current = (LogicalNode)super.visitGroupBy(context, plan, block, groupbyNode, stack);
        context.setToOrigin((Map<EvalNode, EvalNode>)transformed);
        context.addFiltersTobePushed(notMatched);
        return current;
    }

    @Override
    public LogicalNode visitScan(FilterPushDownContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode scanNode, Stack<LogicalNode> stack) throws PlanningException {
        ArrayList matched = Lists.newArrayList();
        HashSet<String> partitionColumns = new HashSet<String>();
        TableDesc table = scanNode.getTableDesc();
        boolean hasQualifiedName = false;
        if (table.hasPartition()) {
            for (Column c : table.getPartitionMethod().getExpressionSchema().getColumns()) {
                partitionColumns.add(c.getQualifiedName());
                hasQualifiedName = c.hasQualifier();
            }
        }
        HashSet<EvalNode> partitionEvals = new HashSet<EvalNode>();
        for (EvalNode eval : context.pushingDownFilters) {
            EvalNode copy;
            LinkedHashSet<Column> columns;
            if (!table.hasPartition() || (columns = EvalTreeUtil.findUniqueColumns(eval)).size() != 1) continue;
            Column column = (Column)columns.iterator().next();
            boolean isPartitionColumn = false;
            isPartitionColumn = hasQualifiedName ? partitionColumns.contains(CatalogUtil.buildFQName((String[])new String[]{table.getName(), column.getSimpleName()})) : partitionColumns.contains(column.getSimpleName());
            if (!isPartitionColumn) continue;
            try {
                copy = (EvalNode)eval.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new PlanningException(e);
            }
            EvalTreeUtil.changeColumnRef(copy, column.getQualifiedName(), scanNode.getCanonicalName() + "." + column.getSimpleName());
            matched.add(copy);
            partitionEvals.add(eval);
        }
        context.pushingDownFilters.removeAll(partitionEvals);
        ArrayList<EvalNode> notMatched = new ArrayList<EvalNode>();
        BiMap<EvalNode, EvalNode> transformed = this.findCanPushdownAndTransform(context, block, scanNode, null, notMatched, partitionColumns, true, 0);
        for (EvalNode eval : transformed.keySet()) {
            if (!LogicalPlanner.checkIfBeEvaluatedAtRelation(block, eval, scanNode)) continue;
            matched.add(eval);
        }
        EvalNode qual = null;
        if (matched.size() > 1) {
            qual = AlgebraicUtil.createSingletonExprFromCNF(matched.toArray(new EvalNode[matched.size()]));
        } else if (matched.size() == 1) {
            qual = (EvalNode)matched.iterator().next();
        }
        if (qual != null) {
            scanNode.setQual(qual);
        }
        for (EvalNode matchedEval : matched) {
            transformed.remove(matchedEval);
        }
        context.setToOrigin((Map<EvalNode, EvalNode>)transformed);
        context.addFiltersTobePushed(notMatched);
        return scanNode;
    }

    private void errorFilterPushDown(LogicalPlan plan, LogicalNode node, FilterPushDownContext context) throws PlanningException {
        String notMatchedNodeStr = "";
        String prefix = "";
        for (EvalNode notMatchedNode : context.pushingDownFilters) {
            notMatchedNodeStr = notMatchedNodeStr + prefix + notMatchedNode;
            prefix = ", ";
        }
        throw new PlanningException("FilterPushDown failed cause some filters not matched: " + notMatchedNodeStr + "\n" + "Error node: " + node.getPlanString() + "\n" + plan.toString());
    }

    static class FilterPushDownContext {
        Set<EvalNode> pushingDownFilters = new HashSet<EvalNode>();

        FilterPushDownContext() {
        }

        public void clear() {
            this.pushingDownFilters.clear();
        }

        public void setFiltersTobePushed(Collection<EvalNode> workingEvals) {
            this.pushingDownFilters.clear();
            this.pushingDownFilters.addAll(workingEvals);
        }

        public void addFiltersTobePushed(Collection<EvalNode> workingEvals) {
            this.pushingDownFilters.addAll(workingEvals);
        }

        public void setToOrigin(Map<EvalNode, EvalNode> evalMap) {
            ArrayList<EvalNode> origins = new ArrayList<EvalNode>();
            for (EvalNode eval : this.pushingDownFilters) {
                EvalNode origin = evalMap.get(eval);
                if (origin == null) continue;
                origins.add(origin);
            }
            this.setFiltersTobePushed(origins);
        }
    }
}

