/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.rewrite;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteEngine;
import org.apache.tajo.plan.rewrite.LogicalPlanRewriteRule;

public class BaseLogicalPlanRewriteEngine
implements LogicalPlanRewriteEngine {
    private Log LOG = LogFactory.getLog(BaseLogicalPlanRewriteEngine.class);
    private Map<String, LogicalPlanRewriteRule> rewriteRules = new LinkedHashMap<String, LogicalPlanRewriteRule>();

    public void addRewriteRule(Iterable<Class<? extends LogicalPlanRewriteRule>> rules) {
        for (Class<? extends LogicalPlanRewriteRule> clazz : rules) {
            try {
                LogicalPlanRewriteRule rule = clazz.newInstance();
                this.addRewriteRule(rule);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public void addRewriteRule(LogicalPlanRewriteRule rule) {
        if (!this.rewriteRules.containsKey(rule.getName())) {
            this.rewriteRules.put(rule.getName(), rule);
        }
    }

    @Override
    public LogicalPlan rewrite(OverridableConf queryContext, LogicalPlan plan) throws PlanningException {
        for (Map.Entry<String, LogicalPlanRewriteRule> rewriteRule : this.rewriteRules.entrySet()) {
            LogicalPlanRewriteRule rule = rewriteRule.getValue();
            if (!rule.isEligible(queryContext, plan)) continue;
            plan = rule.rewrite(queryContext, plan);
            if (!this.LOG.isDebugEnabled()) continue;
            this.LOG.debug((Object)("The rule \"" + rule.getName() + " \" rewrites the query."));
        }
        return plan;
    }
}

