/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.nameresolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.exception.NoSuchColumnException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.algebra.AmbiguousFieldException;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.plan.nameresolver.ResolverByLegacy;
import org.apache.tajo.plan.nameresolver.ResolverByRels;
import org.apache.tajo.plan.nameresolver.ResolverByRelsAndSubExprs;
import org.apache.tajo.plan.nameresolver.ResolverBySubExprsAndRels;
import org.apache.tajo.plan.verifier.VerifyException;
import org.apache.tajo.util.Pair;
import org.apache.tajo.util.TUtil;

public abstract class NameResolver {
    public static Map<NameResolvingMode, NameResolver> resolverMap = Maps.newHashMap();

    abstract Column resolve(LogicalPlan var1, LogicalPlan.QueryBlock var2, ColumnReferenceExpr var3) throws PlanningException;

    public static String resolveDatabase(LogicalPlan.QueryBlock block, String tableName) throws PlanningException {
        ArrayList<String> found = new ArrayList<String>();
        for (RelationNode relation : block.getRelations()) {
            if (!CatalogUtil.extractSimpleName((String)relation.getCanonicalName()).equals(tableName) && !CatalogUtil.extractSimpleName((String)relation.getTableName()).equals(tableName)) continue;
            found.add(CatalogUtil.extractQualifier((String)relation.getTableName()));
        }
        if (found.size() == 0) {
            return null;
        }
        if (found.size() > 1) {
            throw new PlanningException("Ambiguous table name \"" + tableName + "\"");
        }
        return (String)found.get(0);
    }

    public static Column resolve(LogicalPlan plan, LogicalPlan.QueryBlock block, ColumnReferenceExpr column, NameResolvingMode mode) throws PlanningException {
        if (!resolverMap.containsKey((Object)mode)) {
            throw new PlanningException("Unsupported name resolving level: " + mode.name());
        }
        return resolverMap.get((Object)mode).resolve(plan, block, column);
    }

    static Column resolveFromRelsWithinBlock(LogicalPlan plan, LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws PlanningException {
        if (columnRef.hasQualifier()) {
            Pair<String, String> normalized = NameResolver.normalizeQualifierAndCanonicalName(block, columnRef);
            String qualifier = (String)normalized.getFirst();
            String canonicalName = (String)normalized.getSecond();
            RelationNode relationOp = block.getRelation(qualifier);
            if (relationOp == null) {
                throw null;
            }
            if (block.isAlreadyRenamedTableName(CatalogUtil.extractQualifier((String)canonicalName))) {
                canonicalName = CatalogUtil.buildFQName((String[])new String[]{relationOp.getCanonicalName(), CatalogUtil.extractSimpleName((String)canonicalName)});
            }
            Schema schema = relationOp.getLogicalSchema();
            Column column = schema.getColumn(canonicalName);
            return column;
        }
        return NameResolver.resolveFromAllRelsInBlock(block, columnRef);
    }

    static Column resolveFromCurrentAndChildNode(LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws NoSuchColumnException {
        if (block.getCurrentNode() != null && ((LogicalNode)block.getCurrentNode()).getInSchema() != null) {
            Column found = ((LogicalNode)block.getCurrentNode()).getInSchema().getColumn(columnRef.getCanonicalName());
            if (found != null) {
                return found;
            }
            if (block.getLatestNode() != null && (found = ((LogicalNode)block.getLatestNode()).getOutSchema().getColumn(columnRef.getName())) != null) {
                return found;
            }
        }
        return null;
    }

    static Column resolveFromAllRelsInBlock(LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws VerifyException {
        List candidates = TUtil.newList();
        for (RelationNode rel : block.getRelations()) {
            Column found = rel.getLogicalSchema().getColumn(columnRef.getName());
            if (found == null) continue;
            candidates.add(found);
        }
        if (!candidates.isEmpty()) {
            return NameResolver.ensureUniqueColumn(candidates);
        }
        return null;
    }

    static Column resolveFromAllRelsInAllBlocks(LogicalPlan plan, ColumnReferenceExpr columnRef) throws VerifyException {
        ArrayList candidates = Lists.newArrayList();
        for (LogicalPlan.QueryBlock eachBlock : plan.getQueryBlocks()) {
            for (RelationNode rel : eachBlock.getRelations()) {
                Column found = rel.getLogicalSchema().getColumn(columnRef.getName());
                if (found == null) continue;
                candidates.add(found);
            }
        }
        if (!candidates.isEmpty()) {
            return NameResolver.ensureUniqueColumn(candidates);
        }
        return null;
    }

    static Column resolveAliasedName(LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws VerifyException {
        Column found;
        ArrayList candidates = Lists.newArrayList();
        if (block.getSchema() != null && (found = block.getSchema().getColumn(columnRef.getName())) != null) {
            candidates.add(found);
        }
        if (!candidates.isEmpty()) {
            return NameResolver.ensureUniqueColumn(candidates);
        }
        return null;
    }

    static Pair<String, String> normalizeQualifierAndCanonicalName(LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws PlanningException {
        String canonicalName;
        String qualifier;
        if (CatalogUtil.isFQTableName((String)columnRef.getQualifier())) {
            qualifier = columnRef.getQualifier();
            canonicalName = columnRef.getCanonicalName();
        } else {
            String resolvedDatabaseName = NameResolver.resolveDatabase(block, columnRef.getQualifier());
            if (resolvedDatabaseName == null) {
                throw new NoSuchColumnException(columnRef.getQualifier());
            }
            qualifier = CatalogUtil.buildFQName((String[])new String[]{resolvedDatabaseName, columnRef.getQualifier()});
            canonicalName = CatalogUtil.buildFQName((String[])new String[]{qualifier, columnRef.getName()});
        }
        return new Pair((Object)qualifier, (Object)canonicalName);
    }

    static Column ensureUniqueColumn(List<Column> candidates) throws VerifyException {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (candidates.size() > 2) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Column column : candidates) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(column);
            }
            throw new AmbiguousFieldException("Ambiguous Column Name: " + sb.toString());
        }
        return null;
    }

    static {
        resolverMap.put(NameResolvingMode.RELS_ONLY, new ResolverByRels());
        resolverMap.put(NameResolvingMode.RELS_AND_SUBEXPRS, new ResolverByRelsAndSubExprs());
        resolverMap.put(NameResolvingMode.SUBEXPRS_AND_RELS, new ResolverBySubExprsAndRels());
        resolverMap.put(NameResolvingMode.LEGACY, new ResolverByLegacy());
    }
}

