/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.util.TUtil;

public class WindowSpec {
    @Expose
    private String windowName;
    @Expose
    private Column[] partitionKeys;
    @Expose
    private WindowFrame windowFrame;

    public String getWindowName() {
        return this.windowName;
    }

    public boolean hasPartitionKeys() {
        return this.partitionKeys != null;
    }

    public Column[] getPartitionKeys() {
        return this.partitionKeys;
    }

    public boolean hasWindowFrame() {
        return this.windowFrame != null;
    }

    public WindowFrame getWindowFrame() {
        return this.windowFrame;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WindowSpec) {
            WindowSpec another = (WindowSpec)obj;
            return TUtil.checkEquals((Object)this.windowName, (Object)another.windowName) && TUtil.checkEquals((Object[])this.partitionKeys, (Object[])another.partitionKeys) && TUtil.checkEquals((Object)this.windowFrame, (Object)another.windowFrame);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.windowName, this.partitionKeys, this.windowFrame});
    }

    public static class WindowEndBound
    implements Cloneable {
        @Expose
        private WindowSpec.WindowFrameEndBoundType boundType;
        @Expose
        private EvalNode number;

        public WindowEndBound(WindowSpec.WindowFrameEndBoundType type) {
            this.boundType = type;
        }

        public WindowSpec.WindowFrameEndBoundType getBoundType() {
            return this.boundType;
        }

        public EvalNode setNumber(EvalNode number) {
            return number;
        }

        public EvalNode getNumber() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WindowEndBound) {
                WindowEndBound other = (WindowEndBound)obj;
                boolean eq = this.boundType == other.boundType;
                return eq &= TUtil.checkEquals((Object)this.number, (Object)other.number);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.boundType, this.number});
        }

        public WindowEndBound clone() throws CloneNotSupportedException {
            WindowEndBound newEndBound = (WindowEndBound)super.clone();
            newEndBound.boundType = this.boundType;
            if (this.number != null) {
                newEndBound.number = (EvalNode)this.number.clone();
            }
            return newEndBound;
        }
    }

    public static class WindowStartBound
    implements Cloneable {
        @Expose
        private WindowSpec.WindowFrameStartBoundType boundType;
        @Expose
        private EvalNode number;

        public WindowStartBound(WindowSpec.WindowFrameStartBoundType type) {
            this.boundType = type;
        }

        public WindowSpec.WindowFrameStartBoundType getBoundType() {
            return this.boundType;
        }

        public void setNumber(EvalNode number) {
            this.number = number;
        }

        public EvalNode getNumber() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WindowStartBound) {
                WindowStartBound other = (WindowStartBound)obj;
                boolean eq = this.boundType == other.boundType;
                return eq &= TUtil.checkEquals((Object)this.number, (Object)other.number);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.boundType, this.number});
        }

        public WindowStartBound clone() throws CloneNotSupportedException {
            WindowStartBound newStartBound = (WindowStartBound)super.clone();
            newStartBound.boundType = this.boundType;
            if (this.number != null) {
                newStartBound.number = (EvalNode)this.number.clone();
            }
            return newStartBound;
        }
    }

    public static class WindowFrame
    implements Cloneable {
        @Expose
        private WindowStartBound startBound;
        @Expose
        private WindowEndBound endBound;
        @Expose
        WindowSpec.WindowFrameUnit unit;

        public WindowFrame() {
            this.startBound = new WindowStartBound(WindowSpec.WindowFrameStartBoundType.UNBOUNDED_PRECEDING);
            this.endBound = new WindowEndBound(WindowSpec.WindowFrameEndBoundType.UNBOUNDED_FOLLOWING);
        }

        public WindowFrame(WindowStartBound startBound, WindowEndBound endBound) {
            this.startBound = startBound;
            this.endBound = endBound;
        }

        public WindowStartBound getStartBound() {
            return this.startBound;
        }

        public boolean hasEndBound() {
            return this.endBound != null;
        }

        public WindowEndBound getEndBound() {
            return this.endBound;
        }

        public boolean hasFrameUnit() {
            return this.unit != null;
        }

        public void setFrameUnit(WindowSpec.WindowFrameUnit unit) {
            this.unit = unit;
        }

        public WindowSpec.WindowFrameUnit getFrameUnit() {
            return this.unit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WindowFrame) {
                WindowFrame another = (WindowFrame)obj;
                boolean eq = TUtil.checkEquals((Object)this.startBound, (Object)another.startBound);
                eq &= TUtil.checkEquals((Object)this.endBound, (Object)another.endBound);
                return eq &= TUtil.checkEquals((Object)this.unit, (Object)another.unit);
            }
            return false;
        }

        public WindowFrame clone() throws CloneNotSupportedException {
            WindowFrame newFrame = (WindowFrame)super.clone();
            newFrame.startBound = this.startBound.clone();
            newFrame.endBound = this.endBound.clone();
            newFrame.unit = this.unit;
            return newFrame;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.startBound, this.endBound, this.unit});
        }
    }
}

