/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class WindowAggNode
extends UnaryNode
implements Projectable,
Cloneable {
    @Expose
    private Column[] partitionKeys;
    @Expose
    private SortSpec[] sortSpecs;
    @Expose
    private WindowFunctionEval[] windowFuncs;
    @Expose
    private Target[] targets;
    @Expose
    private boolean hasDistinct = false;

    public WindowAggNode(int pid) {
        super(pid, NodeType.WINDOW_AGG);
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && this.partitionKeys.length > 0;
    }

    public void setPartitionKeys(Column[] groupingColumns) {
        this.partitionKeys = groupingColumns;
    }

    public final Column[] getPartitionKeys() {
        return this.partitionKeys;
    }

    public final boolean hasSortSpecs() {
        return this.sortSpecs != null;
    }

    public void setSortSpecs(SortSpec[] sortSpecs) {
        this.sortSpecs = sortSpecs;
    }

    public final SortSpec[] getSortSpecs() {
        return this.sortSpecs;
    }

    public final boolean isDistinct() {
        return this.hasDistinct;
    }

    public void setDistinct(boolean distinct) {
        this.hasDistinct = distinct;
    }

    public boolean hasAggFunctions() {
        return this.windowFuncs != null;
    }

    public WindowFunctionEval[] getWindowFunctions() {
        return this.windowFuncs;
    }

    public void setWindowFunctions(WindowFunctionEval[] evals) {
        this.windowFuncs = evals;
    }

    @Override
    public boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public Target[] getTargets() {
        return this.targets;
    }

    @Override
    public void setChild(LogicalNode subNode) {
        super.setChild(subNode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WinAgg (");
        if (this.hasPartitionKeys()) {
            sb.append("partition keys=").append(TUtil.arrayToString((Object[])this.partitionKeys));
            sb.append(", ");
        }
        if (this.hasAggFunctions()) {
            sb.append("funcs=").append(TUtil.arrayToString((Object[])this.windowFuncs));
        }
        if (this.hasSortSpecs()) {
            sb.append("sort=").append(TUtil.arrayToString((Object[])this.sortSpecs));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WindowAggNode) {
            WindowAggNode other = (WindowAggNode)obj;
            boolean eq = super.equals(other);
            eq = eq && TUtil.checkEquals((Object[])this.partitionKeys, (Object[])other.partitionKeys);
            eq = eq && TUtil.checkEquals((Object[])this.sortSpecs, (Object[])other.sortSpecs);
            eq = eq && TUtil.checkEquals((Object[])this.windowFuncs, (Object[])other.windowFuncs);
            eq = eq && TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            eq = eq && TUtil.checkEquals((Object)this.hasDistinct, (Object)other.hasDistinct);
            return eq;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitionKeys, this.sortSpecs, this.windowFuncs, this.targets, this.hasDistinct});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        WindowAggNode grp = (WindowAggNode)super.clone();
        if (this.partitionKeys != null) {
            grp.partitionKeys = new Column[this.partitionKeys.length];
            for (i = 0; i < this.partitionKeys.length; ++i) {
                grp.partitionKeys[i] = this.partitionKeys[i];
            }
        }
        if (this.windowFuncs != null) {
            grp.windowFuncs = new WindowFunctionEval[this.windowFuncs.length];
            for (i = 0; i < this.windowFuncs.length; ++i) {
                grp.windowFuncs[i] = (WindowFunctionEval)this.windowFuncs[i].clone();
            }
        }
        if (this.targets != null) {
            grp.targets = new Target[this.targets.length];
            for (i = 0; i < this.targets.length; ++i) {
                grp.targets[i] = (Target)this.targets[i].clone();
            }
        }
        return grp;
    }

    @Override
    public PlanString getPlanString() {
        int i;
        int j;
        PlanString planStr = new PlanString(this);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.hasPartitionKeys()) {
            sb.append("PARTITION BY ");
            for (j = 0; j < this.partitionKeys.length; ++j) {
                sb.append(this.partitionKeys[j].getSimpleName());
                if (j >= this.partitionKeys.length - 1) continue;
                sb.append(",");
            }
        }
        if (this.hasSortSpecs()) {
            sb.append("ORDER BY ");
            for (i = 0; i < this.sortSpecs.length; ++i) {
                sb.append(this.sortSpecs[i].getSortKey().getSimpleName()).append(" ").append(this.sortSpecs[i].isAscending() ? "asc" : "desc");
                if (i >= this.sortSpecs.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(")");
        planStr.appendTitle(sb.toString());
        if (this.hasAggFunctions()) {
            sb = new StringBuilder();
            sb.append("(");
            for (j = 0; j < this.windowFuncs.length; ++j) {
                sb.append(this.windowFuncs[j]);
                if (j >= this.windowFuncs.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            planStr.appendExplain("exprs: ").appendExplain(sb.toString());
        }
        sb = new StringBuilder("target list: ");
        for (i = 0; i < this.targets.length; ++i) {
            sb.append(this.targets[i]);
            if (i >= this.targets.length - 1) continue;
            sb.append(", ");
        }
        planStr.addExplan(sb.toString());
        planStr.addDetail("out schema:").appendDetail(this.getOutSchema().toString());
        planStr.addDetail("in schema:").appendDetail(this.getInSchema().toString());
        return planStr;
    }
}

