/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.util.TUtil;

public abstract class UnaryNode
extends LogicalNode
implements Cloneable {
    @Expose
    LogicalNode child;

    public UnaryNode(int pid, NodeType type) {
        super(pid, type);
    }

    @Override
    public int childNum() {
        return 1;
    }

    @Override
    public LogicalNode getChild(int idx) {
        if (idx == 0) {
            return this.child;
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public void setChild(LogicalNode subNode) {
        this.child = subNode;
    }

    public <T extends LogicalNode> T getChild() {
        return (T)this.child;
    }

    @Override
    public boolean deepEquals(Object o) {
        if (o instanceof UnaryNode) {
            UnaryNode u = (UnaryNode)o;
            return this.equals(o) && TUtil.checkEquals((Object)this.child, (Object)u.child);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UnaryNode unary = (UnaryNode)super.clone();
        unary.child = (LogicalNode)(this.child == null ? null : this.child.clone());
        return unary;
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
        this.child.preOrder(visitor);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        this.child.postOrder(visitor);
        visitor.visit(this);
    }
}

