/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.partition.PartitionMethodDesc;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.PersistentStoreNode;
import org.apache.tajo.util.TUtil;

public class StoreTableNode
extends PersistentStoreNode
implements Cloneable {
    @Expose
    protected String tableName;
    @Expose
    private PartitionMethodDesc partitionDesc;

    public StoreTableNode(int pid) {
        super(pid, NodeType.STORE);
    }

    protected StoreTableNode(int pid, NodeType nodeType) {
        super(pid, nodeType);
    }

    public boolean hasTargetTable() {
        return this.tableName != null;
    }

    public boolean hasTableName() {
        return this.tableName != null;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public boolean hasPartition() {
        return this.partitionDesc != null;
    }

    public PartitionMethodDesc getPartitionMethod() {
        return this.partitionDesc;
    }

    public void setPartitionMethod(PartitionMethodDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        planStr.appendTitle(" into ").appendTitle(this.tableName);
        planStr.addExplan("Store type: " + this.storageType);
        return planStr;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StoreTableNode) {
            StoreTableNode other = (StoreTableNode)obj;
            boolean eq = super.equals(other);
            eq = eq && TUtil.checkEquals((Object)this.tableName, (Object)other.tableName);
            eq = eq && TUtil.checkEquals((Object)this.partitionDesc, (Object)other.partitionDesc);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StoreTableNode store = (StoreTableNode)super.clone();
        store.tableName = this.tableName;
        store.partitionDesc = this.partitionDesc != null ? (PartitionMethodDesc)this.partitionDesc.clone() : null;
        return store;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Store Table (table=").append(this.tableName);
        if (this.storageType != null) {
            sb.append(", storage=" + this.storageType.name());
        }
        sb.append(")");
        return sb.toString();
    }
}

