/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.util.TUtil;

public final class SortNode
extends UnaryNode
implements Cloneable {
    @Expose
    private SortSpec[] sortKeys;
    @Expose
    private SortPurpose sortPurpose = SortPurpose.NORMAL;

    public SortNode(int pid) {
        super(pid, NodeType.SORT);
    }

    public void setSortSpecs(SortSpec[] sortSpecs) {
        Preconditions.checkArgument((sortSpecs.length > 0 ? 1 : 0) != 0, (Object)"At least one sort key must be specified");
        this.sortKeys = sortSpecs;
    }

    public SortSpec[] getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SortNode) {
            SortNode other = (SortNode)obj;
            boolean eq = super.equals(other);
            eq = eq && TUtil.checkEquals((Object[])this.sortKeys, (Object[])other.sortKeys);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SortNode sort = (SortNode)super.clone();
        sort.sortKeys = (SortSpec[])this.sortKeys.clone();
        return sort;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        StringBuilder sb = new StringBuilder("Sort Keys: ");
        for (int i = 0; i < this.sortKeys.length; ++i) {
            sb.append(this.sortKeys[i].toString());
            if (i >= this.sortKeys.length - 1) continue;
            sb.append(",");
        }
        planStr.addExplan(sb.toString());
        return planStr;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Sort [key= ");
        for (int i = 0; i < this.sortKeys.length; ++i) {
            sb.append(this.sortKeys[i].toString());
            if (i >= this.sortKeys.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        sb.append("\n\"out schema: " + this.getOutSchema() + "\n\"in schema: " + this.getInSchema());
        return sb.toString() + "\n" + ((LogicalNode)this.getChild()).toString();
    }

    public SortPurpose getSortPurpose() {
        return this.sortPurpose;
    }

    public void setSortPurpose(SortPurpose sortPurpose) {
        this.sortPurpose = sortPurpose;
    }

    public static enum SortPurpose {
        NORMAL,
        STORAGE_SPECIFIED;

    }
}

