/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.PersistentStoreNode;
import org.apache.tajo.plan.serder.PlanProto;
import org.apache.tajo.util.TUtil;

public class ShuffleFileWriteNode
extends PersistentStoreNode
implements Cloneable {
    @Expose
    private PlanProto.ShuffleType shuffleType = PlanProto.ShuffleType.NONE_SHUFFLE;
    @Expose
    private int numOutputs;
    @Expose
    private Column[] shuffleKeys;

    public ShuffleFileWriteNode(int pid) {
        super(pid, NodeType.STORE);
    }

    public final int getNumOutputs() {
        return this.numOutputs;
    }

    public final boolean hasShuffleKeys() {
        return this.shuffleKeys != null;
    }

    public final Column[] getShuffleKeys() {
        return this.shuffleKeys;
    }

    public final void setShuffle(PlanProto.ShuffleType type, Column[] keys, int numPartitions) {
        Preconditions.checkArgument((keys.length >= 0 ? 1 : 0) != 0, (Object)"At least one partition key must be specified.");
        Preconditions.checkArgument((numPartitions >= 0 ? 1 : 0) != 0, (String)"The number of partitions must be positive: %s", (Object[])new Object[]{numPartitions});
        this.shuffleType = type;
        this.shuffleKeys = keys;
        this.numOutputs = numPartitions;
    }

    public PlanProto.ShuffleType getShuffleType() {
        return this.shuffleType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ShuffleFileWriteNode) {
            ShuffleFileWriteNode other = (ShuffleFileWriteNode)obj;
            boolean eq = super.equals(other);
            eq = eq && this.numOutputs == other.numOutputs;
            eq = eq && TUtil.checkEquals((Object[])this.shuffleKeys, (Object[])other.shuffleKeys);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ShuffleFileWriteNode store = (ShuffleFileWriteNode)super.clone();
        store.numOutputs = this.numOutputs;
        store.shuffleKeys = this.shuffleKeys != null ? (Column[])this.shuffleKeys.clone() : null;
        return store;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Shuffle Write (type=" + this.shuffleType.name().toLowerCase());
        if (this.storageType != null) {
            sb.append(", storage=" + this.storageType.name());
        }
        sb.append(", part number=").append(this.numOutputs);
        if (this.shuffleKeys != null) {
            sb.append(", keys: ").append(TUtil.arrayToString((Object[])this.shuffleKeys));
        }
        sb.append(")");
        return sb.toString();
    }
}

