/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;

public class SetSessionNode
extends LogicalNode {
    @Expose
    private String name;
    @Expose
    private String value;

    public SetSessionNode(int pid) {
        super(pid, NodeType.SET_SESSION);
    }

    public void init(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public LogicalNode getChild(int idx) {
        throw new UnsupportedException();
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public PlanString getPlanString() {
        PlanString planString = new PlanString("SET SESSION ");
        planString.appendTitle(this.name).appendTitle("=");
        if (this.value != null) {
            planString.appendTitle(String.valueOf(this.value));
        }
        return planString;
    }
}

