/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.SelectableNode;
import org.apache.tajo.plan.logical.UnaryNode;

public class SelectionNode
extends UnaryNode
implements SelectableNode,
Cloneable {
    @Expose
    private EvalNode qual;

    public SelectionNode(int pid) {
        super(pid, NodeType.SELECTION);
    }

    @Override
    public boolean hasQual() {
        return true;
    }

    @Override
    public void setQual(EvalNode qual) {
        this.qual = qual;
    }

    @Override
    public EvalNode getQual() {
        return this.qual;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        planStr.addExplan("Search Cond: " + this.getQual());
        return planStr;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SelectionNode) {
            SelectionNode other = (SelectionNode)obj;
            return super.equals(other) && this.qual.equals(other.qual);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SelectionNode selNode = (SelectionNode)super.clone();
        selNode.qual = (EvalNode)this.qual.clone();
        return selNode;
    }

    @Override
    public String toString() {
        return "Selection (filter=" + this.qual + ")";
    }
}

