/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.SelectableNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class ScanNode
extends RelationNode
implements Projectable,
SelectableNode,
Cloneable {
    @Expose
    protected TableDesc tableDesc;
    @Expose
    protected String alias;
    @Expose
    protected Schema logicalSchema;
    @Expose
    protected EvalNode qual;
    @Expose
    protected Target[] targets;
    @Expose
    protected boolean broadcastTable;

    protected ScanNode(int pid, NodeType nodeType) {
        super(pid, nodeType);
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public LogicalNode getChild(int idx) {
        return null;
    }

    public ScanNode(int pid) {
        super(pid, NodeType.SCAN);
    }

    public void init(TableDesc desc) {
        this.tableDesc = desc;
        this.setInSchema(this.tableDesc.getSchema());
        this.setOutSchema(this.tableDesc.getSchema());
        this.logicalSchema = SchemaUtil.getQualifiedLogicalSchema((TableDesc)this.tableDesc, null);
    }

    public void init(TableDesc desc, String alias) {
        this.tableDesc = desc;
        this.alias = alias;
        if (!CatalogUtil.isFQTableName((String)this.tableDesc.getName())) {
            throw new IllegalArgumentException("the name in TableDesc must be qualified, but it is \"" + desc.getName() + "\"");
        }
        String databaseName = CatalogUtil.extractQualifier((String)this.tableDesc.getName());
        String qualifiedAlias = CatalogUtil.buildFQName((String[])new String[]{databaseName, alias});
        this.setInSchema(this.tableDesc.getSchema());
        this.getInSchema().setQualifier(qualifiedAlias);
        this.setOutSchema(new Schema(this.getInSchema()));
        this.logicalSchema = SchemaUtil.getQualifiedLogicalSchema((TableDesc)this.tableDesc, (String)qualifiedAlias);
    }

    @Override
    public String getTableName() {
        return this.tableDesc.getName();
    }

    @Override
    public boolean hasAlias() {
        return this.alias != null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setBroadcastTable(boolean broadcastTable) {
        this.broadcastTable = broadcastTable;
    }

    public boolean isBroadcastTable() {
        return this.broadcastTable;
    }

    @Override
    public String getCanonicalName() {
        if (CatalogUtil.isFQTableName((String)this.tableDesc.getName())) {
            String databaseName = CatalogUtil.extractQualifier((String)this.tableDesc.getName());
            return this.hasAlias() ? CatalogUtil.buildFQName((String[])new String[]{databaseName, this.alias}) : this.tableDesc.getName();
        }
        return this.hasAlias() ? this.alias : this.tableDesc.getName();
    }

    @Override
    public Schema getLogicalSchema() {
        return this.logicalSchema;
    }

    public Schema getPhysicalSchema() {
        return this.getInSchema();
    }

    @Override
    public boolean hasQual() {
        return this.qual != null;
    }

    @Override
    public EvalNode getQual() {
        return this.qual;
    }

    @Override
    public void setQual(EvalNode evalTree) {
        this.qual = evalTree;
    }

    @Override
    public boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public Target[] getTargets() {
        return this.targets;
    }

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Scan (table=").append(this.getTableName());
        if (this.hasAlias()) {
            sb.append(", alias=").append(this.alias);
        }
        if (this.hasQual()) {
            sb.append(", filter=").append(this.qual);
        }
        sb.append(", path=").append(this.getTableDesc().getPath()).append(")");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableDesc, this.qual, this.targets});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ScanNode) {
            ScanNode other = (ScanNode)obj;
            boolean eq = super.equals(other);
            eq = eq && TUtil.checkEquals((Object)this.tableDesc, (Object)other.tableDesc);
            eq = eq && TUtil.checkEquals((Object)this.qual, (Object)other.qual);
            eq = eq && TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ScanNode scanNode = (ScanNode)super.clone();
        scanNode.tableDesc = (TableDesc)this.tableDesc.clone();
        if (this.hasQual()) {
            scanNode.qual = (EvalNode)this.qual.clone();
        }
        if (this.hasTargets()) {
            scanNode.targets = new Target[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                scanNode.targets[i] = (Target)this.targets[i].clone();
            }
        }
        if (this.hasAlias()) {
            scanNode.alias = this.alias;
        }
        return scanNode;
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this).appendTitle(" on ").appendTitle(this.getTableName());
        if (this.hasAlias()) {
            planStr.appendTitle(" as ").appendTitle(this.alias);
        }
        if (this.hasQual()) {
            planStr.addExplan("filter: ").appendExplain(this.qual.toString());
        }
        if (this.hasTargets()) {
            planStr.addExplan("target list: ");
            boolean first = true;
            for (Target target : this.targets) {
                if (!first) {
                    planStr.appendExplain(", ");
                }
                planStr.appendExplain(target.toString());
                first = false;
            }
        }
        planStr.addDetail("out schema: ").appendDetail(this.getOutSchema().toString());
        planStr.addDetail("in schema: ").appendDetail(this.getInSchema().toString());
        return planStr;
    }

    public static boolean isScanNode(LogicalNode node) {
        return node.getType() == NodeType.SCAN || node.getType() == NodeType.PARTITIONS_SCAN;
    }
}

