/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class ProjectionNode
extends UnaryNode
implements Projectable {
    @Expose
    private boolean distinct = false;
    @Expose
    private Target[] targets;

    public ProjectionNode(int pid) {
        super(pid, NodeType.PROJECTION);
    }

    public void init(boolean distinct, Target[] targets) {
        this.distinct = distinct;
        this.targets = targets;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public Target[] getTargets() {
        return this.targets;
    }

    @Override
    public void setChild(LogicalNode subNode) {
        super.setChild(subNode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Projection (distinct=").append(this.distinct);
        if (this.targets != null) {
            sb.append(", exprs=").append(TUtil.arrayToString((Object[])this.targets)).append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProjectionNode) {
            ProjectionNode other = (ProjectionNode)obj;
            boolean b1 = super.equals(other);
            boolean b2 = TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            return b1 && b2;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ProjectionNode projNode = (ProjectionNode)super.clone();
        projNode.targets = (Target[])this.targets.clone();
        return projNode;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        if (this.distinct) {
            planStr.appendTitle(" (distinct)");
        }
        StringBuilder sb = new StringBuilder("Targets: ");
        if (this.targets != null) {
            for (int i = 0; i < this.targets.length; ++i) {
                sb.append(this.targets[i]);
                if (i >= this.targets.length - 1) continue;
                sb.append(", ");
            }
        }
        planStr.addExplan(sb.toString());
        if (this.getOutSchema() != null) {
            planStr.addExplan("out schema: " + this.getOutSchema().toString());
        }
        if (this.getInSchema() != null) {
            planStr.addExplan("in  schema: " + this.getInSchema().toString());
        }
        return planStr;
    }
}

