/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.TUtil;

public abstract class PersistentStoreNode
extends UnaryNode
implements Cloneable {
    @Expose
    protected CatalogProtos.StoreType storageType = CatalogProtos.StoreType.CSV;
    @Expose
    protected KeyValueSet options = new KeyValueSet();

    protected PersistentStoreNode(int pid, NodeType nodeType) {
        super(pid, nodeType);
    }

    public void setStorageType(CatalogProtos.StoreType storageType) {
        this.storageType = storageType;
    }

    public CatalogProtos.StoreType getStorageType() {
        return this.storageType;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public KeyValueSet getOptions() {
        return this.options;
    }

    public void setOptions(KeyValueSet options) {
        this.options = options;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        planStr.addExplan("Store type: " + this.storageType);
        return planStr;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PersistentStoreNode) {
            PersistentStoreNode other = (PersistentStoreNode)obj;
            boolean eq = super.equals(other);
            eq = eq && this.storageType.equals((Object)other.storageType);
            eq = eq && TUtil.checkEquals((Object)this.options, (Object)other.options);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PersistentStoreNode store = (PersistentStoreNode)super.clone();
        store.storageType = this.storageType != null ? this.storageType : null;
        store.options = this.options != null ? (KeyValueSet)this.options.clone() : null;
        return store;
    }
}

