/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.util.TUtil;

public class PartitionedTableScanNode
extends ScanNode {
    @Expose
    Path[] inputPaths;

    public PartitionedTableScanNode(int pid) {
        super(pid, NodeType.PARTITIONS_SCAN);
    }

    public void init(ScanNode scanNode, Path[] inputPaths) {
        this.tableDesc = scanNode.tableDesc;
        this.setInSchema(scanNode.getInSchema());
        this.setOutSchema(scanNode.getOutSchema());
        this.qual = scanNode.qual;
        this.targets = scanNode.targets;
        this.inputPaths = inputPaths;
        if (scanNode.hasAlias()) {
            this.alias = scanNode.alias;
        }
    }

    public void setInputPaths(Path[] paths) {
        this.inputPaths = paths;
    }

    public Path[] getInputPaths() {
        return this.inputPaths;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Partitions Scan (table=").append(this.getTableName());
        if (this.hasAlias()) {
            sb.append(", alias=").append(this.alias);
        }
        if (this.hasQual()) {
            sb.append(", filter=").append(this.qual);
        }
        sb.append(", path=").append(this.getTableDesc().getPath()).append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableDesc, this.qual, this.targets});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PartitionedTableScanNode) {
            PartitionedTableScanNode other = (PartitionedTableScanNode)obj;
            boolean eq = super.equals(other);
            eq = eq && TUtil.checkEquals((Object)this.tableDesc, (Object)other.tableDesc);
            eq = eq && TUtil.checkEquals((Object)this.qual, (Object)other.qual);
            eq = eq && TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            eq = eq && TUtil.checkEquals((Object[])this.inputPaths, (Object[])other.inputPaths);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PartitionedTableScanNode unionScan = (PartitionedTableScanNode)super.clone();
        unionScan.tableDesc = (TableDesc)this.tableDesc.clone();
        if (this.hasQual()) {
            unionScan.qual = (EvalNode)this.qual.clone();
        }
        if (this.hasTargets()) {
            unionScan.targets = new Target[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                unionScan.targets[i] = (Target)this.targets[i].clone();
            }
        }
        unionScan.inputPaths = this.inputPaths;
        return unionScan;
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this).appendTitle(" on " + this.getTableName());
        if (this.hasAlias()) {
            planStr.appendTitle(" as ").appendTitle(this.alias);
        }
        if (this.hasQual()) {
            planStr.addExplan("filter: ").appendExplain(this.qual.toString());
        }
        if (this.hasTargets()) {
            planStr.addExplan("target list: ");
            boolean first = true;
            for (Target target : this.targets) {
                if (!first) {
                    planStr.appendExplain(", ");
                }
                planStr.appendExplain(target.toString());
                first = false;
            }
        }
        planStr.addDetail("out schema: ").appendDetail(this.getOutSchema().toString());
        planStr.addDetail("in schema: ").appendDetail(this.getInSchema().toString());
        if (this.inputPaths != null) {
            planStr.addExplan("num of filtered paths: ").appendExplain("" + this.inputPaths.length);
            int i = 0;
            for (Target target : this.inputPaths) {
                planStr.addDetail(i++ + ": ").appendDetail(target.toString());
            }
        }
        return planStr;
    }
}

