/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class GroupbyNode
extends UnaryNode
implements Projectable,
Cloneable {
    @Expose
    private Column[] groupingKeys = PlannerUtil.EMPTY_COLUMNS;
    @Expose
    private AggregationFunctionCallEval[] aggrFunctions = PlannerUtil.EMPTY_AGG_FUNCS;
    @Expose
    private Target[] targets;
    @Expose
    private boolean hasDistinct = false;

    public GroupbyNode(int pid) {
        super(pid, NodeType.GROUP_BY);
    }

    public int groupingKeyNum() {
        return this.groupingKeys.length;
    }

    public final boolean isEmptyGrouping() {
        return this.groupingKeys.length == 0;
    }

    public void setGroupingColumns(Column[] groupingKeys) {
        this.groupingKeys = groupingKeys;
    }

    public final Column[] getGroupingColumns() {
        return this.groupingKeys;
    }

    public final boolean isDistinct() {
        return this.hasDistinct;
    }

    public void setDistinct(boolean distinct) {
        this.hasDistinct = distinct;
    }

    public boolean hasAggFunctions() {
        return this.aggrFunctions.length > 0;
    }

    public int aggregationFunctionNum() {
        return this.aggrFunctions.length;
    }

    public AggregationFunctionCallEval[] getAggFunctions() {
        return this.aggrFunctions;
    }

    public void setAggFunctions(AggregationFunctionCallEval[] evals) {
        Preconditions.checkNotNull((Object)evals);
        this.aggrFunctions = evals;
    }

    @Override
    public boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public Target[] getTargets() {
        return this.targets;
    }

    @Override
    public void setChild(LogicalNode subNode) {
        super.setChild(subNode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("GroupBy (");
        if (this.groupingKeys != null || this.groupingKeys.length > 0) {
            sb.append("grouping set=").append(TUtil.arrayToString((Object[])this.groupingKeys));
            sb.append(", ");
        }
        if (this.hasAggFunctions()) {
            sb.append("funcs=").append(TUtil.arrayToString((Object[])this.aggrFunctions));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GroupbyNode) {
            GroupbyNode other = (GroupbyNode)obj;
            boolean eq = super.equals(other);
            eq = eq && this.isDistinct() == other.isDistinct();
            eq = eq && TUtil.checkEquals((Object[])this.groupingKeys, (Object[])other.groupingKeys);
            eq = eq && TUtil.checkEquals((Object[])this.aggrFunctions, (Object[])other.aggrFunctions);
            eq = eq && TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            return eq;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        GroupbyNode grp = (GroupbyNode)super.clone();
        if (this.groupingKeys != null) {
            grp.groupingKeys = new Column[this.groupingKeys.length];
            for (i = 0; i < this.groupingKeys.length; ++i) {
                grp.groupingKeys[i] = this.groupingKeys[i];
            }
        }
        if (this.aggrFunctions != null) {
            grp.aggrFunctions = new AggregationFunctionCallEval[this.aggrFunctions.length];
            for (i = 0; i < this.aggrFunctions.length; ++i) {
                grp.aggrFunctions[i] = (AggregationFunctionCallEval)this.aggrFunctions[i].clone();
            }
        }
        if (this.targets != null) {
            grp.targets = new Target[this.targets.length];
            for (i = 0; i < this.targets.length; ++i) {
                grp.targets[i] = (Target)this.targets[i].clone();
            }
        }
        return grp;
    }

    public String getShortPlanString() {
        int j;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().name() + "(" + this.getPID() + ")").append("(");
        Column[] groupingColumns = this.groupingKeys;
        for (j = 0; j < groupingColumns.length; ++j) {
            sb.append(groupingColumns[j].getSimpleName());
            if (j >= groupingColumns.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        if (this.hasAggFunctions()) {
            sb.append(", exprs: (");
            for (j = 0; j < this.aggrFunctions.length; ++j) {
                sb.append(this.aggrFunctions[j]);
                if (j >= this.aggrFunctions.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        if (this.targets != null) {
            sb.append(", target list:{");
            for (int i = 0; i < this.targets.length; ++i) {
                sb.append(this.targets[i]);
                if (i >= this.targets.length - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
        }
        sb.append(", out schema:").append(this.getOutSchema().toString());
        sb.append(", in schema:").append(this.getInSchema().toString());
        return sb.toString();
    }

    @Override
    public PlanString getPlanString() {
        int j;
        PlanString planStr = new PlanString(this);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Column[] groupingColumns = this.groupingKeys;
        for (j = 0; j < groupingColumns.length; ++j) {
            sb.append(groupingColumns[j].getSimpleName());
            if (j >= groupingColumns.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        planStr.appendTitle(sb.toString());
        if (this.hasAggFunctions()) {
            sb = new StringBuilder();
            sb.append("(");
            for (j = 0; j < this.aggrFunctions.length; ++j) {
                sb.append(this.aggrFunctions[j]);
                if (j >= this.aggrFunctions.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            planStr.appendExplain("exprs: ").appendExplain(sb.toString());
        }
        sb = new StringBuilder("target list: ");
        for (int i = 0; i < this.targets.length; ++i) {
            sb.append(this.targets[i]);
            if (i >= this.targets.length - 1) continue;
            sb.append(", ");
        }
        planStr.addExplan(sb.toString());
        planStr.addDetail("out schema:").appendDetail(this.getOutSchema().toString());
        planStr.addDetail("in schema:").appendDetail(this.getInSchema().toString());
        return planStr;
    }

    public boolean isAggregationColumn(String simpleName) {
        for (int i = this.groupingKeys.length; i < this.targets.length; ++i) {
            if (!simpleName.equals(this.targets[i].getNamedColumn().getSimpleName()) && !simpleName.equals(this.targets[i].getAlias())) continue;
            return true;
        }
        return false;
    }
}

