/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;

public class DropTableNode
extends LogicalNode
implements Cloneable {
    private String tableName;
    private boolean ifExists;
    private boolean purge;

    public DropTableNode(int pid) {
        super(pid, NodeType.DROP_TABLE);
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public LogicalNode getChild(int idx) {
        return null;
    }

    public void init(String tableName, boolean ifExists, boolean purge) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.purge = purge;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isPurge() {
        return this.purge;
    }

    @Override
    public PlanString getPlanString() {
        return new PlanString(this).appendTitle(this.ifExists ? " IF EXISTS" : "").appendTitle(this.purge ? " PURGE" : "");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableName, this.ifExists, this.purge});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DropTableNode) {
            DropTableNode other = (DropTableNode)obj;
            return super.equals(other) && this.tableName.equals(other.tableName) && this.ifExists == other.ifExists && this.purge == other.purge;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DropTableNode dropTableNode = (DropTableNode)super.clone();
        dropTableNode.tableName = this.tableName;
        dropTableNode.ifExists = this.ifExists;
        dropTableNode.purge = this.purge;
        return dropTableNode;
    }

    @Override
    public String toString() {
        return "DROP TABLE " + (this.ifExists ? "IF EXISTS " : "") + this.tableName + (this.purge ? " PURGE" : "");
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
    }
}

