/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class DistinctGroupbyNode
extends UnaryNode
implements Projectable,
Cloneable {
    @Expose
    private GroupbyNode groupbyPlan;
    @Expose
    private List<GroupbyNode> subGroupbyPlan;
    @Expose
    private Target[] targets;
    @Expose
    private Column[] groupingColumns = PlannerUtil.EMPTY_COLUMNS;
    @Expose
    private int[] resultColumnIds = new int[0];
    @Expose
    private AggregationFunctionCallEval[] aggrFunctions = PlannerUtil.EMPTY_AGG_FUNCS;

    public DistinctGroupbyNode(int pid) {
        super(pid, NodeType.DISTINCT_GROUP_BY);
    }

    @Override
    public boolean hasTargets() {
        return this.targets.length > 0;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public Target[] getTargets() {
        if (this.hasTargets()) {
            return this.targets;
        }
        return new Target[0];
    }

    public void setSubPlans(List<GroupbyNode> groupByNodes) {
        this.subGroupbyPlan = groupByNodes;
    }

    public List<GroupbyNode> getSubPlans() {
        return this.subGroupbyPlan;
    }

    public final Column[] getGroupingColumns() {
        return this.groupingColumns;
    }

    public final void setGroupingColumns(Column[] groupingColumns) {
        this.groupingColumns = groupingColumns;
    }

    public int[] getResultColumnIds() {
        return this.resultColumnIds;
    }

    public void setResultColumnIds(int[] resultColumnIds) {
        this.resultColumnIds = resultColumnIds;
    }

    public AggregationFunctionCallEval[] getAggFunctions() {
        return this.aggrFunctions;
    }

    public void setAggFunctions(AggregationFunctionCallEval[] evals) {
        this.aggrFunctions = evals;
    }

    public void setGroupbyPlan(GroupbyNode groupbyPlan) {
        this.groupbyPlan = groupbyPlan;
    }

    public GroupbyNode getGroupbyPlan() {
        return this.groupbyPlan;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        DistinctGroupbyNode cloneNode = (DistinctGroupbyNode)super.clone();
        if (this.groupingColumns != null) {
            cloneNode.groupingColumns = new Column[this.groupingColumns.length];
            for (i = 0; i < this.groupingColumns.length; ++i) {
                cloneNode.groupingColumns[i] = this.groupingColumns[i];
            }
        }
        if (this.subGroupbyPlan != null) {
            cloneNode.subGroupbyPlan = new ArrayList<GroupbyNode>();
            for (GroupbyNode eachNode : this.subGroupbyPlan) {
                GroupbyNode groupbyNode = (GroupbyNode)eachNode.clone();
                groupbyNode.setPID(-1);
                cloneNode.subGroupbyPlan.add(groupbyNode);
            }
        }
        if (this.targets != null) {
            cloneNode.targets = new Target[this.targets.length];
            for (i = 0; i < this.targets.length; ++i) {
                cloneNode.targets[i] = (Target)this.targets[i].clone();
            }
        }
        if (this.groupbyPlan != null) {
            cloneNode.groupbyPlan = (GroupbyNode)this.groupbyPlan.clone();
        }
        return cloneNode;
    }

    public final boolean isEmptyGrouping() {
        return this.groupingColumns == null || this.groupingColumns.length == 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Distinct GroupBy (");
        if (this.groupingColumns != null || this.groupingColumns.length > 0) {
            sb.append("grouping set=").append(TUtil.arrayToString((Object[])this.groupingColumns));
            sb.append(", ");
        }
        for (GroupbyNode eachNode : this.subGroupbyPlan) {
            sb.append(", groupbyNode=").append(eachNode.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DistinctGroupbyNode) {
            DistinctGroupbyNode other = (DistinctGroupbyNode)obj;
            boolean eq = super.equals(other);
            eq = eq && TUtil.checkEquals((Object[])this.groupingColumns, (Object[])other.groupingColumns);
            eq = eq && TUtil.checkEquals(this.subGroupbyPlan, other.subGroupbyPlan);
            eq = eq && TUtil.checkEquals((Object[])this.targets, (Object[])other.targets);
            eq = eq && TUtil.checkEquals((int[])this.resultColumnIds, (int[])other.resultColumnIds);
            return eq;
        }
        return false;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Column[] groupingColumns = this.groupingColumns;
        for (int j = 0; j < groupingColumns.length; ++j) {
            sb.append(groupingColumns[j].getSimpleName());
            if (j >= groupingColumns.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        planStr.appendTitle(sb.toString());
        sb = new StringBuilder();
        sb.append("(");
        String prefix = "";
        for (GroupbyNode eachNode : this.subGroupbyPlan) {
            if (!eachNode.hasAggFunctions()) continue;
            AggregationFunctionCallEval[] aggrFunctions = eachNode.getAggFunctions();
            for (int j = 0; j < aggrFunctions.length; ++j) {
                sb.append(prefix).append(aggrFunctions[j]);
                prefix = ",";
            }
        }
        sb.append(")");
        planStr.appendExplain("exprs: ").appendExplain(sb.toString());
        sb = new StringBuilder("target list: ");
        for (int i = 0; i < this.targets.length; ++i) {
            sb.append(this.targets[i]);
            if (i >= this.targets.length - 1) continue;
            sb.append(", ");
        }
        planStr.addExplan(sb.toString());
        planStr.addDetail("out schema:").appendDetail(this.getOutSchema().toString());
        planStr.addDetail("in schema:").appendDetail(this.getInSchema().toString());
        for (GroupbyNode eachNode : this.subGroupbyPlan) {
            planStr.addDetail("\t").appendDetail("distinct: " + eachNode.isDistinct()).appendDetail(", " + eachNode.getShortPlanString());
        }
        return planStr;
    }

    public Column[] getFirstStageShuffleKeyColumns() {
        ArrayList<Column> shuffleKeyColumns = new ArrayList<Column>();
        shuffleKeyColumns.add(this.getOutSchema().getColumn(0));
        if (this.groupingColumns != null) {
            for (Column eachColumn : this.groupingColumns) {
                if (shuffleKeyColumns.contains(eachColumn)) continue;
                shuffleKeyColumns.add(eachColumn);
            }
        }
        for (GroupbyNode eachGroupbyNode : this.subGroupbyPlan) {
            if (eachGroupbyNode.getGroupingColumns() == null || eachGroupbyNode.getGroupingColumns().length <= 0) continue;
            for (Column eachColumn : eachGroupbyNode.getGroupingColumns()) {
                if (shuffleKeyColumns.contains(eachColumn)) continue;
                shuffleKeyColumns.add(eachColumn);
            }
        }
        return shuffleKeyColumns.toArray(new Column[0]);
    }
}

