/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.StoreTableNode;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.TUtil;

public class CreateTableNode
extends StoreTableNode
implements Cloneable {
    @Expose
    private Schema schema;
    @Expose
    private Path path;
    @Expose
    private boolean external;
    @Expose
    private boolean ifNotExists;

    public CreateTableNode(int pid) {
        super(pid, NodeType.CREATE_TABLE);
    }

    public void setTableSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getTableSchema() {
        return this.schema;
    }

    public Schema getLogicalSchema() {
        if (this.hasPartition()) {
            Schema logicalSchema = new Schema(this.schema);
            logicalSchema.addColumns(this.getPartitionMethod().getExpressionSchema());
            return logicalSchema;
        }
        return this.schema;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean hasSubQuery() {
        return this.child != null;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public PlanString getPlanString() {
        return new PlanString(this);
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.schema, this.path, this.external, this.ifNotExists}) * 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CreateTableNode) {
            CreateTableNode other = (CreateTableNode)obj;
            boolean eq = super.equals(other);
            eq &= this.schema.equals((Object)other.schema);
            eq &= this.external == other.external;
            eq &= TUtil.checkEquals((Object)this.path, (Object)other.path);
            return eq &= this.ifNotExists == other.ifNotExists;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CreateTableNode createTableNode = (CreateTableNode)super.clone();
        createTableNode.tableName = this.tableName;
        createTableNode.schema = (Schema)this.schema.clone();
        createTableNode.storageType = this.storageType;
        createTableNode.external = this.external;
        createTableNode.path = this.path != null ? new Path(this.path.toString()) : null;
        createTableNode.options = (KeyValueSet)(this.options != null ? this.options.clone() : null);
        createTableNode.ifNotExists = this.ifNotExists;
        return createTableNode;
    }

    @Override
    public String toString() {
        return "CreateTable (table=" + this.tableName + ", external=" + this.external + ", storeType=" + this.storageType + ", ifNotExists=" + this.ifNotExists + ")";
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        if (this.hasSubQuery()) {
            this.child.preOrder(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
        if (this.hasSubQuery()) {
            this.child.preOrder(visitor);
        }
    }
}

