/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.joinorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.expr.AlgebraicUtil;
import org.apache.tajo.plan.joinorder.FoundJoinOrder;
import org.apache.tajo.plan.joinorder.JoinEdge;
import org.apache.tajo.plan.joinorder.JoinGraph;
import org.apache.tajo.plan.joinorder.JoinOrderAlgorithm;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public class GreedyHeuristicJoinOrderAlgorithm
implements JoinOrderAlgorithm {
    public static double DEFAULT_SELECTION_FACTOR = 0.1;

    @Override
    public FoundJoinOrder findBestOrder(LogicalPlan plan, LogicalPlan.QueryBlock block, JoinGraph joinGraph, Set<String> relationsWithoutQual) throws PlanningException {
        LinkedHashSet<RelationNode> remainRelations = new LinkedHashSet<RelationNode>();
        for (RelationNode relation : block.getRelations()) {
            remainRelations.add(relation);
        }
        while (remainRelations.size() > 1) {
            LinkedHashSet<LogicalNode> checkingRelations = new LinkedHashSet<LogicalNode>();
            for (LogicalNode logicalNode : remainRelations) {
                Collection<String> relationStrings = PlannerUtil.getRelationLineageWithinQueryBlock(plan, logicalNode);
                ArrayList joinEdges = new ArrayList();
                String relationCollection = TUtil.collectionToString(relationStrings, (String)",");
                List joinEdgesForGiven = joinGraph.getIncomingEdges(relationCollection);
                if (joinEdgesForGiven != null) {
                    joinEdges.addAll(joinEdgesForGiven);
                }
                if (relationStrings.size() > 1) {
                    for (String relationString : relationStrings) {
                        joinEdgesForGiven = joinGraph.getIncomingEdges(relationString);
                        if (joinEdgesForGiven == null) continue;
                        joinEdges.addAll(joinEdgesForGiven);
                    }
                }
                boolean endInnerRelation = false;
                for (JoinEdge joinEdge : joinEdges) {
                    switch (joinEdge.getJoinType()) {
                        case LEFT_ANTI: 
                        case RIGHT_ANTI: 
                        case LEFT_SEMI: 
                        case RIGHT_SEMI: 
                        case LEFT_OUTER: 
                        case RIGHT_OUTER: 
                        case FULL_OUTER: {
                            endInnerRelation = true;
                            if (checkingRelations.size() > 1) break;
                            checkingRelations.add(logicalNode);
                        }
                    }
                }
                if (endInnerRelation) break;
                checkingRelations.add(logicalNode);
            }
            remainRelations.removeAll(checkingRelations);
            while (checkingRelations.size() > 1) {
                LinkedHashSet<String[]> removingJoinEdges = new LinkedHashSet<String[]>();
                JoinEdge bestPair = this.getBestPair(plan, joinGraph, checkingRelations, removingJoinEdges);
                checkingRelations.remove(bestPair.getLeftRelation());
                checkingRelations.remove(bestPair.getRightRelation());
                for (String[] joinEdge : removingJoinEdges) {
                    joinGraph.removeEdge(joinEdge[0], joinEdge[1]);
                }
                JoinNode latestJoin = GreedyHeuristicJoinOrderAlgorithm.createJoinNode(plan, bestPair);
                checkingRelations.add(latestJoin);
                block.registerNode(latestJoin);
            }
            checkingRelations.addAll(remainRelations);
            remainRelations = checkingRelations;
        }
        JoinNode joinTree = (JoinNode)remainRelations.iterator().next();
        block.registerNode(joinTree);
        return new FoundJoinOrder(joinTree, GreedyHeuristicJoinOrderAlgorithm.getCost(joinTree));
    }

    private static JoinNode createJoinNode(LogicalPlan plan, JoinEdge joinEdge) {
        LogicalNode left = joinEdge.getLeftRelation();
        LogicalNode right = joinEdge.getRightRelation();
        JoinNode joinNode = plan.createNode(JoinNode.class);
        if (PlannerUtil.isCommutativeJoin(joinEdge.getJoinType())) {
            if (left instanceof RelationNode && !(right instanceof RelationNode)) {
                joinNode.init(joinEdge.getJoinType(), right, left);
            } else {
                joinNode.init(joinEdge.getJoinType(), left, right);
            }
        } else {
            joinNode.init(joinEdge.getJoinType(), left, right);
        }
        Schema mergedSchema = SchemaUtil.merge((Schema)((LogicalNode)joinNode.getLeftChild()).getOutSchema(), (Schema)((LogicalNode)joinNode.getRightChild()).getOutSchema());
        joinNode.setInSchema(mergedSchema);
        joinNode.setOutSchema(mergedSchema);
        if (joinEdge.hasJoinQual()) {
            joinNode.setJoinQual(AlgebraicUtil.createSingletonExprFromCNF(joinEdge.getJoinQual()));
        }
        return joinNode;
    }

    private JoinEdge getBestPair(LogicalPlan plan, JoinGraph graph, Set<LogicalNode> candidateSet, Set<String[]> bestJoinEdges) throws PlanningException {
        double minCost = Double.MAX_VALUE;
        JoinEdge bestJoin = null;
        LinkedHashSet<String[]> relatedJoinEdges = null;
        LinkedHashSet<String[]> relatedNonCrossJoinEdges = null;
        double minNonCrossJoinCost = Double.MAX_VALUE;
        JoinEdge bestNonCrossJoin = null;
        for (LogicalNode outer : candidateSet) {
            for (LogicalNode inner : candidateSet) {
                LinkedHashSet<String[]> joinEdgePairs;
                JoinEdge foundJoin;
                if (outer.equals(inner) || (foundJoin = GreedyHeuristicJoinOrderAlgorithm.findJoin(plan, graph, outer, inner, joinEdgePairs = new LinkedHashSet<String[]>())) == null) continue;
                double cost = GreedyHeuristicJoinOrderAlgorithm.getCost(foundJoin);
                if (cost < minCost) {
                    minCost = cost;
                    bestJoin = foundJoin;
                    relatedJoinEdges = joinEdgePairs;
                }
                if (!foundJoin.hasJoinQual() || !(cost < minNonCrossJoinCost)) continue;
                minNonCrossJoinCost = cost;
                bestNonCrossJoin = foundJoin;
                relatedNonCrossJoinEdges = joinEdgePairs;
            }
        }
        if (bestNonCrossJoin != null) {
            bestJoinEdges.addAll(relatedNonCrossJoinEdges);
            return bestNonCrossJoin;
        }
        bestJoinEdges.addAll(relatedJoinEdges);
        return bestJoin;
    }

    private static JoinEdge findJoin(LogicalPlan plan, JoinGraph graph, LogicalNode outer, LogicalNode inner, Set<String[]> joinEdgePairs) throws PlanningException {
        String[] joinEdgePair;
        JoinEdge existJoinEdge;
        JoinEdge foundJoinEdge = null;
        TreeSet<String> relationNames = new TreeSet<String>(PlannerUtil.getRelationLineageWithinQueryBlock(plan, outer));
        String outerEdgeKey = TUtil.collectionToString(relationNames, (String)", ");
        for (String innerName : PlannerUtil.getRelationLineageWithinQueryBlock(plan, inner)) {
            if (!graph.hasEdge(outerEdgeKey, innerName)) continue;
            existJoinEdge = (JoinEdge)graph.getEdge(outerEdgeKey, innerName);
            joinEdgePair = new String[]{outerEdgeKey, innerName};
            joinEdgePairs.add(joinEdgePair);
            if (foundJoinEdge == null) {
                foundJoinEdge = new JoinEdge(existJoinEdge.getJoinType(), outer, inner, existJoinEdge.getJoinQual());
                continue;
            }
            foundJoinEdge.addJoinQual(AlgebraicUtil.createSingletonExprFromCNF(existJoinEdge.getJoinQual()));
        }
        if (foundJoinEdge != null) {
            return foundJoinEdge;
        }
        relationNames = new TreeSet<String>(PlannerUtil.getRelationLineageWithinQueryBlock(plan, inner));
        outerEdgeKey = TUtil.collectionToString(relationNames, (String)", ");
        for (String outerName : PlannerUtil.getRelationLineageWithinQueryBlock(plan, outer)) {
            if (!graph.hasEdge(outerEdgeKey, outerName)) continue;
            existJoinEdge = (JoinEdge)graph.getEdge(outerEdgeKey, outerName);
            joinEdgePair = new String[]{outerEdgeKey, outerName};
            joinEdgePairs.add(joinEdgePair);
            if (foundJoinEdge == null) {
                foundJoinEdge = new JoinEdge(existJoinEdge.getJoinType(), inner, outer, existJoinEdge.getJoinQual());
                continue;
            }
            foundJoinEdge.addJoinQual(AlgebraicUtil.createSingletonExprFromCNF(existJoinEdge.getJoinQual()));
        }
        if (foundJoinEdge != null) {
            return foundJoinEdge;
        }
        for (String outerName : PlannerUtil.getRelationLineageWithinQueryBlock(plan, outer)) {
            for (String innerName : PlannerUtil.getRelationLineageWithinQueryBlock(plan, inner)) {
                if (!graph.hasEdge(outerName, innerName)) continue;
                JoinEdge existJoinEdge2 = (JoinEdge)graph.getEdge(outerName, innerName);
                String[] joinEdgePair2 = new String[]{outerName, innerName};
                joinEdgePairs.add(joinEdgePair2);
                if (foundJoinEdge == null) {
                    foundJoinEdge = new JoinEdge(existJoinEdge2.getJoinType(), outer, inner, existJoinEdge2.getJoinQual());
                    continue;
                }
                foundJoinEdge.addJoinQual(AlgebraicUtil.createSingletonExprFromCNF(existJoinEdge2.getJoinQual()));
            }
        }
        if (foundJoinEdge == null) {
            foundJoinEdge = new JoinEdge(JoinType.CROSS, outer, inner);
        }
        return foundJoinEdge;
    }

    public static double getCost(JoinEdge joinEdge) {
        double filterFactor = 1.0;
        if (joinEdge.hasJoinQual()) {
            return GreedyHeuristicJoinOrderAlgorithm.getCost(joinEdge.getLeftRelation()) * GreedyHeuristicJoinOrderAlgorithm.getCost(joinEdge.getRightRelation()) * (filterFactor *= Math.pow(DEFAULT_SELECTION_FACTOR, joinEdge.getJoinQual().length));
        }
        return Math.pow(GreedyHeuristicJoinOrderAlgorithm.getCost(joinEdge.getLeftRelation()) * GreedyHeuristicJoinOrderAlgorithm.getCost(joinEdge.getRightRelation()), 2.0);
    }

    public static double getCost(LogicalNode node) {
        switch (node.getType()) {
            case PROJECTION: {
                ProjectionNode projectionNode = (ProjectionNode)node;
                return GreedyHeuristicJoinOrderAlgorithm.getCost(projectionNode.getChild());
            }
            case JOIN: {
                JoinNode joinNode = (JoinNode)node;
                double filterFactor = 1.0;
                if (joinNode.hasJoinQual()) {
                    filterFactor = Math.pow(DEFAULT_SELECTION_FACTOR, AlgebraicUtil.toConjunctiveNormalFormArray(joinNode.getJoinQual()).length);
                    return GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getLeftChild()) * GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getRightChild()) * filterFactor;
                }
                return Math.pow(GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getLeftChild()) * GreedyHeuristicJoinOrderAlgorithm.getCost(joinNode.getRightChild()), 2.0);
            }
            case SELECTION: {
                SelectionNode selectionNode = (SelectionNode)node;
                return GreedyHeuristicJoinOrderAlgorithm.getCost(selectionNode.getChild()) * Math.pow(DEFAULT_SELECTION_FACTOR, AlgebraicUtil.toConjunctiveNormalFormArray(selectionNode.getQual()).length);
            }
            case TABLE_SUBQUERY: {
                TableSubQueryNode subQueryNode = (TableSubQueryNode)node;
                return GreedyHeuristicJoinOrderAlgorithm.getCost(subQueryNode.getSubQuery());
            }
            case SCAN: {
                ScanNode scanNode = (ScanNode)node;
                if (scanNode.getTableDesc().getStats() != null) {
                    double cost = ((ScanNode)node).getTableDesc().getStats().getNumBytes().longValue();
                    return cost;
                }
                return 9.223372036854776E18;
            }
            case UNION: {
                UnionNode unionNode = (UnionNode)node;
                return GreedyHeuristicJoinOrderAlgorithm.getCost(unionNode.getLeftChild()) + GreedyHeuristicJoinOrderAlgorithm.getCost(unionNode.getRightChild());
            }
            case EXCEPT: 
            case INTERSECT: {
                throw new UnsupportedOperationException("getCost() does not support EXCEPT or INTERSECT yet");
            }
        }
        return GreedyHeuristicJoinOrderAlgorithm.getCost(((UnaryNode)node).getChild());
    }
}

