/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.exprrewrite.rules;

import java.util.Stack;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.annotator.Prioritized;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.SimpleEvalNodeVisitor;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.plan.exprrewrite.EvalTreeOptimizationRule;

@Prioritized(priority=15)
public class ConstantPropagation
extends SimpleEvalNodeVisitor<LogicalPlanner.PlanContext>
implements EvalTreeOptimizationRule {
    @Override
    public EvalNode optimize(LogicalPlanner.PlanContext context, EvalNode evalNode) {
        if (evalNode.getType() == EvalType.FIELD) {
            FieldEval fieldEval = (FieldEval)evalNode;
            if (context.getQueryBlock().isConstReference(fieldEval.getName())) {
                return context.getQueryBlock().getConstByReference(fieldEval.getName());
            }
            return evalNode;
        }
        return this.visit(context, evalNode, new Stack<EvalNode>());
    }

    @Override
    public EvalNode visitBinaryEval(LogicalPlanner.PlanContext context, Stack<EvalNode> stack, BinaryEval binaryEval) {
        stack.push(binaryEval);
        for (int i = 0; i < 2; ++i) {
            if (binaryEval.getChild(i).getType() == EvalType.FIELD) {
                FieldEval fieldEval = (FieldEval)binaryEval.getChild(i);
                if (context.getQueryBlock().isConstReference(fieldEval.getName())) {
                    binaryEval.setChild(i, context.getQueryBlock().getConstByReference(fieldEval.getName()));
                    continue;
                }
            }
            this.visit(context, binaryEval.getChild(i), stack);
        }
        stack.pop();
        return binaryEval;
    }

    @Override
    public EvalNode visitUnaryEval(LogicalPlanner.PlanContext context, Stack<EvalNode> stack, UnaryEval unaryEval) {
        stack.push(unaryEval);
        if (unaryEval.getChild().getType() == EvalType.FIELD) {
            FieldEval fieldEval = (FieldEval)unaryEval.getChild();
            if (context.getQueryBlock().isConstReference(fieldEval.getName())) {
                unaryEval.setChild(context.getQueryBlock().getConstByReference(fieldEval.getName()));
                stack.pop();
                return unaryEval;
            }
        }
        this.visit(context, unaryEval.getChild(), stack);
        stack.pop();
        return unaryEval;
    }

    @Override
    public EvalNode visitFuncCall(LogicalPlanner.PlanContext context, FunctionEval function, Stack<EvalNode> stack) {
        stack.push(function);
        for (int i = 0; i < function.getArgs().length; ++i) {
            if (function.getArgs()[i].getType() == EvalType.FIELD) {
                FieldEval fieldEval = (FieldEval)function.getArgs()[i];
                if (context.getQueryBlock().isConstReference(fieldEval.getName())) {
                    function.setArg(i, context.getQueryBlock().getConstByReference(fieldEval.getName()));
                    continue;
                }
            }
            this.visit(context, function.getArgs()[i], stack);
        }
        stack.pop();
        return function;
    }
}

