/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.exprrewrite.rules;

import java.util.Stack;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.annotator.Prioritized;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.SimpleEvalNodeVisitor;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.plan.exprrewrite.EvalTreeOptimizationRule;

@Prioritized(priority=10)
public class ConstantFolding
extends SimpleEvalNodeVisitor<LogicalPlanner.PlanContext>
implements EvalTreeOptimizationRule {
    @Override
    public EvalNode optimize(LogicalPlanner.PlanContext context, EvalNode evalNode) {
        return this.visit(context, evalNode, new Stack<EvalNode>());
    }

    @Override
    public EvalNode visitBinaryEval(LogicalPlanner.PlanContext context, Stack<EvalNode> stack, BinaryEval binaryEval) {
        stack.push(binaryEval);
        EvalNode lhs = this.visit(context, (EvalNode)binaryEval.getLeftExpr(), stack);
        EvalNode rhs = this.visit(context, (EvalNode)binaryEval.getRightExpr(), stack);
        stack.pop();
        if (!binaryEval.getLeftExpr().equals(lhs)) {
            binaryEval.setLeftExpr(lhs);
        }
        if (!binaryEval.getRightExpr().equals(rhs)) {
            binaryEval.setRightExpr(rhs);
        }
        if (lhs.getType() == EvalType.CONST && rhs.getType() == EvalType.CONST) {
            return new ConstEval(binaryEval.eval(null, null));
        }
        return binaryEval;
    }

    @Override
    public EvalNode visitUnaryEval(LogicalPlanner.PlanContext context, Stack<EvalNode> stack, UnaryEval unaryEval) {
        stack.push(unaryEval);
        EvalNode child = this.visit(context, unaryEval.getChild(), stack);
        stack.pop();
        if (child.getType() == EvalType.CONST) {
            return new ConstEval((Datum)unaryEval.eval(null, null));
        }
        return unaryEval;
    }

    @Override
    public EvalNode visitFuncCall(LogicalPlanner.PlanContext context, FunctionEval evalNode, Stack<EvalNode> stack) {
        boolean constantOfAllDescendents = true;
        if ("sleep".equals(evalNode.getFuncDesc().getFunctionName())) {
            constantOfAllDescendents = false;
        } else if (evalNode.getArgs() != null) {
            for (EvalNode arg : evalNode.getArgs()) {
                constantOfAllDescendents &= (arg = this.visit(context, arg, stack)).getType() == EvalType.CONST;
            }
        }
        if (constantOfAllDescendents && evalNode.getType() == EvalType.FUNCTION) {
            return new ConstEval(evalNode.eval(null, null));
        }
        return evalNode;
    }
}

