/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.exprrewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.annotator.Prioritized;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.exprrewrite.EvalTreeOptimizationRule;
import org.apache.tajo.util.ClassUtil;

public class EvalTreeOptimizer {
    private static final Log LOG = LogFactory.getLog(EvalTreeOptimizer.class);
    private List<EvalTreeOptimizationRule> rules = Lists.newArrayList();

    public EvalTreeOptimizer() {
        Set functionClasses = ClassUtil.findClasses(EvalTreeOptimizationRule.class, (String)(EvalTreeOptimizationRule.class.getPackage().getName() + ".rules"));
        for (Class eachRule : functionClasses) {
            if (!EvalTreeOptimizationRule.class.isAssignableFrom(eachRule)) continue;
            EvalTreeOptimizationRule rule = null;
            try {
                rule = (EvalTreeOptimizationRule)eachRule.newInstance();
            }
            catch (Exception e) {
                LOG.warn((Object)(eachRule + " cannot instantiate EvalTreeOptimizerRule class because of " + e.getMessage()));
                continue;
            }
            this.rules.add(rule);
        }
        Collections.sort(this.rules, new Comparator<EvalTreeOptimizationRule>(){

            @Override
            public int compare(EvalTreeOptimizationRule o1, EvalTreeOptimizationRule o2) {
                int priority1 = o1.getClass().getAnnotation(Prioritized.class).priority();
                int priority2 = o2.getClass().getAnnotation(Prioritized.class).priority();
                return priority1 - priority2;
            }
        });
    }

    public EvalNode optimize(LogicalPlanner.PlanContext context, EvalNode node) {
        Preconditions.checkNotNull((Object)node);
        EvalNode optimized = node;
        for (EvalTreeOptimizationRule rule : this.rules) {
            optimized = rule.optimize(context, optimized);
        }
        return optimized;
    }
}

