/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.function.AggFunction;
import org.apache.tajo.plan.function.FunctionContext;
import org.apache.tajo.plan.logical.WindowSpec;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.util.TUtil;

public class WindowFunctionEval
extends AggregationFunctionCallEval
implements Cloneable {
    @Expose
    private SortSpec[] sortSpecs;
    @Expose
    WindowSpec.WindowFrame windowFrame;
    private Tuple params;

    public WindowFunctionEval(FunctionDesc desc, AggFunction instance, EvalNode[] givenArgs, WindowSpec.WindowFrame windowFrame) {
        super(EvalType.WINDOW_FUNCTION, desc, instance, givenArgs);
        this.windowFrame = windowFrame;
    }

    public boolean hasSortSpecs() {
        return this.sortSpecs != null;
    }

    public void setSortSpecs(SortSpec[] sortSpecs) {
        this.sortSpecs = sortSpecs;
    }

    public SortSpec[] getSortSpecs() {
        return this.sortSpecs;
    }

    public WindowSpec.WindowFrame getWindowFrame() {
        return this.windowFrame;
    }

    @Override
    public Datum eval(Schema schema, Tuple tuple) {
        throw new UnsupportedOperationException("Cannot execute eval() of aggregation function");
    }

    @Override
    public void merge(FunctionContext context, Schema schema, Tuple tuple) {
        if (this.params == null) {
            this.params = new VTuple(this.argEvals.length);
        }
        if (this.argEvals != null) {
            for (int i = 0; i < this.argEvals.length; ++i) {
                this.params.put(i, this.argEvals[i].eval(schema, tuple));
            }
        }
        this.instance.eval(context, this.params);
    }

    @Override
    public Datum terminate(FunctionContext context) {
        return this.instance.terminate(context);
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return this.funcDesc.getReturnType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WindowFunctionEval) {
            WindowFunctionEval other = (WindowFunctionEval)obj;
            boolean eq = TUtil.checkEquals((Object[])this.sortSpecs, (Object[])other.sortSpecs);
            return eq &= TUtil.checkEquals((Object)this.windowFrame, (Object)other.windowFrame);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WindowFunctionEval windowFunctionEval = (WindowFunctionEval)super.clone();
        if (this.sortSpecs != null) {
            windowFunctionEval.sortSpecs = new SortSpec[this.sortSpecs.length];
            for (int i = 0; i < this.sortSpecs.length; ++i) {
                windowFunctionEval.sortSpecs[i] = (SortSpec)this.sortSpecs[i].clone();
            }
        }
        windowFunctionEval.windowFrame = this.windowFrame.clone();
        return windowFunctionEval;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.argEvals != null) {
            for (int i = 0; i < this.argEvals.length; ++i) {
                sb.append(this.argEvals[i]);
                if (i + 1 >= this.argEvals.length) continue;
                sb.append(",");
            }
        }
        sb.append(this.funcDesc.getFunctionName()).append("(").append(this.isDistinct() ? " distinct" : "").append((CharSequence)sb).append(")");
        if (this.hasSortSpecs()) {
            sb.append("ORDER BY ").append(TUtil.arrayToString((Object[])this.sortSpecs));
        }
        return sb.toString();
    }
}

