/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NumericDatum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.storage.Tuple;

public class SignedEval
extends UnaryEval
implements Cloneable {
    @Expose
    private boolean negative;

    public SignedEval(boolean negative, EvalNode childEval) {
        super(EvalType.SIGNED, childEval);
        this.negative = negative;
    }

    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return this.child.getValueType();
    }

    @Override
    public String getName() {
        return "?";
    }

    public Datum eval(Schema schema, Tuple tuple) {
        NumericDatum result = (NumericDatum)this.child.eval(schema, tuple);
        if (this.negative) {
            return result.inverseSign();
        }
        return result;
    }

    public String toString() {
        return (this.negative ? "-" : "+") + this.child.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SignedEval) {
            SignedEval other = (SignedEval)obj;
            return super.equals(other) && this.negative == other.negative;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.negative, this.child});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SignedEval signedEval = (SignedEval)super.clone();
        signedEval.negative = this.negative;
        return signedEval;
    }
}

