/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.TUtil;

public class RowConstantEval
extends EvalNode {
    @Expose
    Datum[] values;

    public RowConstantEval(Datum[] values) {
        super(EvalType.ROW_CONSTANT);
        this.values = values;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)this.values[0].type());
    }

    @Override
    public int childNum() {
        return 0;
    }

    @Override
    public EvalNode getChild(int idx) {
        return null;
    }

    @Override
    public String getName() {
        return "ROW";
    }

    public Datum eval(Schema schema, Tuple tuple) {
        return NullDatum.get();
    }

    public Datum[] getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RowConstantEval) {
            RowConstantEval other = (RowConstantEval)obj;
            return TUtil.checkEquals((Object[])this.values, (Object[])other.values);
        }
        return false;
    }

    public String toString() {
        return TUtil.arrayToString((Object[])this.values);
    }

    @Override
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void postOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RowConstantEval rowConstantEval = (RowConstantEval)super.clone();
        if (this.values != null) {
            rowConstantEval.values = new Datum[this.values.length];
            System.arraycopy(this.values, 0, rowConstantEval.values, 0, this.values.length);
        }
        return rowConstantEval;
    }
}

