/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;

public abstract class PatternMatchPredicateEval
extends BinaryEval {
    private static final TajoDataTypes.DataType RES_TYPE = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
    @Expose
    protected boolean not;
    @Expose
    protected String pattern;
    @Expose
    protected boolean caseInsensitive;
    protected Pattern compiled;

    public PatternMatchPredicateEval(EvalType evalType, boolean not, EvalNode predicand, ConstEval pattern, boolean caseInsensitive) {
        super(evalType, predicand, pattern);
        this.not = not;
        this.pattern = pattern.getValue().asChars();
        this.caseInsensitive = caseInsensitive;
    }

    public PatternMatchPredicateEval(EvalType evalType, boolean not, EvalNode field, ConstEval pattern) {
        this(evalType, not, field, pattern, false);
    }

    abstract void compile(String var1) throws PatternSyntaxException;

    public boolean isNot() {
        return this.not;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return RES_TYPE;
    }

    @Override
    public String getName() {
        return "?";
    }

    @Override
    public Datum eval(Schema schema, Tuple tuple) {
        Object predicand;
        if (this.compiled == null) {
            this.compile(this.pattern);
        }
        if ((predicand = this.leftExpr.eval(schema, tuple)).isNull()) {
            return NullDatum.get();
        }
        boolean matched = this.compiled.matcher(predicand.asChars()).matches();
        return DatumFactory.createBool((boolean)(matched ^ this.not));
    }
}

