/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.storage.Tuple;

public class NotEval
extends UnaryEval
implements Cloneable {
    private static final TajoDataTypes.DataType RES_TYPE = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);

    public NotEval(EvalNode child) {
        super(EvalType.NOT, child);
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return RES_TYPE;
    }

    @Override
    public String getName() {
        return "?";
    }

    public Datum eval(Schema schema, Tuple tuple) {
        Object datum = this.child.eval(schema, tuple);
        return !datum.isNull() ? DatumFactory.createBool((!datum.asBool() ? 1 : 0) != 0) : datum;
    }

    public String toString() {
        return "NOT " + this.child.toString();
    }
}

