/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.storage.Tuple;

public class IsNullEval
extends UnaryEval {
    private static final ConstEval DUMMY_EVAL = new ConstEval((Datum)DatumFactory.createBool((boolean)true));
    private static final TajoDataTypes.DataType RES_TYPE = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
    @Expose
    private boolean isNot;

    public IsNullEval(boolean not, EvalNode predicand) {
        super(EvalType.IS_NULL, predicand);
        this.isNot = not;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return RES_TYPE;
    }

    @Override
    public String getName() {
        return "?";
    }

    public String toString() {
        return this.child + " IS " + (this.isNot ? "NOT NULL" : "NULL");
    }

    public Datum eval(Schema schema, Tuple tuple) {
        boolean isNull = this.child.eval(schema, tuple).isNull();
        return DatumFactory.createBool((boolean)(this.isNot ^ isNull));
    }

    public boolean isNot() {
        return this.isNot;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IsNullEval) {
            IsNullEval other = (IsNullEval)obj;
            return super.equals(other) && this.isNot == other.isNot();
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        IsNullEval isNullEval = (IsNullEval)super.clone();
        isNullEval.isNot = this.isNot;
        return isNullEval;
    }
}

