/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.collect.Sets;
import com.google.gson.annotations.Expose;
import java.util.Set;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.storage.Tuple;

public class InEval
extends BinaryEval {
    private static final TajoDataTypes.DataType RES_TYPE = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
    @Expose
    private boolean not;
    Set<Datum> values;

    public InEval(EvalNode lhs, RowConstantEval valueList, boolean not) {
        super(EvalType.IN, lhs, valueList);
        this.not = not;
    }

    public boolean isNot() {
        return this.not;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return RES_TYPE;
    }

    @Override
    public String getName() {
        return "?";
    }

    @Override
    public Datum eval(Schema schema, Tuple tuple) {
        Object leftValue;
        if (this.values == null) {
            this.values = Sets.newHashSet((Object[])((RowConstantEval)this.rightExpr).getValues());
        }
        if ((leftValue = this.leftExpr.eval(schema, tuple)).isNull()) {
            return NullDatum.get();
        }
        return DatumFactory.createBool((boolean)(this.not ^ this.values.contains(leftValue)));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InEval) {
            InEval other = (InEval)obj;
            return super.equals(obj) && this.not == other.not;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.leftExpr + " IN (" + this.rightExpr + ")";
    }
}

