/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.function.GeneralFunction;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.util.TUtil;

public class GeneralFunctionEval
extends FunctionEval {
    @Expose
    protected GeneralFunction instance;
    private Tuple params = null;

    public GeneralFunctionEval(@Nullable OverridableConf queryContext, FunctionDesc desc, GeneralFunction instance, EvalNode[] givenArgs) {
        super(EvalType.FUNCTION, desc, givenArgs);
        this.instance = instance;
        this.instance.init(queryContext, this.getParamType());
    }

    @Override
    public Datum eval(Schema schema, Tuple tuple) {
        if (this.params == null) {
            this.params = new VTuple(this.argEvals.length);
        }
        if (this.argEvals != null) {
            this.params.clear();
            for (int i = 0; i < this.argEvals.length; ++i) {
                this.params.put(i, this.argEvals[i].eval(schema, tuple));
            }
        }
        return this.instance.eval(this.params);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GeneralFunctionEval) {
            GeneralFunctionEval other = (GeneralFunctionEval)obj;
            return super.equals(other) && TUtil.checkEquals((Object)((Object)this.instance), (Object)((Object)other.instance));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.funcDesc, this.instance});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GeneralFunctionEval eval = (GeneralFunctionEval)super.clone();
        eval.instance = (GeneralFunction)((Object)this.instance.clone());
        return eval;
    }
}

