/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.TUtil;

public abstract class FunctionEval
extends EvalNode
implements Cloneable {
    @Expose
    protected FunctionDesc funcDesc;
    @Expose
    protected EvalNode[] argEvals;

    public FunctionEval(EvalType type, FunctionDesc funcDesc, EvalNode[] argEvals) {
        super(type);
        this.funcDesc = funcDesc;
        Preconditions.checkArgument((argEvals != null ? 1 : 0) != 0, (Object)"argEvals cannot be null");
        this.argEvals = argEvals;
    }

    public FunctionDesc getFuncDesc() {
        return this.funcDesc;
    }

    public ParamType[] getParamType() {
        ParamType[] paramTypes = new ParamType[this.argEvals.length];
        for (int i = 0; i < this.argEvals.length; ++i) {
            if (this.argEvals[i].getType() == EvalType.CONST) {
                if (this.argEvals[i].getValueType().getType() == TajoDataTypes.Type.NULL_TYPE) {
                    paramTypes[i] = ParamType.NULL;
                    continue;
                }
                paramTypes[i] = ParamType.CONSTANT;
                continue;
            }
            paramTypes[i] = ParamType.VARIABLE;
        }
        return paramTypes;
    }

    public boolean isDistinct() {
        return this.funcDesc.getFuncType() == CatalogProtos.FunctionType.DISTINCT_AGGREGATION || this.funcDesc.getFuncType() == CatalogProtos.FunctionType.DISTINCT_UDA;
    }

    public EvalNode[] getArgs() {
        return this.argEvals;
    }

    public void setArg(int idx, EvalNode arg) {
        this.argEvals[idx] = arg;
    }

    public void setArgs(EvalNode[] args) {
        this.argEvals = args;
    }

    @Override
    public int childNum() {
        if (this.argEvals != null) {
            return this.argEvals.length;
        }
        return 0;
    }

    @Override
    public EvalNode getChild(int idx) {
        return this.argEvals[idx];
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return this.funcDesc.getReturnType();
    }

    public abstract Datum eval(Schema var1, Tuple var2);

    @Override
    public String getName() {
        return this.funcDesc.getFunctionName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.argEvals.length; ++i) {
            sb.append(this.argEvals[i]);
            if (i + 1 >= this.argEvals.length) continue;
            sb.append(",");
        }
        return this.funcDesc.getFunctionName() + "(" + (this.isDistinct() ? " distinct " : "") + sb + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof FunctionEval) {
            FunctionEval other = (FunctionEval)obj;
            boolean b1 = this.type == other.type;
            boolean b2 = TUtil.checkEquals((Object)this.funcDesc, (Object)other.funcDesc);
            boolean b3 = TUtil.checkEquals((Object[])this.argEvals, (Object[])other.argEvals);
            return b1 && b2 && b3;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.funcDesc, this.argEvals});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FunctionEval eval = (FunctionEval)super.clone();
        eval.funcDesc = (FunctionDesc)this.funcDesc.clone();
        if (this.argEvals != null) {
            eval.argEvals = new EvalNode[this.argEvals.length];
            for (int i = 0; i < this.argEvals.length; ++i) {
                eval.argEvals[i] = (EvalNode)this.argEvals[i].clone();
            }
        }
        return eval;
    }

    @Override
    public void preOrder(EvalNodeVisitor visitor) {
        if (this.argEvals != null) {
            for (EvalNode eval : this.argEvals) {
                eval.postOrder(visitor);
            }
        }
        visitor.visit(this);
    }

    @Override
    public void postOrder(EvalNodeVisitor visitor) {
        if (this.argEvals != null) {
            for (EvalNode eval : this.argEvals) {
                eval.postOrder(visitor);
            }
        }
        visitor.visit(this);
    }

    public static enum ParamType {
        CONSTANT,
        VARIABLE,
        NULL;

    }
}

