/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.exception.InternalException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BasicEvalNodeVisitor;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.util.ExprFinder;
import org.apache.tajo.util.TUtil;

public class EvalTreeUtil {
    public static void changeColumnRef(EvalNode node, String oldName, String newName) {
        node.postOrder(new ChangeColumnRefVisitor(oldName, newName));
    }

    public static int replace(EvalNode expr, EvalNode targetExpr, EvalNode tobeReplaced) {
        EvalReplaceVisitor replacer = new EvalReplaceVisitor(targetExpr, tobeReplaced);
        ReplaceContext context = new ReplaceContext();
        replacer.visitChild(context, expr, new Stack<EvalNode>());
        return context.countOfReplaces;
    }

    public static LinkedHashSet<Column> findUniqueColumns(EvalNode node) {
        UniqueColumnFinder finder = new UniqueColumnFinder();
        node.postOrder(finder);
        return finder.getColumnRefs();
    }

    public static List<Column> findAllColumnRefs(EvalNode node) {
        AllColumnRefFinder finder = new AllColumnRefFinder();
        node.postOrder(finder);
        return finder.getColumnRefs();
    }

    public static Schema getSchemaByTargets(Schema inputSchema, Target[] targets) throws InternalException {
        Schema schema = new Schema();
        for (Target target : targets) {
            schema.addColumn(target.hasAlias() ? target.getAlias() : ((EvalNode)target.getEvalTree()).getName(), EvalTreeUtil.getDomainByExpr(inputSchema, target.getEvalTree()));
        }
        return schema;
    }

    public static String columnsToStr(Collection<Column> columns) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (Column column : columns) {
            sb.append(prefix).append(column.getQualifiedName());
            prefix = ",";
        }
        return sb.toString();
    }

    public static TajoDataTypes.DataType getDomainByExpr(Schema inputSchema, EvalNode expr) throws InternalException {
        switch (expr.getType()) {
            case AND: 
            case OR: 
            case EQUAL: 
            case NOT_EQUAL: 
            case LTH: 
            case LEQ: 
            case GTH: 
            case GEQ: 
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case CONST: 
            case FUNCTION: {
                return expr.getValueType();
            }
            case FIELD: {
                FieldEval fieldEval = (FieldEval)expr;
                return inputSchema.getColumn(fieldEval.getName()).getDataType();
            }
        }
        throw new InternalException("Unknown expr type: " + expr.getType().toString());
    }

    public static Collection<EvalNode> getContainExpr(EvalNode expr, Column target) {
        HashSet exprSet = Sets.newHashSet();
        EvalTreeUtil.getContainExpr(expr, target, exprSet);
        return exprSet;
    }

    public static Map<EvalType, Integer> getExprCounters(EvalNode expr) {
        VariableCounter counter = new VariableCounter();
        expr.postOrder(counter);
        return counter.getCounter();
    }

    private static void getContainExpr(EvalNode expr, Column target, Set<EvalNode> exprSet) {
        switch (expr.getType()) {
            case EQUAL: 
            case NOT_EQUAL: 
            case LTH: 
            case LEQ: 
            case GTH: 
            case GEQ: {
                if (!EvalTreeUtil.containColumnRef(expr, target)) break;
                exprSet.add(expr);
            }
        }
    }

    public static boolean containColumnRef(EvalNode expr, Column target) {
        LinkedHashSet<Column> exprSet = EvalTreeUtil.findUniqueColumns(expr);
        return exprSet.contains(target);
    }

    public static boolean isJoinQual(EvalNode expr, boolean includeThetaJoin) {
        return EvalTreeUtil.isJoinQual(null, null, null, expr, includeThetaJoin);
    }

    public static boolean isJoinQual(@Nullable LogicalPlan.QueryBlock block, @Nullable Schema leftSchema, @Nullable Schema rightSchema, EvalNode expr, boolean includeThetaJoin) {
        if (expr instanceof BinaryEval) {
            boolean joinComparator = includeThetaJoin ? EvalType.isComparisonOperator(expr.getType()) : expr.getType() == EvalType.EQUAL;
            BinaryEval binaryEval = (BinaryEval)expr;
            boolean isBothTermFields = EvalTreeUtil.isSingleColumn(binaryEval.getLeftExpr()) && EvalTreeUtil.isSingleColumn(binaryEval.getRightExpr());
            LinkedHashSet<Column> leftColumns = EvalTreeUtil.findUniqueColumns(binaryEval.getLeftExpr());
            LinkedHashSet<Column> rightColumns = EvalTreeUtil.findUniqueColumns(binaryEval.getRightExpr());
            boolean ensureColumnsOfDifferentTables = false;
            if (leftColumns.size() == 1 && rightColumns.size() == 1) {
                Column leftColumn = (Column)leftColumns.iterator().next();
                Column rightColumn = (Column)rightColumns.iterator().next();
                ensureColumnsOfDifferentTables = block != null ? EvalTreeUtil.isJoinQualWithOnlyColumns(block, leftColumn, rightColumn) : (leftSchema != null && rightSchema != null ? EvalTreeUtil.isJoinQualwithSchemas(leftSchema, rightSchema, leftColumn, rightColumn) : EvalTreeUtil.isJoinQualWithOnlyColumns(block, leftColumn, rightColumn));
            }
            return joinComparator && isBothTermFields && ensureColumnsOfDifferentTables;
        }
        return false;
    }

    private static boolean isJoinQualwithSchemas(Schema leftSchema, Schema rightSchema, Column left, Column right) {
        boolean duplicated = leftSchema.contains(left) && rightSchema.contains(left);
        if (duplicated |= leftSchema.contains(right) && rightSchema.contains(right)) {
            return false;
        }
        boolean isJoinQual = leftSchema.contains(left) && rightSchema.contains(right);
        return isJoinQual |= leftSchema.contains(right) && rightSchema.contains(left);
    }

    private static boolean isJoinQualWithOnlyColumns(@Nullable LogicalPlan.QueryBlock block, Column left, Column right) {
        String leftQualifier = CatalogUtil.extractQualifier((String)left.getQualifiedName());
        String rightQualifier = CatalogUtil.extractQualifier((String)right.getQualifiedName());
        if (block != null) {
            NamedExpr rawExpr;
            Set foundColumns;
            boolean leftQualified = CatalogUtil.isFQColumnName((String)left.getQualifiedName());
            boolean rightQualified = CatalogUtil.isFQColumnName((String)right.getQualifiedName());
            if (!leftQualified && (foundColumns = ExprFinder.finds((rawExpr = block.getNamedExprsManager().getNamedExpr(left.getQualifiedName())).getExpr(), OpType.Column)).size() == 1) {
                leftQualifier = CatalogUtil.extractQualifier((String)((ColumnReferenceExpr)foundColumns.iterator().next()).getCanonicalName());
            }
            if (!rightQualified && (foundColumns = ExprFinder.finds((rawExpr = block.getNamedExprsManager().getNamedExpr(right.getQualifiedName())).getExpr(), OpType.Column)).size() == 1) {
                rightQualifier = CatalogUtil.extractQualifier((String)((ColumnReferenceExpr)foundColumns.iterator().next()).getCanonicalName());
            }
        }
        return !leftQualifier.equals(rightQualifier);
    }

    static boolean isSingleColumn(EvalNode evalNode) {
        return EvalTreeUtil.findUniqueColumns(evalNode).size() == 1;
    }

    public static Set<AggregationFunctionCallEval> findDistinctAggFunction(EvalNode expr) {
        AllAggFunctionFinder finder = new AllAggFunctionFinder();
        expr.postOrder(finder);
        return finder.getAggregationFunction();
    }

    public static Set<WindowFunctionEval> findWindowFunction(EvalNode expr) {
        AllWindowFunctionFinder finder = new AllWindowFunctionFinder();
        expr.postOrder(finder);
        return finder.getWindowFunctionSet();
    }

    public static <T extends EvalNode> Collection<T> findEvalsByType(EvalNode evalNode, EvalType type) {
        EvalFinder finder = new EvalFinder(type);
        finder.visitChild((Object)null, evalNode, new Stack<EvalNode>());
        return finder.evalNodes;
    }

    public static <T extends EvalNode> Collection<T> findOuterJoinSensitiveEvals(EvalNode evalNode) {
        OuterJoinSensitiveEvalFinder finder = new OuterJoinSensitiveEvalFinder();
        finder.visitChild((Object)null, evalNode, new Stack<EvalNode>());
        return finder.evalNodes;
    }

    public static boolean checkIfCanBeConstant(EvalNode evalNode) {
        return EvalTreeUtil.findUniqueColumns(evalNode).size() == 0 && EvalTreeUtil.findDistinctAggFunction(evalNode).size() == 0;
    }

    public static Datum evaluateImmediately(EvalNode evalNode) {
        return evalNode.eval(null, null);
    }

    public static class OuterJoinSensitiveEvalFinder
    extends BasicEvalNodeVisitor<Object, Object> {
        private List<EvalNode> evalNodes = TUtil.newList();

        @Override
        public Object visitChild(Object context, EvalNode evalNode, Stack<EvalNode> stack) {
            super.visitChild(context, evalNode, stack);
            if (evalNode.type == EvalType.CASE) {
                this.evalNodes.add(evalNode);
            } else if (evalNode.type == EvalType.FUNCTION) {
                FunctionEval functionEval = (FunctionEval)evalNode;
                if ("coalesce".equals(functionEval.getName())) {
                    this.evalNodes.add(evalNode);
                }
            } else if (evalNode.type == EvalType.IS_NULL) {
                this.evalNodes.add(evalNode);
            }
            return evalNode;
        }
    }

    public static class EvalFinder
    extends BasicEvalNodeVisitor<Object, Object> {
        private EvalType targetType;
        List<EvalNode> evalNodes = TUtil.newList();

        public EvalFinder(EvalType targetType) {
            this.targetType = targetType;
        }

        @Override
        public Object visitChild(Object context, EvalNode evalNode, Stack<EvalNode> stack) {
            super.visitChild(context, evalNode, stack);
            if (evalNode.type == this.targetType) {
                this.evalNodes.add(evalNode);
            }
            return evalNode;
        }
    }

    public static class AllWindowFunctionFinder
    implements EvalNodeVisitor {
        private Set<WindowFunctionEval> windowFunctions = Sets.newHashSet();

        @Override
        public void visit(EvalNode node) {
            if (node.getType() == EvalType.WINDOW_FUNCTION) {
                WindowFunctionEval field = (WindowFunctionEval)node;
                this.windowFunctions.add(field);
            }
        }

        public Set<WindowFunctionEval> getWindowFunctionSet() {
            return this.windowFunctions;
        }
    }

    public static class AllAggFunctionFinder
    implements EvalNodeVisitor {
        private Set<AggregationFunctionCallEval> aggFucntions = Sets.newHashSet();
        private AggregationFunctionCallEval field = null;

        @Override
        public void visit(EvalNode node) {
            if (node.getType() == EvalType.AGG_FUNCTION) {
                this.field = (AggregationFunctionCallEval)node;
                this.aggFucntions.add(this.field);
            }
        }

        public Set<AggregationFunctionCallEval> getAggregationFunction() {
            return this.aggFucntions;
        }
    }

    public static class VariableCounter
    implements EvalNodeVisitor {
        private final Map<EvalType, Integer> counter = Maps.newHashMap();

        public VariableCounter() {
            this.counter.put(EvalType.FUNCTION, 0);
            this.counter.put(EvalType.FIELD, 0);
        }

        @Override
        public void visit(EvalNode node) {
            if (this.counter.containsKey((Object)node.getType())) {
                int val = this.counter.get((Object)node.getType());
                this.counter.put(node.getType(), ++val);
            }
        }

        public Map<EvalType, Integer> getCounter() {
            return this.counter;
        }
    }

    public static class UniqueColumnFinder
    implements EvalNodeVisitor {
        private LinkedHashSet<Column> columnSet = Sets.newLinkedHashSet();
        private FieldEval field = null;

        @Override
        public void visit(EvalNode node) {
            if (node.getType() == EvalType.FIELD) {
                this.field = (FieldEval)node;
                this.columnSet.add(this.field.getColumnRef());
            }
        }

        public LinkedHashSet<Column> getColumnRefs() {
            return this.columnSet;
        }
    }

    public static class AllColumnRefFinder
    implements EvalNodeVisitor {
        private List<Column> colList = new ArrayList<Column>();
        private FieldEval field = null;

        @Override
        public void visit(EvalNode node) {
            if (node.getType() == EvalType.FIELD) {
                this.field = (FieldEval)node;
                this.colList.add(this.field.getColumnRef());
            }
        }

        public List<Column> getColumnRefs() {
            return this.colList;
        }
    }

    public static class ChangeColumnRefVisitor
    implements EvalNodeVisitor {
        private final String findColumn;
        private final String toBeChanged;

        public ChangeColumnRefVisitor(String oldName, String newName) {
            this.findColumn = oldName;
            this.toBeChanged = newName;
        }

        @Override
        public void visit(EvalNode node) {
            FieldEval field;
            if (node.type == EvalType.FIELD && ((field = (FieldEval)node).getColumnName().equals(this.findColumn) || field.getName().equals(this.findColumn))) {
                field.replaceColumnRef(this.toBeChanged);
            }
        }
    }

    public static class EvalReplaceVisitor
    extends BasicEvalNodeVisitor<ReplaceContext, EvalNode> {
        private EvalNode target;
        private EvalNode tobeReplaced;

        public EvalReplaceVisitor(EvalNode target, EvalNode tobeReplaced) {
            this.target = target;
            this.tobeReplaced = tobeReplaced;
        }

        @Override
        public EvalNode visitChild(ReplaceContext context, EvalNode evalNode, Stack<EvalNode> stack) {
            super.visitChild(context, evalNode, stack);
            if (evalNode.equals(this.target)) {
                ++context.countOfReplaces;
                EvalNode parent = stack.peek();
                if (parent instanceof BetweenPredicateEval) {
                    BetweenPredicateEval between = (BetweenPredicateEval)parent;
                    if (between.getPredicand().equals(evalNode)) {
                        between.setPredicand(this.tobeReplaced);
                    }
                    if (between.getBegin().equals(evalNode)) {
                        between.setBegin(this.tobeReplaced);
                    }
                    if (between.getEnd().equals(evalNode)) {
                        between.setEnd(this.tobeReplaced);
                    }
                } else if (parent instanceof CaseWhenEval) {
                    CaseWhenEval caseWhen = (CaseWhenEval)parent;
                    if (caseWhen.hasElse() && caseWhen.getElse().equals(evalNode)) {
                        caseWhen.setElseResult(this.tobeReplaced);
                    }
                } else if (parent instanceof CaseWhenEval.IfThenEval) {
                    CaseWhenEval.IfThenEval ifThen = (CaseWhenEval.IfThenEval)parent;
                    if (ifThen.getCondition().equals(evalNode)) {
                        ifThen.setCondition(this.tobeReplaced);
                    }
                    if (ifThen.getResult().equals(evalNode)) {
                        ifThen.setResult(this.tobeReplaced);
                    }
                } else if (parent instanceof FunctionEval) {
                    FunctionEval functionEval = (FunctionEval)parent;
                    EvalNode[] arguments = functionEval.getArgs();
                    for (int i = 0; i < arguments.length; ++i) {
                        if (!arguments[i].equals(evalNode)) continue;
                        arguments[i] = this.tobeReplaced;
                    }
                    functionEval.setArgs(arguments);
                } else if (parent instanceof UnaryEval) {
                    if (((UnaryEval)parent).getChild().equals(evalNode)) {
                        ((UnaryEval)parent).setChild(this.tobeReplaced);
                    }
                } else if (parent instanceof BinaryEval) {
                    BinaryEval binary = (BinaryEval)parent;
                    if (binary.getLeftExpr() != null && binary.getLeftExpr().equals(evalNode)) {
                        binary.setLeftExpr(this.tobeReplaced);
                    }
                    if (binary.getRightExpr() != null && binary.getRightExpr().equals(evalNode)) {
                        binary.setRightExpr(this.tobeReplaced);
                    }
                }
            }
            return evalNode;
        }
    }

    private static class ReplaceContext {
        int countOfReplaces = 0;

        private ReplaceContext() {
        }
    }
}

