/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.gson.annotations.Expose;
import java.util.TimeZone;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.UnaryEval;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.TUtil;

public class CastEval
extends UnaryEval {
    @Expose
    private TajoDataTypes.DataType target;
    @Expose
    private TimeZone timezone;

    public CastEval(OverridableConf context, EvalNode operand, TajoDataTypes.DataType target) {
        super(EvalType.CAST, operand);
        this.target = target;
        if (context.containsKey((ConfigKey)SessionVars.TIMEZONE)) {
            String timezoneId = context.get((ConfigKey)SessionVars.TIMEZONE);
            this.timezone = TimeZone.getTimeZone(timezoneId);
        }
    }

    public EvalNode getOperand() {
        return this.child;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return this.target;
    }

    public boolean hasTimeZone() {
        return this.timezone != null;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    @Override
    public String getName() {
        return this.target.getType().name();
    }

    public Datum eval(Schema schema, Tuple tuple) {
        Object operandDatum = this.child.eval(schema, tuple);
        if (operandDatum.isNull()) {
            return operandDatum;
        }
        return DatumFactory.cast(operandDatum, (TajoDataTypes.DataType)this.target, (TimeZone)this.timezone);
    }

    public String toString() {
        return "CAST (" + this.child + " AS " + this.target.getType() + ")";
    }

    @Override
    public boolean equals(Object obj) {
        boolean valid;
        boolean bl = valid = obj != null && obj instanceof CastEval;
        if (valid) {
            CastEval another = (CastEval)obj;
            return this.child.equals(another.child) && this.target.equals((Object)another.target) && TUtil.checkEquals((Object)this.timezone, (Object)another.timezone);
        }
        return false;
    }
}

