/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.serder.PlanGsonHelper;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.TUtil;

public class CaseWhenEval
extends EvalNode
implements GsonObject {
    @Expose
    private List<IfThenEval> whens = Lists.newArrayList();
    @Expose
    private EvalNode elseResult;

    public CaseWhenEval() {
        super(EvalType.CASE);
    }

    public void addIfCond(IfThenEval ifCond) {
        this.whens.add(ifCond);
    }

    public void addIfCond(EvalNode condition, EvalNode result) {
        this.whens.add(new IfThenEval(condition, result));
    }

    public List<IfThenEval> getIfThenEvals() {
        return this.whens;
    }

    public boolean hasElse() {
        return this.elseResult != null;
    }

    public EvalNode getElse() {
        return this.elseResult;
    }

    public void setElseResult(EvalNode elseResult) {
        this.elseResult = elseResult;
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        for (IfThenEval eachWhen : this.whens) {
            if (eachWhen.getResult().getValueType().getType() == TajoDataTypes.Type.NULL_TYPE) continue;
            return eachWhen.getResult().getValueType();
        }
        if (this.elseResult != null) {
            return this.elseResult.getValueType();
        }
        return NullDatum.getDataType();
    }

    @Override
    public int childNum() {
        return this.whens.size() + (this.elseResult != null ? 1 : 0);
    }

    @Override
    public EvalNode getChild(int idx) {
        if (idx < this.whens.size()) {
            return this.whens.get(idx);
        }
        if (idx == this.whens.size()) {
            return this.elseResult;
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    @Override
    public String getName() {
        return "?";
    }

    public Datum eval(Schema schema, Tuple tuple) {
        for (int i = 0; i < this.whens.size(); ++i) {
            if (!this.whens.get(i).checkIfCondition(schema, tuple)) continue;
            return this.whens.get(i).eval(schema, tuple);
        }
        if (this.elseResult != null) {
            return this.elseResult.eval(schema, tuple);
        }
        return NullDatum.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CASE ");
        for (IfThenEval when : this.whens) {
            sb.append(when).append(" ");
        }
        sb.append("ELSE ").append(this.elseResult).append(" END");
        return sb.toString();
    }

    @Override
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
        for (IfThenEval when : this.whens) {
            when.preOrder(visitor);
        }
        if (this.elseResult != null) {
            this.elseResult.preOrder(visitor);
        }
    }

    @Override
    public void postOrder(EvalNodeVisitor visitor) {
        for (IfThenEval when : this.whens) {
            when.postOrder(visitor);
        }
        if (this.elseResult != null) {
            this.elseResult.postOrder(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CaseWhenEval caseWhenEval = (CaseWhenEval)super.clone();
        caseWhenEval.whens = new ArrayList<IfThenEval>();
        for (IfThenEval ifThenEval : this.whens) {
            caseWhenEval.whens.add((IfThenEval)ifThenEval.clone());
        }
        caseWhenEval.elseResult = this.elseResult;
        return caseWhenEval;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CaseWhenEval) {
            CaseWhenEval other = (CaseWhenEval)obj;
            for (int i = 0; i < other.whens.size(); ++i) {
                if (this.whens.get(i).equals(other.whens.get(i))) continue;
                return false;
            }
            return TUtil.checkEquals((Object)this.elseResult, (Object)other.elseResult);
        }
        return false;
    }

    public static class IfThenEval
    extends EvalNode
    implements GsonObject {
        @Expose
        private EvalNode condition;
        @Expose
        private EvalNode result;

        public IfThenEval(EvalNode condition, EvalNode result) {
            super(EvalType.IF_THEN);
            this.condition = condition;
            this.result = result;
        }

        @Override
        public TajoDataTypes.DataType getValueType() {
            return CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
        }

        @Override
        public int childNum() {
            return 2;
        }

        @Override
        public EvalNode getChild(int idx) {
            if (idx == 0) {
                return this.condition;
            }
            if (idx == 1) {
                return this.result;
            }
            throw new ArrayIndexOutOfBoundsException(idx);
        }

        @Override
        public String getName() {
            return "when?";
        }

        public boolean checkIfCondition(Schema schema, Tuple tuple) {
            return this.condition.eval(schema, tuple).isTrue();
        }

        public Datum eval(Schema schema, Tuple tuple) {
            return this.result.eval(schema, tuple);
        }

        public void setCondition(EvalNode condition) {
            this.condition = condition;
        }

        public EvalNode getCondition() {
            return this.condition;
        }

        public void setResult(EvalNode result) {
            this.result = result;
        }

        public EvalNode getResult() {
            return this.result;
        }

        public boolean equals(Object object) {
            if (object instanceof IfThenEval) {
                IfThenEval other = (IfThenEval)object;
                return this.condition.equals(other.condition) && this.result.equals(other.result);
            }
            return false;
        }

        public String toString() {
            return "WHEN " + this.condition + " THEN " + this.result;
        }

        @Override
        public String toJson() {
            return PlanGsonHelper.toJson(this, IfThenEval.class);
        }

        @Override
        public void preOrder(EvalNodeVisitor visitor) {
            visitor.visit(this);
            this.condition.preOrder(visitor);
            this.result.preOrder(visitor);
        }

        @Override
        public void postOrder(EvalNodeVisitor visitor) {
            this.condition.postOrder(visitor);
            this.result.postOrder(visitor);
            visitor.visit(this);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            IfThenEval ifThenEval = (IfThenEval)super.clone();
            ifThenEval.condition = (EvalNode)this.condition.clone();
            ifThenEval.result = (EvalNode)this.result.clone();
            return ifThenEval;
        }
    }
}

