/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.DataTypeUtil;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.PartialBinaryExpr;
import org.apache.tajo.storage.Tuple;

public class BinaryEval
extends EvalNode
implements Cloneable {
    @Expose
    protected EvalNode leftExpr;
    @Expose
    protected EvalNode rightExpr;
    @Expose
    protected TajoDataTypes.DataType returnType;

    protected BinaryEval(EvalType type) {
        super(type);
    }

    public BinaryEval(EvalType type, EvalNode left, EvalNode right) {
        super(type);
        this.leftExpr = left;
        this.rightExpr = right;
        if (type == EvalType.AND || type == EvalType.OR || type == EvalType.EQUAL || type == EvalType.NOT_EQUAL || type == EvalType.LTH || type == EvalType.GTH || type == EvalType.LEQ || type == EvalType.GEQ) {
            this.returnType = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.BOOLEAN);
        } else if (type == EvalType.PLUS || type == EvalType.MINUS || type == EvalType.MULTIPLY || type == EvalType.DIVIDE || type == EvalType.MODULAR) {
            this.returnType = DataTypeUtil.determineType((TajoDataTypes.DataType)left.getValueType(), (TajoDataTypes.DataType)right.getValueType());
        } else if (type == EvalType.CONCATENATE) {
            this.returnType = CatalogUtil.newSimpleDataType((TajoDataTypes.Type)TajoDataTypes.Type.TEXT);
        }
    }

    public BinaryEval(PartialBinaryExpr expr) {
        this(expr.type, expr.leftExpr, expr.rightExpr);
    }

    public void setLeftExpr(EvalNode expr) {
        this.leftExpr = expr;
    }

    public <T extends EvalNode> T getLeftExpr() {
        return (T)this.leftExpr;
    }

    public void setRightExpr(EvalNode expr) {
        this.rightExpr = expr;
    }

    public <T extends EvalNode> T getRightExpr() {
        return (T)this.rightExpr;
    }

    @Override
    public int childNum() {
        return 2;
    }

    @Override
    public EvalNode getChild(int id) {
        if (id == 0) {
            return this.leftExpr;
        }
        if (id == 1) {
            return this.rightExpr;
        }
        throw new ArrayIndexOutOfBoundsException("only 0 or 1 is available, but (" + id + ") is not available)");
    }

    public void setChild(int id, EvalNode child) {
        if (id == 0) {
            this.leftExpr = child;
        } else if (id == 1) {
            this.rightExpr = child;
        } else {
            throw new ArrayIndexOutOfBoundsException("only 0 or 1 is available, but (" + id + ") is not available)");
        }
    }

    public Datum eval(Schema schema, Tuple tuple) {
        Object lhs = this.leftExpr.eval(schema, tuple);
        Object rhs = this.rightExpr.eval(schema, tuple);
        switch (this.type) {
            case AND: {
                return lhs.and(rhs);
            }
            case OR: {
                return lhs.or(rhs);
            }
            case EQUAL: {
                return lhs.equalsTo(rhs);
            }
            case NOT_EQUAL: {
                return lhs.notEqualsTo(rhs);
            }
            case LTH: {
                return lhs.lessThan(rhs);
            }
            case LEQ: {
                return lhs.lessThanEqual(rhs);
            }
            case GTH: {
                return lhs.greaterThan(rhs);
            }
            case GEQ: {
                return lhs.greaterThanEqual(rhs);
            }
            case PLUS: {
                return lhs.plus(rhs);
            }
            case MINUS: {
                return lhs.minus(rhs);
            }
            case MULTIPLY: {
                return lhs.multiply(rhs);
            }
            case DIVIDE: {
                return lhs.divide(rhs);
            }
            case MODULAR: {
                return lhs.modular(rhs);
            }
            case CONCATENATE: {
                if (lhs.type() == TajoDataTypes.Type.NULL_TYPE || rhs.type() == TajoDataTypes.Type.NULL_TYPE) {
                    return NullDatum.get();
                }
                return DatumFactory.createText((String)(lhs.asChars() + rhs.asChars()));
            }
        }
        throw new InvalidOperationException("Unknown binary operation: " + (Object)((Object)this.type));
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public TajoDataTypes.DataType getValueType() {
        return this.returnType;
    }

    @Override
    @Deprecated
    public void preOrder(EvalNodeVisitor visitor) {
        visitor.visit(this);
        this.leftExpr.preOrder(visitor);
        this.rightExpr.preOrder(visitor);
    }

    @Override
    @Deprecated
    public void postOrder(EvalNodeVisitor visitor) {
        this.leftExpr.postOrder(visitor);
        this.rightExpr.postOrder(visitor);
        visitor.visit(this);
    }

    public String toString() {
        return this.leftExpr + " " + this.type.getOperatorName() + " " + this.rightExpr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinaryEval) {
            BinaryEval other = (BinaryEval)obj;
            boolean b1 = this.type == other.type;
            boolean b2 = this.leftExpr.equals(other.leftExpr);
            boolean b3 = this.rightExpr.equals(other.rightExpr);
            return b1 && b2 && b3;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.leftExpr, this.rightExpr});
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BinaryEval node = (BinaryEval)super.clone();
        node.type = this.type;
        node.leftExpr = this.leftExpr != null ? (EvalNode)this.leftExpr.clone() : null;
        node.rightExpr = this.rightExpr != null ? (EvalNode)this.rightExpr.clone() : null;
        return node;
    }
}

