/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.plan.expr.AlgebraicException;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeFactory;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FunctionEval;
import org.apache.tajo.plan.expr.LikePredicateEval;
import org.apache.tajo.plan.expr.PartialBinaryExpr;
import org.apache.tajo.plan.expr.SimpleEvalNodeVisitor;
import org.apache.tajo.plan.expr.UnaryEval;

public class AlgebraicUtil {
    private static final AlgebraicOptimizer algebraicOptimizer = new AlgebraicOptimizer();

    public static EvalNode transpose(EvalNode evalNode, Column target) {
        if (evalNode instanceof BinaryEval) {
            BinaryEval commutated;
            BinaryEval binaryEval = (BinaryEval)evalNode;
            if (!EvalTreeUtil.containColumnRef(binaryEval.getLeftExpr(), target)) {
                commutated = AlgebraicUtil.commutate(binaryEval);
            } else {
                try {
                    commutated = (BinaryEval)evalNode.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new AlgebraicException(e);
                }
            }
            return AlgebraicUtil._transpose(commutated, target);
        }
        return evalNode;
    }

    private static EvalNode _transpose(BinaryEval _expr, Column target) {
        EvalNode expr = AlgebraicUtil.eliminateConstantExprs(_expr);
        if (expr instanceof BinaryEval) {
            BinaryEval binaryEval = (BinaryEval)expr;
            if (AlgebraicUtil.isSingleVar(binaryEval.getLeftExpr())) {
                return expr;
            }
            Object left = binaryEval.getLeftExpr();
            EvalNode lTerm = null;
            BinaryEval rTerm = null;
            if (EvalType.isArithmeticOperator(((EvalNode)left).getType())) {
                if (EvalTreeUtil.containColumnRef(((BinaryEval)left).getLeftExpr(), target)) {
                    PartialBinaryExpr tmpTerm = AlgebraicUtil.splitRightTerm((BinaryEval)left);
                    tmpTerm.type = AlgebraicUtil.inverseOperator(tmpTerm.type);
                    tmpTerm.setLeftExpr((EvalNode)((BinaryEval)expr).getRightExpr());
                    lTerm = (EvalNode)((BinaryEval)left).getLeftExpr();
                    rTerm = new BinaryEval(tmpTerm);
                } else {
                    PartialBinaryExpr tmpTerm = AlgebraicUtil.splitLeftTerm((BinaryEval)left);
                    tmpTerm.type = AlgebraicUtil.inverseOperator(tmpTerm.type);
                    tmpTerm.setLeftExpr((EvalNode)((BinaryEval)expr).getRightExpr());
                    lTerm = (EvalNode)((BinaryEval)left).getRightExpr();
                    rTerm = new BinaryEval(tmpTerm);
                }
            }
            return AlgebraicUtil._transpose(new BinaryEval(expr.getType(), lTerm, rTerm), target);
        }
        return _expr;
    }

    public static EvalType inverseOperator(EvalType type) {
        switch (type) {
            case PLUS: {
                return EvalType.MINUS;
            }
            case MINUS: {
                return EvalType.PLUS;
            }
            case MULTIPLY: {
                return EvalType.DIVIDE;
            }
            case DIVIDE: {
                return EvalType.MULTIPLY;
            }
        }
        throw new AlgebraicException("ERROR: cannot inverse the operator: " + (Object)((Object)type));
    }

    private static boolean isSingleVar(EvalNode node) {
        return node.getType() == EvalType.FIELD;
    }

    public static EvalNode eliminateConstantExprs(EvalNode expr) {
        return algebraicOptimizer.visit(null, expr, new Stack<EvalNode>());
    }

    public static boolean containSingleVar(EvalNode expr) {
        Map<EvalType, Integer> counter = EvalTreeUtil.getExprCounters(expr);
        int sum = 0;
        for (Integer cnt : counter.values()) {
            sum += cnt.intValue();
        }
        return sum == 1 && counter.get((Object)EvalType.FIELD) == 1;
    }

    public static PartialBinaryExpr splitLeftTerm(BinaryEval binary) {
        if (!EvalType.isArithmeticOperator(binary.getType())) {
            throw new AlgebraicException("Invalid algebraic operation: " + binary);
        }
        if (binary.getLeftExpr() instanceof BinaryEval) {
            return AlgebraicUtil.splitLeftTerm((BinaryEval)binary.getLeftExpr());
        }
        PartialBinaryExpr splitted = new PartialBinaryExpr(binary.getType(), null, (EvalNode)binary.getLeftExpr());
        binary.setLeftExpr(null);
        return splitted;
    }

    public static PartialBinaryExpr splitRightTerm(BinaryEval binary) {
        if (!EvalType.isArithmeticOperator(binary.getType())) {
            throw new AlgebraicException("Invalid algebraic operation: " + binary);
        }
        if (binary.getRightExpr() instanceof BinaryEval) {
            return AlgebraicUtil.splitRightTerm((BinaryEval)binary.getRightExpr());
        }
        PartialBinaryExpr splitted = new PartialBinaryExpr(binary.getType(), null, (EvalNode)binary.getRightExpr());
        binary.setRightExpr(null);
        return splitted;
    }

    public static BinaryEval commutate(BinaryEval inputExpr) {
        BinaryEval rewritten;
        switch (inputExpr.getType()) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case AND: 
            case OR: 
            case EQUAL: {
                rewritten = EvalTreeFactory.create(inputExpr.getType(), inputExpr.getRightExpr(), inputExpr.getLeftExpr());
                break;
            }
            case GTH: {
                rewritten = EvalTreeFactory.create(EvalType.LTH, inputExpr.getRightExpr(), inputExpr.getLeftExpr());
                break;
            }
            case GEQ: {
                rewritten = EvalTreeFactory.create(EvalType.LEQ, inputExpr.getRightExpr(), inputExpr.getLeftExpr());
                break;
            }
            case LTH: {
                rewritten = EvalTreeFactory.create(EvalType.GTH, inputExpr.getRightExpr(), inputExpr.getLeftExpr());
                break;
            }
            case LEQ: {
                rewritten = EvalTreeFactory.create(EvalType.GEQ, inputExpr.getRightExpr(), inputExpr.getLeftExpr());
                break;
            }
            default: {
                throw new AlgebraicException("Cannot commutate the expr: " + inputExpr);
            }
        }
        return rewritten;
    }

    public static boolean isIndexableOperator(EvalNode expr) {
        return expr.getType() == EvalType.EQUAL || expr.getType() == EvalType.LEQ || expr.getType() == EvalType.LTH || expr.getType() == EvalType.GEQ || expr.getType() == EvalType.GTH || expr.getType() == EvalType.BETWEEN || expr.getType() == EvalType.IN || expr.getType() == EvalType.LIKE && !((LikePredicateEval)expr).isLeadingWildCard();
    }

    public static EvalNode createSingletonExprFromCNF(EvalNode ... cnfExprs) {
        if (cnfExprs.length == 1) {
            return cnfExprs[0];
        }
        return AlgebraicUtil.createSingletonExprFromCNFRecursive(cnfExprs, 0);
    }

    private static EvalNode createSingletonExprFromCNFRecursive(EvalNode[] evalNode, int idx) {
        if (idx == evalNode.length - 2) {
            return new BinaryEval(EvalType.AND, evalNode[idx], evalNode[idx + 1]);
        }
        return new BinaryEval(EvalType.AND, evalNode[idx], AlgebraicUtil.createSingletonExprFromCNFRecursive(evalNode, idx + 1));
    }

    public static EvalNode[] toConjunctiveNormalFormArray(EvalNode expr) {
        ArrayList<EvalNode> list = new ArrayList<EvalNode>();
        AlgebraicUtil.toConjunctiveNormalFormArrayRecursive(expr, list);
        return list.toArray(new EvalNode[list.size()]);
    }

    private static void toConjunctiveNormalFormArrayRecursive(EvalNode node, List<EvalNode> found) {
        if (node.getType() == EvalType.AND) {
            AlgebraicUtil.toConjunctiveNormalFormArrayRecursive(((BinaryEval)node).getLeftExpr(), found);
            AlgebraicUtil.toConjunctiveNormalFormArrayRecursive(((BinaryEval)node).getRightExpr(), found);
        } else {
            found.add(node);
        }
    }

    public static EvalNode createSingletonExprFromDNF(EvalNode ... cnfExprs) {
        if (cnfExprs.length == 1) {
            return cnfExprs[0];
        }
        return AlgebraicUtil.createSingletonExprFromDNFRecursive(cnfExprs, 0);
    }

    private static EvalNode createSingletonExprFromDNFRecursive(EvalNode[] evalNode, int idx) {
        if (idx == evalNode.length - 2) {
            return new BinaryEval(EvalType.OR, evalNode[idx], evalNode[idx + 1]);
        }
        return new BinaryEval(EvalType.OR, evalNode[idx], AlgebraicUtil.createSingletonExprFromDNFRecursive(evalNode, idx + 1));
    }

    public static EvalNode[] toDisjunctiveNormalFormArray(EvalNode ... exprs) {
        ArrayList<EvalNode> list = new ArrayList<EvalNode>();
        for (EvalNode expr : exprs) {
            AlgebraicUtil.toDisjunctiveNormalFormArrayRecursive(expr, list);
        }
        return list.toArray(new EvalNode[list.size()]);
    }

    private static void toDisjunctiveNormalFormArrayRecursive(EvalNode node, List<EvalNode> found) {
        if (node.getType() == EvalType.OR) {
            AlgebraicUtil.toDisjunctiveNormalFormArrayRecursive(((BinaryEval)node).getLeftExpr(), found);
            AlgebraicUtil.toDisjunctiveNormalFormArrayRecursive(((BinaryEval)node).getRightExpr(), found);
        } else {
            found.add(node);
        }
    }

    private static class AlgebraicOptimizer
    extends SimpleEvalNodeVisitor<Object> {
        private AlgebraicOptimizer() {
        }

        @Override
        public EvalNode visitBinaryEval(Object context, Stack<EvalNode> stack, BinaryEval binaryEval) {
            stack.push(binaryEval);
            EvalNode lhs = this.visit(context, (EvalNode)binaryEval.getLeftExpr(), stack);
            EvalNode rhs = this.visit(context, (EvalNode)binaryEval.getRightExpr(), stack);
            stack.pop();
            if (!binaryEval.getLeftExpr().equals(lhs)) {
                binaryEval.setLeftExpr(lhs);
            }
            if (!binaryEval.getRightExpr().equals(rhs)) {
                binaryEval.setRightExpr(rhs);
            }
            if (lhs.getType() == EvalType.CONST && rhs.getType() == EvalType.CONST) {
                return new ConstEval(binaryEval.eval(null, null));
            }
            return binaryEval;
        }

        @Override
        public EvalNode visitUnaryEval(Object context, Stack<EvalNode> stack, UnaryEval unaryEval) {
            stack.push(unaryEval);
            EvalNode child = this.visit(context, unaryEval.getChild(), stack);
            stack.pop();
            if (child.getType() == EvalType.CONST) {
                return new ConstEval((Datum)unaryEval.eval(null, null));
            }
            return unaryEval;
        }

        @Override
        public EvalNode visitFuncCall(Object context, FunctionEval evalNode, Stack<EvalNode> stack) {
            boolean constantOfAllDescendents = true;
            if ("sleep".equals(evalNode.funcDesc.getFunctionName())) {
                constantOfAllDescendents = false;
            } else if (evalNode.getArgs() != null) {
                for (EvalNode arg : evalNode.getArgs()) {
                    constantOfAllDescendents &= (arg = this.visit(context, arg, stack)).getType() == EvalType.CONST;
                }
            }
            if (constantOfAllDescendents && evalNode.getType() == EvalType.FUNCTION) {
                return new ConstEval(evalNode.eval(null, null));
            }
            return evalNode;
        }
    }
}

