/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.plan.logical.LogicalNode;

public class PlanString {
    final StringBuilder title;
    final List<String> explanations = new ArrayList<String>();
    final List<String> details = new ArrayList<String>();
    StringBuilder currentExplanation;
    StringBuilder currentDetail;

    public PlanString(LogicalNode node) {
        this.title = new StringBuilder(node.getType().name() + "(" + node.getPID() + ")");
    }

    public PlanString(String title) {
        this.title = new StringBuilder(title);
    }

    public PlanString appendTitle(String str) {
        this.title.append(str);
        return this;
    }

    public PlanString addExplan(String explain) {
        this.flushCurrentExplanation();
        this.currentExplanation = new StringBuilder(explain);
        return this;
    }

    public PlanString appendExplain(String explain) {
        if (this.currentExplanation == null) {
            this.currentExplanation = new StringBuilder();
        }
        this.currentExplanation.append(explain);
        return this;
    }

    public PlanString addDetail(String detail) {
        this.flushCurrentDetail();
        this.currentDetail = new StringBuilder(detail);
        return this;
    }

    public PlanString appendDetail(String detail) {
        if (this.currentDetail == null) {
            this.currentDetail = new StringBuilder();
        }
        this.currentDetail.append(detail);
        return this;
    }

    public String getTitle() {
        return this.title.toString();
    }

    public List<String> getExplanations() {
        this.flushCurrentExplanation();
        return this.explanations;
    }

    public List<String> getDetails() {
        this.flushCurrentDetail();
        return this.details;
    }

    private void flushCurrentExplanation() {
        if (this.currentExplanation != null) {
            this.explanations.add(this.currentExplanation.toString());
            this.currentExplanation = null;
        }
    }

    private void flushCurrentDetail() {
        if (this.currentDetail != null) {
            this.details.add(this.currentDetail.toString());
            this.currentDetail = null;
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append(this.getTitle()).append("\n");
        for (String str : this.getExplanations()) {
            output.append("  => ").append(str).append("\n");
        }
        for (String str : this.getDetails()) {
            output.append("  => ").append(str).append("\n");
        }
        return output.toString();
    }
}

