/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.SessionVars;
import org.apache.tajo.algebra.Aggregation;
import org.apache.tajo.algebra.AlterTable;
import org.apache.tajo.algebra.AlterTablespace;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.CreateDatabase;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.DropDatabase;
import org.apache.tajo.algebra.DropTable;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.Having;
import org.apache.tajo.algebra.Insert;
import org.apache.tajo.algebra.Join;
import org.apache.tajo.algebra.Limit;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.Projection;
import org.apache.tajo.algebra.QualifiedAsteriskExpr;
import org.apache.tajo.algebra.Relation;
import org.apache.tajo.algebra.Selection;
import org.apache.tajo.algebra.SetOperation;
import org.apache.tajo.algebra.SetSession;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.algebra.TablePrimarySubQuery;
import org.apache.tajo.algebra.TruncateTable;
import org.apache.tajo.catalog.CatalogService;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.exception.NoSuchColumnException;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.plan.ExprAnnotator;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.LogicalPlanner;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.TypeDeterminant;
import org.apache.tajo.plan.algebra.BaseAlgebraVisitor;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.logical.AlterTableNode;
import org.apache.tajo.plan.logical.AlterTablespaceNode;
import org.apache.tajo.plan.logical.CreateDatabaseNode;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.DropDatabaseNode;
import org.apache.tajo.plan.logical.DropTableNode;
import org.apache.tajo.plan.logical.EvalExprNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SetSessionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.TruncateTableNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.nameresolver.NameResolver;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.plan.visitor.SimpleAlgebraVisitor;
import org.apache.tajo.util.TUtil;

public class LogicalPlanPreprocessor
extends BaseAlgebraVisitor<LogicalPlanner.PlanContext, LogicalNode> {
    private TypeDeterminant typeDeterminant;
    private ExprAnnotator annotator;
    private CatalogService catalog;

    LogicalPlanPreprocessor(CatalogService catalog, ExprAnnotator annotator) {
        this.catalog = catalog;
        this.annotator = annotator;
        this.typeDeterminant = new TypeDeterminant(catalog);
    }

    @Override
    public void preHook(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Expr expr) throws PlanningException {
        ctx.queryBlock.setAlgebraicExpr(expr);
        ctx.plan.mapExprToBlock(expr, ctx.queryBlock.getName());
    }

    @Override
    public LogicalNode postHook(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Expr expr, LogicalNode result) throws PlanningException {
        if (result != null) {
            ctx.queryBlock.registerNode(result);
            ctx.queryBlock.registerExprWithNode(expr, result);
        }
        return result;
    }

    public static Column[] getColumns(LogicalPlanner.PlanContext ctx, QualifiedAsteriskExpr asteriskExpr) throws PlanningException {
        RelationNode relationOp = null;
        LogicalPlan.QueryBlock block = ctx.queryBlock;
        Collection<LogicalPlan.QueryBlock> queryBlocks = ctx.plan.getQueryBlocks();
        if (asteriskExpr.hasQualifier()) {
            String qualifier = CatalogUtil.isFQTableName((String)asteriskExpr.getQualifier()) ? asteriskExpr.getQualifier() : CatalogUtil.buildFQName((String[])new String[]{ctx.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), asteriskExpr.getQualifier()});
            relationOp = block.getRelation(qualifier);
            if (relationOp == null) {
                for (LogicalPlan.QueryBlock eachBlock : queryBlocks) {
                    if (!eachBlock.existsRelation(qualifier)) continue;
                    relationOp = eachBlock.getRelation(qualifier);
                }
            }
            if (relationOp == null) {
                throw new NoSuchColumnException(CatalogUtil.buildFQName((String[])new String[]{qualifier, "*"}));
            }
            Schema schema = relationOp.getLogicalSchema();
            Column[] resolvedColumns = new Column[schema.size()];
            return schema.getColumns().toArray(resolvedColumns);
        }
        Iterator<RelationNode> iterator = block.getRelations().iterator();
        List resolvedColumns = TUtil.newList();
        while (iterator.hasNext()) {
            relationOp = iterator.next();
            Schema schema = relationOp.getLogicalSchema();
            resolvedColumns.addAll(schema.getColumns());
        }
        if (resolvedColumns.size() == 0) {
            throw new NoSuchColumnException(asteriskExpr.toString());
        }
        return resolvedColumns.toArray(new Column[resolvedColumns.size()]);
    }

    private static List<NamedExpr> resolveAsterisk(LogicalPlanner.PlanContext ctx, QualifiedAsteriskExpr asteriskExpr) throws PlanningException {
        Column[] columns = LogicalPlanPreprocessor.getColumns(ctx, asteriskExpr);
        ArrayList<NamedExpr> newTargetExprs = new ArrayList<NamedExpr>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            newTargetExprs.add(new NamedExpr((Expr)new ColumnReferenceExpr(columns[i].getQualifier(), columns[i].getSimpleName())));
        }
        return newTargetExprs;
    }

    private static boolean hasAsterisk(NamedExpr[] namedExprs) {
        for (NamedExpr eachTarget : namedExprs) {
            if (eachTarget.getExpr().getType() != OpType.Asterisk) continue;
            return true;
        }
        return false;
    }

    private static NamedExpr[] voidResolveAsteriskNamedExpr(LogicalPlanner.PlanContext context, NamedExpr[] namedExprs) throws PlanningException {
        List rewrittenTargets = TUtil.newList();
        for (NamedExpr originTarget : namedExprs) {
            if (originTarget.getExpr().getType() == OpType.Asterisk) {
                rewrittenTargets.addAll(LogicalPlanPreprocessor.resolveAsterisk(context, (QualifiedAsteriskExpr)originTarget.getExpr()));
                continue;
            }
            rewrittenTargets.add(originTarget);
        }
        return rewrittenTargets.toArray(new NamedExpr[rewrittenTargets.size()]);
    }

    @Override
    public LogicalNode visitSetSession(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, SetSession expr) throws PlanningException {
        SetSessionNode setSession = ctx.plan.createNode(SetSessionNode.class);
        return setSession;
    }

    @Override
    public LogicalNode visitProjection(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Projection expr) throws PlanningException {
        if (!expr.hasChild()) {
            EvalExprNode exprNode = ctx.plan.createNode(EvalExprNode.class);
            exprNode.setTargets(this.buildTargets(ctx, expr.getNamedExprs()));
            return exprNode;
        }
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(ctx, stack, expr.getChild());
        if (LogicalPlanPreprocessor.hasAsterisk(expr.getNamedExprs())) {
            expr.setNamedExprs(LogicalPlanPreprocessor.voidResolveAsteriskNamedExpr(ctx, expr.getNamedExprs()));
        }
        NamedExpr[] projectTargetExprs = expr.getNamedExprs();
        for (int i = 0; i < expr.getNamedExprs().length; ++i) {
            NamedExpr namedExpr = projectTargetExprs[i];
            NameRefInSelectListNormalizer.normalize(ctx, namedExpr.getExpr());
            if (namedExpr.getExpr().getType() == OpType.Column && namedExpr.hasAlias()) {
                ctx.queryBlock.addColumnAlias(((ColumnReferenceExpr)namedExpr.getExpr()).getCanonicalName(), namedExpr.getAlias());
                continue;
            }
            if (!OpType.isLiteralType((OpType)namedExpr.getExpr().getType()) || !namedExpr.hasAlias()) continue;
            Expr constExpr = namedExpr.getExpr();
            ConstEval constEval = (ConstEval)this.annotator.createEvalNode(ctx, constExpr, NameResolvingMode.RELS_ONLY);
            ctx.queryBlock.addConstReference(namedExpr.getAlias(), constExpr, constEval);
        }
        Target[] targets = this.buildTargets(ctx, expr.getNamedExprs());
        stack.pop();
        ProjectionNode projectionNode = ctx.plan.createNode(ProjectionNode.class);
        projectionNode.setInSchema(child.getOutSchema());
        projectionNode.setOutSchema(PlannerUtil.targetToSchema(targets));
        ctx.queryBlock.setSchema(projectionNode.getOutSchema());
        return projectionNode;
    }

    private Target[] buildTargets(LogicalPlanner.PlanContext context, NamedExpr[] exprs) throws PlanningException {
        Target[] targets = new Target[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            NamedExpr namedExpr = exprs[i];
            TajoDataTypes.DataType dataType = this.typeDeterminant.determineDataType(context, namedExpr.getExpr());
            if (namedExpr.hasAlias()) {
                targets[i] = new Target(new FieldEval(new Column(namedExpr.getAlias(), dataType)));
                continue;
            }
            String generatedName = context.plan.generateUniqueColumnName(namedExpr.getExpr());
            targets[i] = new Target(new FieldEval(new Column(generatedName, dataType)));
        }
        return targets;
    }

    @Override
    public LogicalNode visitLimit(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Limit expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(ctx, stack, expr.getChild());
        stack.pop();
        LimitNode limitNode = ctx.plan.createNode(LimitNode.class);
        limitNode.setInSchema(child.getOutSchema());
        limitNode.setOutSchema(child.getOutSchema());
        return limitNode;
    }

    @Override
    public LogicalNode visitSort(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Sort expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(ctx, stack, expr.getChild());
        stack.pop();
        SortNode sortNode = ctx.plan.createNode(SortNode.class);
        sortNode.setInSchema(child.getOutSchema());
        sortNode.setOutSchema(child.getOutSchema());
        return sortNode;
    }

    @Override
    public LogicalNode visitHaving(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Having expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(ctx, stack, expr.getChild());
        stack.pop();
        HavingNode havingNode = ctx.plan.createNode(HavingNode.class);
        havingNode.setInSchema(child.getOutSchema());
        havingNode.setOutSchema(child.getOutSchema());
        return havingNode;
    }

    @Override
    public LogicalNode visitGroupBy(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Aggregation expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(ctx, stack, expr.getChild());
        Projection projection = (Projection)ctx.queryBlock.getSingletonExpr(OpType.Projection);
        int finalTargetNum = projection.getNamedExprs().length;
        Target[] targets = new Target[finalTargetNum];
        if (LogicalPlanPreprocessor.hasAsterisk(projection.getNamedExprs())) {
            projection.setNamedExprs(LogicalPlanPreprocessor.voidResolveAsteriskNamedExpr(ctx, projection.getNamedExprs()));
        }
        for (int i = 0; i < finalTargetNum; ++i) {
            NamedExpr namedExpr = projection.getNamedExprs()[i];
            EvalNode evalNode = this.annotator.createEvalNode(ctx, namedExpr.getExpr(), NameResolvingMode.SUBEXPRS_AND_RELS);
            targets[i] = namedExpr.hasAlias() ? new Target(evalNode, namedExpr.getAlias()) : new Target(evalNode, "?name_" + i);
        }
        stack.pop();
        GroupbyNode groupByNode = ctx.plan.createNode(GroupbyNode.class);
        groupByNode.setInSchema(child.getOutSchema());
        groupByNode.setOutSchema(PlannerUtil.targetToSchema(targets));
        return groupByNode;
    }

    @Override
    public LogicalNode visitUnion(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, SetOperation expr) throws PlanningException {
        LogicalPlan.QueryBlock leftBlock = ctx.plan.newQueryBlock();
        LogicalPlanner.PlanContext leftContext = new LogicalPlanner.PlanContext(ctx, leftBlock);
        LogicalNode leftChild = (LogicalNode)this.visit(leftContext, new Stack<Expr>(), expr.getLeft());
        leftBlock.setRoot(leftChild);
        ctx.queryBlock.registerExprWithNode(expr.getLeft(), leftChild);
        LogicalPlan.QueryBlock rightBlock = ctx.plan.newQueryBlock();
        LogicalPlanner.PlanContext rightContext = new LogicalPlanner.PlanContext(ctx, rightBlock);
        LogicalNode rightChild = (LogicalNode)this.visit(rightContext, new Stack<Expr>(), expr.getRight());
        rightBlock.setRoot(rightChild);
        ctx.queryBlock.registerExprWithNode(expr.getRight(), rightChild);
        UnionNode unionNode = new UnionNode(ctx.plan.newPID());
        unionNode.setLeftChild(leftChild);
        unionNode.setRightChild(rightChild);
        unionNode.setInSchema(leftChild.getOutSchema());
        unionNode.setOutSchema(leftChild.getOutSchema());
        return unionNode;
    }

    @Override
    public LogicalNode visitFilter(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Selection expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode child = (LogicalNode)this.visit(ctx, stack, expr.getChild());
        stack.pop();
        SelectionNode selectionNode = ctx.plan.createNode(SelectionNode.class);
        selectionNode.setInSchema(child.getOutSchema());
        selectionNode.setOutSchema(child.getOutSchema());
        return selectionNode;
    }

    @Override
    public LogicalNode visitJoin(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Join expr) throws PlanningException {
        stack.push((Expr)expr);
        LogicalNode left = (LogicalNode)this.visit(ctx, stack, expr.getLeft());
        LogicalNode right = (LogicalNode)this.visit(ctx, stack, expr.getRight());
        stack.pop();
        JoinNode joinNode = ctx.plan.createNode(JoinNode.class);
        joinNode.setJoinType(expr.getJoinType());
        Schema merged = SchemaUtil.merge((Schema)left.getOutSchema(), (Schema)right.getOutSchema());
        joinNode.setInSchema(merged);
        joinNode.setOutSchema(merged);
        ctx.queryBlock.addJoinType(expr.getJoinType());
        return joinNode;
    }

    @Override
    public LogicalNode visitRelation(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Relation expr) throws PlanningException {
        Relation relation = expr;
        String actualRelationName = CatalogUtil.isFQTableName((String)expr.getName()) ? relation.getName() : CatalogUtil.buildFQName((String[])new String[]{ctx.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), relation.getName()});
        TableDesc desc = this.catalog.getTableDesc(actualRelationName);
        ScanNode scanNode = ctx.plan.createNode(ScanNode.class);
        if (relation.hasAlias()) {
            scanNode.init(desc, relation.getAlias());
        } else {
            scanNode.init(desc);
        }
        ctx.queryBlock.addRelation(scanNode);
        return scanNode;
    }

    @Override
    public LogicalNode visitTableSubQuery(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, TablePrimarySubQuery expr) throws PlanningException {
        LogicalPlan.QueryBlock queryBlock = ctx.plan.newQueryBlock();
        LogicalPlanner.PlanContext newContext = new LogicalPlanner.PlanContext(ctx, queryBlock);
        LogicalNode child = (LogicalNode)super.visitTableSubQuery(newContext, stack, expr);
        queryBlock.setRoot(child);
        TableSubQueryNode node = ctx.plan.createNode(TableSubQueryNode.class);
        node.init(CatalogUtil.buildFQName((String[])new String[]{ctx.queryContext.get((ConfigKey)SessionVars.CURRENT_DATABASE), expr.getName()}), child);
        ctx.queryBlock.addRelation(node);
        return node;
    }

    @Override
    public LogicalNode visitCreateDatabase(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, CreateDatabase expr) throws PlanningException {
        CreateDatabaseNode createDatabaseNode = ctx.plan.createNode(CreateDatabaseNode.class);
        return createDatabaseNode;
    }

    @Override
    public LogicalNode visitDropDatabase(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, DropDatabase expr) throws PlanningException {
        DropDatabaseNode dropDatabaseNode = ctx.plan.createNode(DropDatabaseNode.class);
        return dropDatabaseNode;
    }

    @Override
    public LogicalNode visitCreateTable(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, CreateTable expr) throws PlanningException {
        CreateTableNode createTableNode = ctx.plan.createNode(CreateTableNode.class);
        if (expr.hasSubQuery()) {
            stack.push((Expr)expr);
            this.visit(ctx, stack, expr.getSubQuery());
            stack.pop();
        }
        return createTableNode;
    }

    @Override
    public LogicalNode visitDropTable(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, DropTable expr) throws PlanningException {
        DropTableNode dropTable = ctx.plan.createNode(DropTableNode.class);
        return dropTable;
    }

    @Override
    public LogicalNode visitAlterTablespace(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, AlterTablespace expr) throws PlanningException {
        AlterTablespaceNode alterTablespace = ctx.plan.createNode(AlterTablespaceNode.class);
        return alterTablespace;
    }

    @Override
    public LogicalNode visitAlterTable(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, AlterTable expr) throws PlanningException {
        AlterTableNode alterTableNode = ctx.plan.createNode(AlterTableNode.class);
        return alterTableNode;
    }

    @Override
    public LogicalNode visitTruncateTable(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, TruncateTable expr) throws PlanningException {
        TruncateTableNode truncateTableNode = ctx.plan.createNode(TruncateTableNode.class);
        return truncateTableNode;
    }

    @Override
    public LogicalNode visitInsert(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, Insert expr) throws PlanningException {
        LogicalNode child = (LogicalNode)super.visitInsert(ctx, stack, expr);
        InsertNode insertNode = new InsertNode(ctx.plan.newPID());
        insertNode.setInSchema(child.getOutSchema());
        insertNode.setOutSchema(child.getOutSchema());
        return insertNode;
    }

    static class NameRefInSelectListNormalizer
    extends SimpleAlgebraVisitor<LogicalPlanner.PlanContext, Object> {
        private static final NameRefInSelectListNormalizer instance = new NameRefInSelectListNormalizer();

        NameRefInSelectListNormalizer() {
        }

        public static void normalize(LogicalPlanner.PlanContext context, Expr expr) throws PlanningException {
            NameRefInSelectListNormalizer normalizer = new NameRefInSelectListNormalizer();
            normalizer.visit(context, new Stack<Expr>(), expr);
        }

        @Override
        public Expr visitColumnReference(LogicalPlanner.PlanContext ctx, Stack<Expr> stack, ColumnReferenceExpr expr) throws PlanningException {
            String normalized = NameResolver.resolve(ctx.plan, ctx.queryBlock, expr, NameResolvingMode.RELS_ONLY).getQualifiedName();
            expr.setName(normalized);
            return expr;
        }
    }
}

